/*
 * Decompiled with CFR 0.152.
 */
package ts.internal.client.protocol;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import ts.client.CommandNames;
import ts.client.diagnostics.DiagnosticEvent;
import ts.client.projectinfo.ProjectInfo;
import ts.internal.client.protocol.GeterrForProjectRequestArgs;
import ts.internal.client.protocol.IRequestEventable;
import ts.internal.client.protocol.Request;
import ts.internal.client.protocol.Response;

public class GeterrForProjectRequest
extends Request<GeterrForProjectRequestArgs>
implements IRequestEventable<DiagnosticEvent> {
    private final transient ProjectInfo projectInfo;
    private final transient List<DiagnosticEvent> events;

    public GeterrForProjectRequest(String file, int delay, ProjectInfo projectInfo) {
        super(CommandNames.GeterrForProject.getName(), new GeterrForProjectRequestArgs(file, delay));
        this.projectInfo = projectInfo;
        this.events = new ArrayList<DiagnosticEvent>();
    }

    @Override
    public Response<?> parseResponse(JsonObject json) {
        return null;
    }

    @Override
    public List<String> getKeys() {
        List<String> files = this.projectInfo.getFileNames();
        ArrayList<String> keys = new ArrayList<String>((files.size() - 1) * 2);
        for (String file : files) {
            if (file.endsWith("lib.d.ts")) continue;
            keys.add("syntaxDiag_" + file);
            keys.add("semanticDiag_" + file);
        }
        return keys;
    }

    @Override
    public boolean accept(DiagnosticEvent event) {
        this.events.add(event);
        return this.events.size() >= this.getKeys().size();
    }

    @Override
    public List<DiagnosticEvent> getEvents() {
        return this.events;
    }
}

