/*
 * Decompiled with CFR 0.152.
 */
package ts.cmd.tslint;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ts.client.Location;
import ts.cmd.ITypeScriptLinterHandler;
import ts.cmd.Severity;
import ts.utils.StringUtils;

public class TslintHelper {
    private static final Pattern TSLINT_PATTERN = Pattern.compile("^\\(\\s*(.*)\\)\\s([^\\s].*)\\[(\\d+,\\s*\\d+)\\]:\\s*(.*)$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processVerboseMessage(String text, ITypeScriptLinterHandler handler) {
        if (StringUtils.isEmpty(text)) {
            return;
        }
        try (Scanner scanner = null;){
            scanner = new Scanner(text);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                Matcher m = TSLINT_PATTERN.matcher(line = line.trim());
                if (!m.matches()) continue;
                String code = m.group(1);
                String file = m.group(2);
                String[] location = m.group(3).split(",");
                Location startLoc = TslintHelper.createLocation(location, true);
                Location endLoc = null;
                String message = m.group(4);
                handler.addError(file, startLoc, endLoc, Severity.error, code, message);
            }
        }
    }

    private static Location createLocation(String[] location, boolean start) {
        if (start) {
            int line = TslintHelper.getInt(location, 0);
            int offset = TslintHelper.getInt(location, 1);
            return new Location(line, offset);
        }
        return null;
    }

    private static int getInt(String[] location, int index) {
        if (index < location.length) {
            return Integer.parseInt(location[index].trim());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processJsonMessage(String text, ITypeScriptLinterHandler handler) {
        if (StringUtils.isEmpty(text)) {
            return;
        }
        try (Scanner scanner = null;){
            scanner = new Scanner(text);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                line = line.trim();
                JsonArray array = Json.parse((String)line).asArray();
                for (JsonValue value : array) {
                    JsonObject item = value.asObject();
                    String name = item.getString("name", null);
                    String ruleName = item.getString("ruleName", null);
                    String failure = item.getString("failure", null);
                    Location startLoc = TslintHelper.createLocation(item.get("startPosition"));
                    Location endLoc = TslintHelper.createLocation(item.get("endPosition"));
                    handler.addError(name, startLoc, endLoc, Severity.error, ruleName, failure);
                }
            }
        }
    }

    private static Location createLocation(JsonValue value) {
        if (value == null || !value.isObject()) {
            return null;
        }
        JsonObject loc = value.asObject();
        return new Location(loc.getInt("line", -1), loc.getInt("character", -1), loc.getInt("position", -1));
    }
}

