/*
 * Decompiled with CFR 0.152.
 */
package ts.cmd.tsc;

import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ts.client.Location;
import ts.cmd.Severity;
import ts.cmd.tsc.ITypeScriptCompilerMessageHandler;
import ts.utils.StringUtils;

public class TypeScriptCompilerHelper {
    private static final Pattern TSC_ERROR_PATTERN = Pattern.compile("^([^\\s].*)\\((\\d+|\\d+,\\d+|\\d+,\\d+,\\d+,\\d+)\\):\\s+(error|warning|info)\\s+(TS\\d+)\\s*:\\s*(.*)$");
    private static final String COMPILATION_COMPLETE_WATCHING_FOR_FILE_CHANGES = "Compilation complete. Watching for file changes.";
    private static final String TSFILE = "TSFILE:";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processMessage(String text, ITypeScriptCompilerMessageHandler handler) {
        if (StringUtils.isEmpty(text)) {
            return;
        }
        try (Scanner scanner = null;){
            scanner = new Scanner(text);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if ((line = line.trim()).endsWith("ts") || line.endsWith("tsx")) {
                    handler.addFile(line, false);
                    continue;
                }
                if (line.contains(COMPILATION_COMPLETE_WATCHING_FOR_FILE_CHANGES)) {
                    handler.onCompilationCompleteWatchingForFileChanges();
                    continue;
                }
                if (line.startsWith(TSFILE)) {
                    handler.addFile(line.substring(TSFILE.length(), line.length()).trim(), true);
                    continue;
                }
                Matcher m = TSC_ERROR_PATTERN.matcher(line);
                if (!m.matches()) continue;
                String file = m.group(1);
                String[] location = m.group(2).split(",");
                Location startLoc = TypeScriptCompilerHelper.createLocation(location, true);
                Location endLoc = TypeScriptCompilerHelper.createLocation(location, false);
                String severity = m.group(3);
                String code = m.group(4);
                String message = m.group(5);
                handler.addError(file, startLoc, endLoc, StringUtils.isEmpty(severity) ? Severity.info : Severity.valueOf(severity), code, message);
            }
        }
    }

    private static Location createLocation(String[] location, boolean start) {
        if (start) {
            int line = TypeScriptCompilerHelper.getInt(location, 0);
            int offset = TypeScriptCompilerHelper.getInt(location, 1);
            return new Location(line, offset);
        }
        return null;
    }

    private static int getInt(String[] location, int index) {
        if (index < location.length) {
            return Integer.parseInt(location[index]);
        }
        return 0;
    }
}

