/*
 * Decompiled with CFR 0.152.
 */
package ts.client.navbar;

import java.util.List;
import ts.client.IKindProvider;
import ts.client.navbar.NavigationTextSpan;

public class NavigationBarItem
implements IKindProvider {
    private String text;
    private String kind;
    private String kindModifiers;
    private List<NavigationTextSpan> spans;
    private List<NavigationBarItem> childItems;
    private boolean parentAlreadyUpdated;
    NavigationBarItem parent;

    public String getText() {
        return this.text;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public String getKindModifiers() {
        return this.kindModifiers;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setSpans(List<NavigationTextSpan> spans) {
        this.spans = spans;
        this.parentAlreadyUpdated = false;
    }

    public List<NavigationTextSpan> getSpans() {
        this.updateParentIfNeeded();
        return this.spans;
    }

    public boolean hasSpans() {
        return this.spans != null && this.spans.size() > 0;
    }

    public List<NavigationBarItem> getChildItems() {
        this.updateParentIfNeeded();
        return this.childItems;
    }

    private void updateParentIfNeeded() {
        if (!this.parentAlreadyUpdated) {
            if (this.childItems != null) {
                for (NavigationBarItem item : this.childItems) {
                    item.parent = this;
                }
            }
            if (this.spans != null) {
                for (NavigationTextSpan span : this.spans) {
                    span.parent = this;
                }
            }
            this.parentAlreadyUpdated = true;
        }
    }

    public void setChildItems(List<NavigationBarItem> childItems) {
        this.childItems = childItems;
        this.parentAlreadyUpdated = false;
    }

    public boolean hasChildItems() {
        return this.childItems != null && this.childItems.size() > 0;
    }

    public NavigationBarItem getParent() {
        return this.parent;
    }
}

