/*
 * Decompiled with CFR 0.152.
 */
package ts.client.diagnostics;

import ts.client.Location;
import ts.utils.StringUtils;

public interface IDiagnostic {
    public String getText();

    public String getFullText();

    public Location getStartLocation();

    public Location getEndLocation();

    public Integer getCode();

    public DiagnosticCategory getCategory();

    public String getSource();

    public static enum DiagnosticCategory {
        Warning,
        Error,
        Message;


        public static DiagnosticCategory getCategory(String category) {
            if (!StringUtils.isEmpty(category)) {
                DiagnosticCategory[] values = DiagnosticCategory.values();
                for (int i = 0; i < values.length; ++i) {
                    DiagnosticCategory c = values[i];
                    if (!category.equalsIgnoreCase(c.name())) continue;
                    return c;
                }
            }
            return Error;
        }
    }
}

