/*
 * Decompiled with CFR 0.152.
 */
package ts.client;

import ts.client.IInterceptor;
import ts.client.ITypeScriptServiceClient;
import ts.client.TypeScriptServiceClient;
import ts.internal.client.protocol.Request;
import ts.internal.client.protocol.Response;

public class LoggingInterceptor
implements IInterceptor {
    private static final IInterceptor INSTANCE = new LoggingInterceptor();

    public static IInterceptor getInstance() {
        return INSTANCE;
    }

    @Override
    public void handleRequest(Request<?> request, String json, ITypeScriptServiceClient client) {
        this.outPrintln("-----------------------------------");
        this.outPrintln("TypeScript request#" + request.getCommand() + ": ");
        this.outPrintln(json);
    }

    @Override
    public void handleResponse(Response<?> response, String json, long ellapsedTime, TypeScriptServiceClient typeScriptServiceClient) {
        this.outPrintln("");
        this.outPrintln("TypeScript response#" + response.getCommand() + " with " + ellapsedTime + "ms: ");
        this.outPrintln(json);
        this.outPrintln("-----------------------------------");
    }

    @Override
    public void handleError(Throwable error, ITypeScriptServiceClient server, String methodName, long ellapsedTime) {
        this.errPrintln("");
        this.errPrintln("TypeScript error#" + methodName + " with " + ellapsedTime + "ms: ");
        this.printStackTrace(error);
        this.errPrintln("-----------------------------------");
    }

    protected void outPrintln(String line) {
        System.out.println(line);
    }

    protected void errPrintln(String line) {
        System.err.println(line);
    }

    protected void printStackTrace(Throwable error) {
        error.printStackTrace(System.err);
    }
}

