/*
 * Decompiled with CFR 0.152.
 */
package ts.client;

import ts.TypeScriptException;
import ts.client.IPositionProvider;

public class Location {
    private static final int NO_POSITION = -1;
    private final IPositionProvider positionProvider;
    private int line;
    private int offset;
    private int position;

    public Location(IPositionProvider positionProvider) {
        this.positionProvider = positionProvider;
        this.position = -1;
    }

    public Location() {
        this(null);
    }

    public Location(int line, int offset, int position) {
        this();
        this.line = line;
        this.offset = offset;
        this.position = position;
    }

    public Location(int line, int offset) {
        this(line, offset, -1);
    }

    public int getLine() {
        return this.line;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getPosition() {
        if (this.position == -1 && this.positionProvider != null) {
            try {
                this.position = this.positionProvider.getPosition(this.line, this.offset);
            }
            catch (TypeScriptException e) {
                e.printStackTrace();
            }
        }
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }
}

