/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.dto.task;

import com.ktbyte.dto.TrackingTask;
import com.ktbyte.dto.task.TaskState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TaskQuery {
    private List<Integer> createdByPersonIds;
    private List<String> classSimpleNames;
    private List<TaskState> states;
    private List<String> steps;
    private List<Integer> assignedToPersonIds;
    private List<Integer> classSessionIds;
    private List<Integer> classSessionLessonTimeIds;
    private List<Integer> targetPersonId;
    private Long deadlineEpochSeconds;
    private boolean atMostOnePerField = true;

    public TaskQuery withPersonIds(Integer ... personIds) {
        this.createdByPersonIds = Arrays.asList(personIds);
        this.atMostOnePerField = this.atMostOnePerField && this.createdByPersonIds.size() <= 1;
        return this;
    }

    public TaskQuery withClassSimpleNames(String ... classSimpleNames) {
        this.classSimpleNames = Arrays.asList(classSimpleNames);
        this.atMostOnePerField = this.atMostOnePerField && this.classSimpleNames.size() <= 1;
        return this;
    }

    public TaskQuery withStates(TaskState ... states) {
        this.states = Arrays.asList(states);
        return this;
    }

    public TaskQuery withSteps(String ... steps) {
        this.steps = Arrays.asList(steps);
        this.atMostOnePerField = this.atMostOnePerField && this.steps.size() <= 1;
        return this;
    }

    public TaskQuery withAssignedToPersonIds(Integer ... assignedToPersonIds) {
        this.assignedToPersonIds = Arrays.asList(assignedToPersonIds);
        this.atMostOnePerField = this.atMostOnePerField && this.assignedToPersonIds.size() <= 1;
        return this;
    }

    public TaskQuery withClassSessionIds(Integer ... classSessionIds) {
        this.classSessionIds = Arrays.asList(classSessionIds);
        this.atMostOnePerField = this.atMostOnePerField && this.classSessionIds.size() <= 1;
        return this;
    }

    public TaskQuery withClassSessionLessonTimeIds(Integer ... classSessionLessonTimeIds) {
        this.classSessionLessonTimeIds = Arrays.asList(classSessionLessonTimeIds);
        this.atMostOnePerField = this.atMostOnePerField && this.classSessionLessonTimeIds.size() <= 1;
        return this;
    }

    public TaskQuery withTargetPersonId(Integer ... targetPersonId) {
        this.targetPersonId = Arrays.asList(targetPersonId);
        this.atMostOnePerField = this.atMostOnePerField && this.targetPersonId.size() <= 1;
        return this;
    }

    public TaskQuery withDeadlineBefore(long deadlineEpochSeconds) {
        this.deadlineEpochSeconds = deadlineEpochSeconds;
        return this;
    }

    public ActiveJDBCInputs buildQuery() {
        String[] fields = new String[]{"createdby_personid", "class_simple", "state", "step", "assignedto_personid", "class_session_id", "class_session_lesson_time_id", "target_personid"};
        List[] values = new List[]{this.createdByPersonIds, this.classSimpleNames, this.states, this.steps, this.assignedToPersonIds, this.classSessionIds, this.classSessionLessonTimeIds, this.targetPersonId};
        ArrayList<String> nonNullFields = new ArrayList<String>();
        ArrayList<String> nonNullValues = new ArrayList<String>();
        for (int i = 0; i < fields.length; ++i) {
            if (values[i] == null) continue;
            nonNullFields.add("FIND_IN_SET(" + fields[i] + ", ?)");
            nonNullValues.add(TaskQuery.join(values[i], ","));
        }
        if (this.deadlineEpochSeconds != null) {
            nonNullFields.add("(UNIX_TIMESTAMP(deadline) <= ? OR deadline IS NULL)");
            nonNullValues.add("" + this.deadlineEpochSeconds);
        }
        String query = TaskQuery.join(nonNullFields, " AND ");
        ActiveJDBCInputs q = new ActiveJDBCInputs();
        q.query = query;
        q.params = nonNullValues.toArray();
        return q;
    }

    public TrackingTask toTrackingTask() {
        TrackingTask t = new TrackingTask();
        if (this.createdByPersonIds != null) {
            t.createdByPersonId = this.createdByPersonIds.get(0);
        }
        if (this.classSimpleNames != null) {
            t.simpleTaskName = this.classSimpleNames.get(0);
        }
        if (this.steps != null) {
            t.step = this.steps.get(0);
        }
        if (this.classSessionIds != null) {
            t.classSessionId = this.classSessionIds.get(0);
        }
        if (this.classSessionLessonTimeIds != null) {
            t.classSessionLessonTimeId = this.classSessionLessonTimeIds.get(0);
        }
        if (this.assignedToPersonIds != null) {
            t.assignedToPersonId = this.assignedToPersonIds.get(0);
        }
        if (this.targetPersonId != null) {
            t.targetPersonId = this.targetPersonId.get(0);
        }
        return t;
    }

    private static String join(List<?> values, String delimiter) {
        StringBuilder s = new StringBuilder();
        for (Object value : values) {
            if (s.length() == 0) {
                s.append(value.toString());
                continue;
            }
            s.append(delimiter).append(value);
        }
        return s.toString();
    }

    public static class ActiveJDBCInputs {
        public String query;
        public Object[] params;
    }
}

