/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.dto;

import java.util.HashMap;
import java.util.Map;

public enum PaymentType {
    CREDIT_CARD("card"),
    WECHAT("wechat"),
    ALIPAY("alipay");

    private final String value;
    private static final Map<String, PaymentType> lookup;

    public static PaymentType getFromValue(String abbreviation) {
        return lookup.get(abbreviation);
    }

    private PaymentType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    static {
        lookup = new HashMap<String, PaymentType>();
        for (PaymentType type : PaymentType.values()) {
            lookup.put(type.getValue(), type);
        }
    }
}

