/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.dto;

import com.ktbyte.dto.KtbyteEarthUser;
import com.ktbyte.dto.PsetInfo;
import com.ktbyte.dto.classsession.KtbyteCurriculum;
import com.ktbyte.dto.earthmodels.ClassSessionLessonTimeDto;
import java.util.List;

public class LessonDto {
    final int classSessionId;
    final List<KtbyteEarthUser> instructors;
    final ClassSessionLessonTimeDto classSessionLessonTime;
    final KtbyteCurriculum curriculum;
    final String classSessionSerialized;
    final List<PsetInfo> psets;
    final int dghCount;
    final int dglCount;
    final int nghCount;
    final int nglCount;
    final int dbhCount;
    final int dblCount;
    final int nbhCount;
    final int nblCount;
    final double ghAvg;
    final double glAvg;
    final double bhAvg;
    final double blAvg;
    final int studentCount;

    public LessonDto(int classSessionId, List<KtbyteEarthUser> instructors, ClassSessionLessonTimeDto classSessionLessonTime, KtbyteCurriculum curriculum, String classSessionSerialized, List<PsetInfo> psets, int studentCount) {
        this.classSessionId = classSessionId;
        this.instructors = instructors;
        this.classSessionLessonTime = classSessionLessonTime;
        this.curriculum = curriculum;
        this.classSessionSerialized = classSessionSerialized;
        this.psets = psets;
        this.dghCount = LessonDto.count(psets, true, true, false);
        this.dglCount = LessonDto.count(psets, true, true, true);
        this.nghCount = LessonDto.count(psets, false, true, false);
        this.nglCount = LessonDto.count(psets, false, true, true);
        this.dbhCount = LessonDto.count(psets, true, false, false);
        this.dblCount = LessonDto.count(psets, true, false, true);
        this.nbhCount = LessonDto.count(psets, false, false, false);
        this.nblCount = LessonDto.count(psets, false, false, true);
        this.ghAvg = LessonDto.averageGrade(psets, true, false);
        this.glAvg = LessonDto.averageGrade(psets, true, true);
        this.bhAvg = LessonDto.averageGrade(psets, false, false);
        this.blAvg = LessonDto.averageGrade(psets, false, true);
        this.studentCount = studentCount;
    }

    static int count(List<PsetInfo> psets, boolean done, boolean good, boolean classwork) {
        int result = 0;
        for (PsetInfo pset : psets) {
            if (pset.done != done || pset.good != good || pset.type == PsetInfo.Type.LECTURE != classwork) continue;
            ++result;
        }
        return result;
    }

    static double averageGrade(List<PsetInfo> psets, boolean good, boolean classwork) {
        double sum = 0.0;
        long count = 0L;
        for (PsetInfo pset : psets) {
            if (pset.good != good || pset.type == PsetInfo.Type.LECTURE != classwork) continue;
            sum += (double)pset.averageGrade;
            ++count;
        }
        return count > 0L ? sum / (double)count : 0.0;
    }
}

