declare class FreeTrialTimeSlotsService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    createTimeSlots(epochs: Array<number>, teacherPersonId: number, classEnvironment: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    findAllBetweenEpochs(startEpoch: number, endEpoch: number, successHandler: (result: ResponseSuccess<Array<FreeTrialTimeSlotDto>>) => void, errorHandler?: (error: DTOException) => void): void;
    findAllByUserBetweenEpochs(userPersonId: number, startEpoch: number, endEpoch: number, successHandler: (result: ResponseSuccess<Array<FreeTrialTimeSlotDto>>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllBetweenTimes(startEpoch: number, endEpoch: number, successHandler: (result: ResponseSuccess<Array<FreeTrialTimeSlotDto>>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllGeneratedBetweenTimes(startEpoch: number, endEpoch: number, successHandler: (result: ResponseSuccess<Array<FreeTrialTimeSlotDto>>) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMap(ids: Array<number>, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    getNearestTrialTimeSlotDto(roomId: number, epochMillis: number, successHandler: (result: ResponseSuccess<FreeTrialTimeSlotDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class KtbyteEarthService {
    addTag(personId: number, tag: string, triggeredByPersonId: number, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    getAllClassSessionSets(successHandler: (result: Array<ClassSessionSetDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllClassSessions(successHandler: (result: Array<ClassSessionDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllUsers(successHandler: (result: KtbyteEarthUserList) => void, errorHandler?: (error: DTOException) => void): void;
    getClassSession(sessionSerialized: string, successHandler: (result: KtbyteClassSession) => void, errorHandler?: (error: DTOException) => void): void;
    getClassSessionById(classSessionId: number, successHandler: (result: KtbyteClassSession) => void, errorHandler?: (error: DTOException) => void): void;
    getEnrolledStudentsMapForOpenClassSessions(successHandler: (result: EnrolledStudentMap) => void, errorHandler?: (error: DTOException) => void): void;
    getPartnerPersonIds(successHandler: (result: Array<number>) => void, errorHandler?: (error: DTOException) => void): void;
    getUsers(personIds: Array<number>, successHandler: (result: KtbyteEarthUserList) => void, errorHandler?: (error: DTOException) => void): void;
    removeTag(personId: number, tag: string, triggeredByPersonId: number, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    vmmCallsThisToUpdateTfNodeForMagAndPcs(tfNodeId: number, name: string, ip_address: string, magPort: number, pcsPort: number, isChina: boolean, numCores: number, enabled: boolean, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class ClassSessionMakeInstructorService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class TofuLeadsService {
    attributePersonToAd(crmId: number, adId: number, triggeredByPersonId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    createGeoInfoForCrmId(dto: GeoInfoDto, successHandler: (result: ResponseSuccess<void>) => void, errorHandler?: (error: DTOException) => void): void;
    createTofuLead(dto: WeChatCustomerInfo, urlEncodedEncryptedCrmId: string, successHandler: (result: ResponseSuccess<void>) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    deleteAllUnusedHeardFroms(successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    deleteByCrmId(crmId: number, successHandler: (result: ResponseSuccess<void>) => void, errorHandler?: (error: DTOException) => void): void;
    fetchCustomerList(requiredCustomerCrmIds: Array<number>, loadedCustomerCrmIds: Array<number>, pageSize: number, filter: WeChatCustomerSearchFilterDto, successHandler: (result: Array<WeChatCustomerInfo>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllAgentResponseTemplates(successHandler: (result: Array<AgentResponseTemplateDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllAssignees(successHandler: (result: Array<KtbyteEarthUser>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllContactMethods(successHandler: (result: Array<string>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllHearFromOptions(successHandler: (result: Array<HeardFromSourceDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTags(successHandler: (result: Array<TofuTagDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllUnusedHeardFroms(successHandler: (result: Array<HeardFromSourceDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getChatMessageBinaryData(chatMessageId: number, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    getCurrentStudentParents(studentIds: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getCustomQrCode(qrCodeMetadata: number, successHandler: (result: WeChatCustomQRCodeResponse) => void, errorHandler?: (error: DTOException) => void): void;
    getEncryptedCrmLink(crmId: number, isChineseFormat: boolean, successHandler: (result: ResponseSuccess<string>) => void, errorHandler?: (error: DTOException) => void): void;
    getIsAutomatedMessagingOn(successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getListOfTofuLeadsRelatedToAdId(adId: number, successHandler: (result: ResponseSuccess<Array<FunnelLeadDto>>) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getNonOperationalEndTime(successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    getNonOperationalHoursLabel(successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    getNonOperationalStartTime(successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    getNotesAndMessagesByTofuId(tofuId: number, sinceEpochTimeSeconds: number, successHandler: (result: NotesAndMessages) => void, errorHandler?: (error: DTOException) => void): void;
    getNumberOfReplySoons(successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOneByCrmId(id: number, successHandler: (result: ResponseSuccess<WeChatCustomerInfo>) => void, errorHandler?: (error: DTOException) => void): void;
    getOneByEncryptedCrmId(encryptedCrmId: string, successHandler: (result: ResponseSuccess<WeChatCustomerInfo>) => void, errorHandler?: (error: DTOException) => void): void;
    getStatsForAdId(adId: number, successHandler: (result: ResponseSuccess<AdDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    getTofuToBofuSankeyStats(successHandler: (result: ResponseSuccess<SankeyStatsDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getUnattributedPeople(successHandler: (result: ResponseSuccess<Array<AdAttributionDto>>) => void, errorHandler?: (error: DTOException) => void): void;
    getWeChatyContacts(agentUsername: string, successHandler: (result: Array<WeChatyContact>) => void, errorHandler?: (error: DTOException) => void): void;
    getWeChatyUsernames(successHandler: (result: Array<string>) => void, errorHandler?: (error: DTOException) => void): void;
    mergeCustomers(crmIdIfTofuToKeep: number, crmIdOfTofuToDiscard: number, successHandler: (result: ResponseSuccess<WeChatCustomerInfo>) => void, errorHandler?: (error: DTOException) => void): void;
    restartPolaris(wechatyUsernmae: string, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    searchCustomers(query: string, filter: WeChatCustomerSearchFilterDto, successHandler: (result: ResponseSuccess<WeChatCustomerSearchResult>) => void, errorHandler?: (error: DTOException) => void): void;
    searchCustomersByChatOrNotesHistory(query: string, filterDto: WeChatCustomerSearchFilterDto, successHandler: (result: ResponseSuccess<WeChatCustomerSearchResult>) => void, errorHandler?: (error: DTOException) => void): void;
    sendAgentChatMessage(studentId: number, message: string, triggeredByPersonId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    setNonOperationalEndTime(hours: number, minutes: number, successHandler: (result: ResponseSuccess<void>) => void, errorHandler?: (error: DTOException) => void): void;
    setNonOperationalStartTime(hours: number, minutes: number, successHandler: (result: ResponseSuccess<void>) => void, errorHandler?: (error: DTOException) => void): void;
    toggleAutomatedMessaging(successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    updateTofuLeadCrmAndParentStudentPersonIds(oldCrmId: number, parentPersonId: number, studentPersonId: number, byPersonId: number, successHandler: (result: ResponseSuccess<void>) => void, errorHandler?: (error: DTOException) => void): void;
    updateTofuLeadCrmAndTrialIds(oldCrmId: number, newTrialId: number, successHandler: (result: ResponseSuccess<void>) => void, errorHandler?: (error: DTOException) => void): void;
    updateTofuLeadIsChecked(id: number, shouldStar: boolean, successHandler: (result: ResponseSuccess<void>) => void, errorHandler?: (error: DTOException) => void): void;
    updateTofuLeadIsHidden(crmId: number, shouldHide: boolean, successHandler: (result: ResponseSuccess<void>) => void, errorHandler?: (error: DTOException) => void): void;
    updateTofuLeadIsStarred(id: number, shouldStar: boolean, successHandler: (result: ResponseSuccess<void>) => void, errorHandler?: (error: DTOException) => void): void;
    updateTofuLeadPin(id: number, shouldPin: boolean, successHandler: (result: ResponseSuccess<void>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class VMMService {
    adminGetDesktops(successHandler: (result: Array<DesktopDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    deleteCloudVirtualDesktop(personId: number, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    emergencyStopCloudVirtualDesktop(personId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    emergencyUnmountCloudVirtualDesktop(personId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    getCloudVirtualDesktop(personId: number, name: string, isChina: boolean, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    getCloudVirtualDesktopParameters(personId: number, successHandler: (result: DesktopConfig) => void, errorHandler?: (error: DTOException) => void): void;
    getCloudVirtualDesktopStateAndURL(personId: number, successHandler: (result: DesktopStateAndURL) => void, errorHandler?: (error: DTOException) => void): void;
    getStatus(successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    restartAnnexServer(hostname: string, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    startCloudVirtualDesktop(personId: number, name: string, isChina: boolean, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    stopCloudVirtualDesktop(personId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class CheckoutService {
    addExtended(cartItemId: number, couponCode: string, referralCode: string, successHandler: (result: ResponseSuccess<CheckoutBatch>) => void, errorHandler?: (error: DTOException) => void): void;
    checkout(couponCode: string, referralCode: string, modeOfPayment: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    deleteCartItem(itemId: number, couponCode: string, referralCode: string, successHandler: (result: ResponseSuccess<CheckoutBatch>) => void, errorHandler?: (error: DTOException) => void): void;
    getCheckoutPriceData(submittedDiscountCode: string, appliedCouponCode: string, appliedReferralCode: string, successHandler: (result: ResponseSuccess<CheckoutPriceData>) => void, errorHandler?: (error: DTOException) => void): void;
    getPaymentTypeToStripeAccount(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getPricesClassSessions(ids: number[], couponCode: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    initCheckout(successHandler: (result: ResponseSuccess<CheckoutBatch>) => void, errorHandler?: (error: DTOException) => void): void;
    logWechatSourceChargeable(sourceId: string, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    processStripeCreditCardPayment(action: string, tokenId: string, couponCode: string, referralCode: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    recordStripeSource(paymentTypeVal: string, sourceId: string, couponCode: string, referralCode: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    sendDeniedEmail(deniedTerm: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    updatePhotoRelease(successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    updateTrialCartItem(cartItemId: number, trialInfo: FreeTrialChild, couponCode: string, referralCode: string, successHandler: (result: ResponseSuccess<CheckoutBatch>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class ClassSessionMakeLocationService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class CrmClassRecommendationService {
    getRecommendation(studenntId: number, classSessionId: number, successHandler: (result: ClassRecommendationModelDto) => void, errorHandler?: (error: DTOException) => void): void;
    getRecommendationsByClassSessionIds(classSessionIds: Array<number>, successHandler: (result: Array<ClassRecommendationModelDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getRecommendationsByStudentIds(studentIds: Array<number>, successHandler: (result: Array<ClassRecommendationModelDto>) => void, errorHandler?: (error: DTOException) => void): void;
    setRecommendation(dto: ClassRecommendationModelDto, successHandler: (result: ClassRecommendationModelDto) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class PermissionedCrudService {
    path: string;
    constructor(path: string);
    create(data: any, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    getCallerRoles(successHandler: (result: Role[]) => void, errorHandler?: (error: DTOException) => void): void;
    getDTOClass(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: ResponseSuccess<GetListResponseDto<any>>) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: ResponseSuccess<Array<any>>) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, newValue: any, oldValue: any, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class ClassSessionsService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class KtbyteCrmTaskService {
    addTaskWorklog(taskId: number, personId: number, description: string, successHandler: (result: TrackingTask) => void, errorHandler?: (error: DTOException) => void): void;
    countAllTasksBy(query: TaskQuery, successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    createTask(createdbyPersonId: number, taskSimpleName: string, dataJson: string, deadlineEpochSeconds: number, priority: number, state: string, step: string, assignedToPersonId: number, classSessionId: number, classSessionLessonTimeId: number, targetPersonId: number, successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    deleteTasksPLEASE_USE_ONLY_FOR_TESTING(taskIds: Array<number>, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    findPersonNamesById(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getAllAdminOpenTasks(requesterId: number, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllJobs(successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllNonStaleTasksByCategory(category: string, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllOpenJobs(successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllOpenTasksByTitle(titleShort: string, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksAssignedTo(personId: number, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksAssignedToPersonWithState(personId: number, state: string, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksAssignedToPersonWithStates(personId: number, state: string[], successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksBy(query: TaskQuery, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksByCategory(category: string, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksByCategoryAndState(category: string, states: string[], successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksByClassSession(classSessionId: number, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksByClassSessionLessonTime(classSessionLessonTimeId: number, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksBySimpleAndState(categories: Array<string>, state: string, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksByTargetPersonId(targetPersonId: number, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksByTargetPersonIds(targetPersonIds: Array<number>, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksByTitle(titleShort: string, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksCreatedBy(personId: number, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksCreatedByPersonWithState(personId: number, state: string, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getTask(taskId: number, personIdOfRequester: number, isAdmin: boolean, successHandler: (result: TrackingTask) => void, errorHandler?: (error: DTOException) => void): void;
    getTaskCountBy(query: TaskQuery, successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    getTaskWorklog(taskIds: Array<number>, successHandler: (result: Array<TaskWorklogDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    getTasks(taskId: Array<number>, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getWhatIs3Plus2FOREAL(successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    markEmailRead(emailId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    reassignOpsFreeTrialTask(taskId: number, fTrialId: number, timeSlotId: number, assignedId: number, availableStaff: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    sendEmailRelatedToTask(personId: number, taskId: number, sendToCreator: boolean, sendToAssignee: boolean, sendToTeam: boolean, sendToParents: boolean, subject: string, body: string, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    sendTextAsAdmin(personId: number, phoneNumbers: Array<string>, personIds: Array<number>, body: string, sendToFirstPhoneNumberOnly: boolean, successHandler: (result: Array<string>) => void, errorHandler?: (error: DTOException) => void): void;
    sendTextAsAdminWithSecondary(senderPersonId: number, phoneNumbers: Array<string>, personIds: Array<number>, body: string, sendToFirstPhoneNumberOnly: boolean, useSecondaryPhoneNumber: boolean, successHandler: (result: Array<string>) => void, errorHandler?: (error: DTOException) => void): void;
    setEmailSentForTask(taskId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    updateOrCreateTaskByQuery(query: TaskQuery, createdByPersonId: number, assignedToPersonId: number, dataJson: string, priority: number, state: TaskState, step: string, deadlineEpochDeadline: number, successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    updateTask(taskId: number, taskState: string, byPersonId: number, successHandler: (result: TrackingTask) => void, errorHandler?: (error: DTOException) => void): void;
    updateTaskAssignment(taskId: number, assignedByPersonId: number, assigneePersonId: number, successHandler: (result: TrackingTask) => void, errorHandler?: (error: DTOException) => void): void;
    updateTaskById(taskId: number, assignedToPersonId: number, dataJson: string, priority: number, state: TaskState, step: string, deadlineEpochSeconds: number, byPersonId: number, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    updateTaskByQuery(query: TaskQuery, assignedToPersonId: number, dataJson: string, priority: number, state: TaskState, step: string, deadlineEpochSeconds: number, byPersonId: number, successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    updateTaskData(taskId: number, dataJson: string, byPersonId: number, successHandler: (result: TrackingTask) => void, errorHandler?: (error: DTOException) => void): void;
    updateTaskNotified(taskId: number, notified: boolean, successHandler: (result: TrackingTask) => void, errorHandler?: (error: DTOException) => void): void;
    updateTaskStep(taskId: number, personId: number, step: string, successHandler: (result: TrackingTask) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class EmailService {
    sendDirectToPersonEmail(recipientEmail: string, recipientFirstName: string, emailSubject: string, emailBody: string, emailSignature: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    sendEnrollmentConfirmationEmail(recipientPersonId: number, studentPersonId: number, classSessionId: number, totalPaid: number, enumPaymentMethod: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    sendStudentVmIsMissingEmail(successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class KtbyteEarthReplicationService {
    getMissingData(tableClassName: string, slaveMaxAllTimeMs: number, slaveMaxNonmasterTimeMs: number, fetchAllMissing: boolean, fetchMatchingMissing: boolean, successHandler: (result: ReplicationTableData) => void, errorHandler?: (error: DTOException) => void): void;
    getMissingDataBatch(request: ReplicationMissingDataBatchRequest, successHandler: (result: ReplicationMissingDataBatchResponse) => void, errorHandler?: (error: DTOException) => void): void;
    getReplicationId(successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    getReplicationInfo(successHandler: (result: ReplicationInfo) => void, errorHandler?: (error: DTOException) => void): void;
    getReplicationStatusHashes(request: ReplicationStatusRequestDTO, successHandler: (result: ReplicationStatusResponseDTO) => void, errorHandler?: (error: DTOException) => void): void;
    getReplicationStatusRows(tableName: string, rowIds: number[], setMasterTime: boolean, successHandler: (result: ReplicationTableData) => void, errorHandler?: (error: DTOException) => void): void;
    getReplicationTableSpecificInfo(successHandler: (result: ReplicationTableSpecificInfo) => void, errorHandler?: (error: DTOException) => void): void;
    getTableHash(tableClassName: string, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    setReplicationDifferences(request: ReplicationTableData, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class CrmFreeTrialsService {
    addNote(freeTrialId: number, text: string, authorPersonId: number, successHandler: (result: ResponseSuccess<boolean>) => void, errorHandler?: (error: DTOException) => void): void;
    approveInstructorFeedback(taskId: number, freeTrialId: number, instructorFeedbackDto: SubmitFreeTrialFollowUpDto, byPersonId: number, successHandler: (result: FreeTrialDTO) => void, errorHandler?: (error: DTOException) => void): void;
    assignFreeTrialInstructor(freeTrialId: number, teacherPersonId: number, byPersonId: number, successHandler: (result: ResponseSuccess<FreeTrialDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    cancelFreeTrial(freeTrialId: number, byPersonId: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    confirmationRemindersSent(id: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    createFreeTrialFromParentAvailability(taskId: number, freeTrialDTO: FreeTrialDTO, successHandler: (result: ResponseSuccess<FreeTrialDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    createFreeTrialFromTimeSlot(trialChild: FreeTrialChild, parentRow: KtbyteCrmRow, geoSummaryJson: string, isChina: boolean, successHandler: (result: FreeTrialDTO) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    findAllUpcoming(successHandler: (result: Array<FreeTrialDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    findFreeTrialByStudentPersonId(personId: number, successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    getAllByParentPersonId(parentPersonId: number, successHandler: (result: ResponseSuccess<Array<FreeTrialDTO>>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllHearFromOptions(successHandler: (result: Array<HeardFromSourceDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllLocationOptions(successHandler: (result: Array<string>) => void, errorHandler?: (error: DTOException) => void): void;
    getChildrenAllByParentPersonId(parentPersonId: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getClassTypeRecommendation(freeTrialId: number, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    getFreeTrialsByUserBetweenEpochs(userPersonId: number, startTime: number, endTime: number, successHandler: (result: Array<FreeTrialDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    getFreeTrialsMissingFeedback(successHandler: (result: Array<FreeTrialDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    getFreeTrialsOnDate(date: string, excludeReminderSentTrials: boolean, successHandler: (result: Array<FreeTrialDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    getFreeTrialsStarting(inNextHours: number, excludeStaffReminded: boolean, successHandler: (result: Array<FreeTrialDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    getFreeTrialsWithEnrollmentStatus(enrollmentStatus: string, successHandler: (result: Array<FreeTrialDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    getFreeTrialsWithinPastHours(hours: number, successHandler: (result: Array<FreeTrialDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    getIncompleteFreeTrialsStartedOverAnHourAgo(successHandler: (result: Array<FreeTrialDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getListFromParams(sort: Array<string>, range: Array<number>, filter: string, successHandler: (result: GetListResponseDto<FreeTrialDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOneByPersonId(personId: number, successHandler: (result: FreeTrialDTO) => void, errorHandler?: (error: DTOException) => void): void;
    getStatistics(startTime: number, endTime: number, filter: string, successHandler: (result: GetListResponseDto<FreeTrialMinDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getStatisticsByInstructors(startTime: number, endTime: number, instructorIds: Array<number>, filter: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getStudentNotConfirmedList(inNextHours: number, successHandler: (result: Array<FreeTrialDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    getTeacherNotConfirmedList(inNextHours: number, successHandler: (result: Array<FreeTrialDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    getTotalNeedingReschedule(successHandler: (result: ResponseSuccess<number>) => void, errorHandler?: (error: DTOException) => void): void;
    getTrackingTaskFromFreeTrialId(freeTrialId: number, successHandler: (result: TrackingTask) => void, errorHandler?: (error: DTOException) => void): void;
    getUnenrolledFreeTrialEmails(args: number[], successHandler: (result: Array<string>) => void, errorHandler?: (error: DTOException) => void): void;
    instructorAcceptFreeTrial(freeTrialId: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    instructorDeclineFreeTrial(freeTrialId: number, declineReason: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    markTrialsAsCompleted(trialIds: Array<number>, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    oneDayRemindersSent(id: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    requestReschedule(freeTrialId: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    sameDayRemindersSent(id: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    setClassTypeRecommendation(classType: string, freeTrialId: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    studentConfirmFreeTrial(freeTrialId: number, successHandler: (result: ResponseSuccess<string>) => void, errorHandler?: (error: DTOException) => void): void;
    submitInstructorFeedback(followUpDto: SubmitFreeTrialFollowUpDto, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    submitStudentFeedback(studentPersonId: number, rating: number, comment: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    upcomingTrialForUserExists(personId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    updateInstructorFeedback(instructorFeedbackDto: SubmitFreeTrialFollowUpDto, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    updateReachOut(freeTrialId: number, enrollmentStatus: string, nextReachOutTimeEpoch: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class ClassOpsService {
    getSwappableClassSessionsRelatedTo(classSessionId: number, successHandler: (result: Array<ClassSessionDto>) => void, errorHandler?: (error: DTOException) => void): void;
    sendAgentChatMessage(studentId: number, message: string, trigerredByPersonId: number, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    sendClassAbsenceEmail(studentId: number, classSessionId: number, swapTimeOptions: Array<string>, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    sendClassReminderEmail(studentId: number, classSessionId: number, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    sendConvertStudentEmail(studentId: number, classSessionId: number, taskId: number, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    sendFirstClassReminderEmail(studentId: number, classSessionId: number, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    sendHomeworkReminderEmail(studentId: number, classSessionId: number, psetId: number, numAttempted: number, numProblems: number, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    sendSMS(studentId: number, message: string, trigerredByPersonId: number, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    sendTechTestEmail(studentId: number, classSessionId: number, techType: string, isChina: boolean, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    sendTechTestEmailAndSMS(studentId: number, classSessionId: number, techType: string, isChina: boolean, triggeredByPersonId: number, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    sendWelcomeEmail(studentId: number, classSessionId: number, isChina: boolean, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class AdminClassSessionCalendarPresetsService {
    create(data: any, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    getCallerRoles(successHandler: (result: Role[]) => void, errorHandler?: (error: DTOException) => void): void;
    getDTOClass(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: ResponseSuccess<GetListResponseDto<any>>) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: ResponseSuccess<Array<any>>) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, newValue: any, oldValue: any, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    updateAndCascadeUpdateClassSessions(id: number, newValue: CalendarPresetDto, oldValue: CalendarPresetDto, successHandler: (result: ResponseSuccess<CalendarPresetDto>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class CrudService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class ReferralsService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    createDefaultPartnerAccount(firstName: string, lastName: string, email: string, successHandler: (result: ResponseSuccess<PartnerContractDto>) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    establishReferral(referrerPersonId: number, refereePersonId: number, successHandler: (result: ResponseSuccess<number>) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getRefereeEnrollmentData(studentPersonId: number, successHandler: (result: ResponseSuccess<Array<StudentReferralDataDto>>) => void, errorHandler?: (error: DTOException) => void): void;
    getReferrerUserByUsernameOrCouponCode(username: string, successHandler: (result: ResponseSuccess<KtbyteEarthUser>) => void, errorHandler?: (error: DTOException) => void): void;
    getTemporaryReferralCoupon(successHandler: (result: ResponseSuccess<string>) => void, errorHandler?: (error: DTOException) => void): void;
    submitInfoToOps(infoDto: UserSignUpInfoDto, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class UserInfoService {
    getAllEnrollments(successHandler: (result: ResponseSuccess<ParentEnrollmentsDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getChildren(successHandler: (result: ResponseSuccess<Array<KtbyteEarthUser>>) => void, errorHandler?: (error: DTOException) => void): void;
    getUserFreeTimeBlocksByWeek(personId: number, weekStartEpoch: number, successHandler: (result: ResponseSuccess<Array<StaffFreeTimeBlockDto>>) => void, errorHandler?: (error: DTOException) => void): void;
    updateRoles(personId: number, roles: Array<string>, successHandler: (result: ResponseSuccess<void>) => void, errorHandler?: (error: DTOException) => void): void;
    updateUserFreeTimeBlocksByWeeks(personId: number, weekStartEpochsToTimeBlocks: any, successHandler: (result: ResponseSuccess<void>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class CouponsService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class OrientationService {
    agentGetByPersonId(personId: number, successHandler: (result: ResponseSuccess<OrientationDto>) => void, errorHandler?: (error: DTOException) => void): void;
    agentGetOne(id: number, successHandler: (result: ResponseSuccess<OrientationDto>) => void, errorHandler?: (error: DTOException) => void): void;
    create(data: any, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    getCallerRoles(successHandler: (result: Role[]) => void, errorHandler?: (error: DTOException) => void): void;
    getDTOClass(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: ResponseSuccess<GetListResponseDto<any>>) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: ResponseSuccess<Array<any>>) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, newValue: any, oldValue: any, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    userCompleteOrientation(topic: string, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    userIsOrientationComplete(topic: string, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    userVisitOrientationPage(topic: string, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class SearchService {
    searchByTitleAndKeywords(query: string, successHandler: (result: ResponseSuccess<Array<SearchLinkDto>>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class GlobalService {
    getCSRFToken(successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    getRegion(successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    getRoles(successHandler: (result: string[]) => void, errorHandler?: (error: DTOException) => void): void;
    getStudentsFromClassSession(classSessionId: number, successHandler: (result: ResponseSuccess<Array<KtbyteEarthUser>>) => void, errorHandler?: (error: DTOException) => void): void;
    getUser(successHandler: (result: KtbyteEarthUser) => void, errorHandler?: (error: DTOException) => void): void;
    getWebsiteRoutes(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    reportFire(fireId: string, fireType: string, studentId: number, classroomInfo: string, fireReasons: Array<string>, reportedByAUser: boolean, successHandler: (result: ResponseSuccess<FireTaskDto>) => void, errorHandler?: (error: DTOException) => void): void;
    runScript(successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    searchParents(query: string, limit: number, successHandler: (result: ResponseSuccess<Array<KtbyteEarthUser>>) => void, errorHandler?: (error: DTOException) => void): void;
    searchPartners(query: string, limit: number, successHandler: (result: ResponseSuccess<Array<KtbyteEarthUser>>) => void, errorHandler?: (error: DTOException) => void): void;
    searchStudents(query: string, limit: number, successHandler: (result: ResponseSuccess<Array<KtbyteEarthUser>>) => void, errorHandler?: (error: DTOException) => void): void;
    searchUsers(query: string, limit: number, successHandler: (result: ResponseSuccess<Array<KtbyteCrmRow>>) => void, errorHandler?: (error: DTOException) => void): void;
    sendEmailFromNoReply(to: Array<string>, subject: string, body: string, successHandler: (result: ResponseSuccess<string>) => void, errorHandler?: (error: DTOException) => void): void;
    sendSms(phoneNumbers: Array<string>, smsBody: string, successHandler: (result: ResponseSuccess<Array<string>>) => void, errorHandler?: (error: DTOException) => void): void;
    submitConsultationRequest(email: string, firstName: string, lastName: string, phoneNumber: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    submitSignUpRequest(email: string, firstName: string, lastName: string, phoneNumber: string, bestTime: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class ProjectsService {
    addComment(projectComment: ProjectCommentDto, successHandler: (result: ResponseSuccess<ProjectCommentResponse>) => void, errorHandler?: (error: DTOException) => void): void;
    deleteComment(commentId: number, successHandler: (result: ResponseSuccess<string>) => void, errorHandler?: (error: DTOException) => void): void;
    getComments(projectId: number, successHandler: (result: ResponseSuccess<Array<ProjectCommentResponse>>) => void, errorHandler?: (error: DTOException) => void): void;
    getRecommendations(projectId: number, successHandler: (result: ResponseSuccess<Array<UserProjectResponse>>) => void, errorHandler?: (error: DTOException) => void): void;
    getUserProjects(userProjects: GetUserProjectsDto, successHandler: (result: ResponseSuccess<Array<UserProjectResponse>>) => void, errorHandler?: (error: DTOException) => void): void;
    voteComment(commentId: number, voteType: string, successHandler: (result: ResponseSuccess<ProjectCommentResponse>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class AccountCreationService {
    isValidEmail(email: string, checkTaken: boolean, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    isValidUsername(username: string, tempUserId: number, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    proofreadUsername(username: string, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class ProgressStateService {
    checkValidProgress(progressId: number, successHandler: (result: ResponseSuccess<ProgressStateTransfer>) => void, errorHandler?: (error: DTOException) => void): void;
    chooseExistingProgressOverStartingNewOne(progressDTOs: any, toKeep: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    chooseNewProgressOverExisting(progressDTOs: any, progressType: string, stateType: string, successHandler: (result: ResponseSuccess<ProgressStateTransfer>) => void, errorHandler?: (error: DTOException) => void): void;
    deleteProgresses(progressDTOs: any, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    getInitiationBatch(makeNew: boolean, progressType: string, progressStateType: string, successHandler: (result: ResponseSuccess<InitiationBatch>) => void, errorHandler?: (error: DTOException) => void): void;
    getProgressById(progressId: number, successHandler: (result: ResponseSuccess<ProgressDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    linkExistingStudentToLoggedInParent(usernameOrEmail: string, password: string, pst: ProgressStateTransfer, csrf: string, successHandler: (result: ResponseSuccess<ProgressStateTransfer>) => void, errorHandler?: (error: DTOException) => void): void;
    login(usernameOrEmail: string, password: string, rememberMe: string, pst: ProgressStateTransfer, csrf: string, successHandler: (result: ProgressStateTransfer) => void, errorHandler?: (error: DTOException) => void): void;
    nextProgressState(pst: ProgressStateTransfer, csrf: string, successHandler: (result: ResponseSuccess<ProgressStateTransfer>) => void, errorHandler?: (error: DTOException) => void): void;
    previousProgressState(pst: ProgressStateTransfer, csrf: string, successHandler: (result: ResponseSuccess<ProgressStateTransfer>) => void, errorHandler?: (error: DTOException) => void): void;
    sendEmailToParent(pst: ProgressStateTransfer, email: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    sendEmailToParentNoAccount(pst: ProgressStateTransfer, email: string, firstname: string, lastname: string, successHandler: (result: ResponseSuccess<string>) => void, errorHandler?: (error: DTOException) => void): void;
    transitionToEnrollmentProgressState(successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    updateProgressState(pst: ProgressStateTransfer, successHandler: (result: ResponseSuccess<ProgressStateTransfer>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class UserActionLogsService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class PermissionedService {
    getCallerRoles(successHandler: (result: Role[]) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class UsersService {
    becomeUser(personId: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTeachers(successHandler: (result: ResponseSuccess<GetListResponseDto<KtbyteEarthUser>>) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getLoggedInUser(successHandler: (result: ResponseSuccess<KtbyteEarthUser>) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    optOutOrientation(personId: number, taskId: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    resetPassword(personId: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    sendOrientationReminders(personId: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class ClassSessionMakeCurriculaService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class ReferralSharesService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getReferrerShareStats(referrerPersonId: number, successHandler: (result: ResponseSuccess<ReferrerAggregateShareStatsDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getReferrerSingleTypeShareStats(referrerPersonId: number, shareType: string, successHandler: (result: ResponseSuccess<Array<ReferralShareDto>>) => void, errorHandler?: (error: DTOException) => void): void;
    getThisUserReferrerShareStats(successHandler: (result: ResponseSuccess<ReferrerAggregateShareStatsDto>) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class CrmPeopleService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    findParentsByStudentCrmIds(studentCrmIds: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    findStudentsByParentCrmIds(studentCrmIds: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOneByPersonId(id: number, successHandler: (result: ResponseSuccess<PersonDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getParentsByStudentId(studentId: number, successHandler: (result: Array<PersonDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getParentsByStudentIds(studentIds: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getPersonIdFromReferralCode(referralCode: string, successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    getPersonIdsFromSearch(queryParam: string, successHandler: (result: Array<number>) => void, errorHandler?: (error: DTOException) => void): void;
    getSecondaryEmails(str: string, successHandler: (result: Array<string>) => void, errorHandler?: (error: DTOException) => void): void;
    getStudentsByParentId(parentId: number, successHandler: (result: Array<PersonDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getStudentsByParentIds(parentIds: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    updateByPersonId(personId: number, updatedDataJson: string, byPersonId: number, successHandler: (result: ResponseSuccess<PersonDto>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class AppointmentsService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    deleteMany(ids: number[], successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class SettingsService {
    getSettings(successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    updateSettings(fieldName: string, fieldValue: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class ErrorsService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    deleteAllErrors(successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    deleteError(errorMsg: string, filename: string, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    getAllErrors(successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getResultPage(pageNumber: number, searchParam: string, searchType: string, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    logError(errorMsg: string, route: string, filename: string, line: number, col: number, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    logReactError(errorMsg: string, route: string, filename: string, line: number, col: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    searchErrors(searchParam: string, searchType: string, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class UserActionRewardsService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class CurriculumEditorService {
    duplicate(curriculumId: number, successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    getCurriculum(currId: number, successHandler: (result: CurriculumDto) => void, errorHandler?: (error: DTOException) => void): void;
    getCurriculumDto(curriculumId: number, successHandler: (result: CurriculumEditorDto) => void, errorHandler?: (error: DTOException) => void): void;
    getIsGood(psetId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    getPset(psetId: number, successHandler: (result: PSetDto) => void, errorHandler?: (error: DTOException) => void): void;
    getStudentProject(projectId: number, successHandler: (result: StudentProjectDto) => void, errorHandler?: (error: DTOException) => void): void;
    updateCurriculumPsetsLessonPlans(dto: CurriculumPsetsLessonPlans, setAsCanoncialCurriculum: boolean, successHandler: (result: CurriculumEditorDto) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class OnlineClassroomService {
    deleteHistoryItem(id: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllFreeTrialClassroomIds(successHandler: (result: ResponseSuccess<Array<number>>) => void, errorHandler?: (error: DTOException) => void): void;
    getCsltClassroomEvents(csltId: number, successHandler: (result: ResponseSuccess<ClassroomEventsDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getCsltUserEvents(csltId: number, successHandler: (result: ResponseSuccess<CsltUserEventsDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getCsltsByClassSessionId(classSessionId: number, successHandler: (result: ResponseSuccess<Array<CsltDto>>) => void, errorHandler?: (error: DTOException) => void): void;
    getHistory(roomId: number, roomType: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    getHistoryItem(id: number, successHandler: (result: ClassroomPadHistoryDto) => void, errorHandler?: (error: DTOException) => void): void;
    getOnlineClassroomInfo(classroomType: string, classroomId: number, successHandler: (result: ResponseSuccess<ClassroomInfoDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getOnlineClassroomInfoByTrialTimeSlotId(trialTimeSlotId: number, successHandler: (result: ResponseSuccess<ClassroomInfoDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getOnlineClassrooms(successHandler: (result: ResponseSuccess<ClassroomsDto>) => void, errorHandler?: (error: DTOException) => void): void;
    setClassSessionStudentSection(studentPersonId: number, classSessionId: number, section: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class ProcessingCompilationService {
    compile(javaCode: string, candiesNames: string[], candiesToBeFetched: string[], debugMode: boolean, successHandler: (result: ProcessingCompilationResult) => void, errorHandler?: (error: DTOException) => void): void;
    getCompletion(javaCode: string, line: number, column: number, successHandler: (result: ProcessingCompilationResult) => void, errorHandler?: (error: DTOException) => void): void;
    validate(javaCode: string, candiesNames: string[], candiesToBeFetched: string[], generateBlocklyXml: boolean, successHandler: (result: ProcessingCompilationResult) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class HelpService {
    getList(successHandler: (result: ResponseSuccess<Array<HelpMeetingDto>>) => void, errorHandler?: (error: DTOException) => void): void;
    sendFeedback(reason: string, who: string, solved: string, nice: string, speed: string, comments: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class FreeTrialService {
    addNote(freeTrialId: number, text: string, successHandler: (result: ResponseSuccess<boolean>) => void, errorHandler?: (error: DTOException) => void): void;
    approveInstructorFeedback(taskId: number, freeTrialId: number, updatedInstructorFeedbackDto: SubmitFreeTrialFollowUpDto, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    assignFreeTrialInstructor(taskId: number, freeTrialId: number, teacherPersonId: number, successHandler: (result: ResponseSuccess<FreeTrialDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    cancelFreeTrial(freeTrialId: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    emailInstructor(freeTrialId: number, successHandler: (result: ResponseSuccess<FreeTrialDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllHearFromOptions(successHandler: (result: Array<HeardFromSourceDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllLocationOptions(successHandler: (result: Array<string>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllMetrics(successHandler: (result: Array<FreeTrialFeedbackMetricDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllMissingFeedbacks(successHandler: (result: Array<FreeTrialDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllValidClassSessionSets(successHandler: (result: Array<ClassSessionSetDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllValidClassSessionSetsSortedByMostUsed(successHandler: (result: Array<ClassSessionSetDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getChildren(pst: ProgressStateTransfer, successHandler: (result: ResponseSuccess<Array<FreeTrialChild>>) => void, errorHandler?: (error: DTOException) => void): void;
    getClassSessionRecs(classType: string, freeTrialId: number, successHandler: (result: Array<ClassSessionSetRecommendationDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getClassType(freeTrialId: number, successHandler: (result: ClassTypeDto) => void, errorHandler?: (error: DTOException) => void): void;
    getFeedback(freeTrialId: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getFreeTrialReportData(freeTrialId: number, successHandler: (result: ResponseSuccess<FreeTrialReportCardDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getFreeTrialsOnDate(date: string, successHandler: (result: Array<FreeTrialDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOneByStudentPersonId(id: number, successHandler: (result: ResponseSuccess<FreeTrialDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    getRecommendations(query: string, successHandler: (result: Array<string>) => void, errorHandler?: (error: DTOException) => void): void;
    getStatistics(startTime: number, endTime: number, filter: string, successHandler: (result: ResponseSuccess<FreeTrialStatsDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getStatisticsByInstructors(startTime: number, endTime: number, filter: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    getTotalNeedingReschedule(successHandler: (result: ResponseSuccess<number>) => void, errorHandler?: (error: DTOException) => void): void;
    getUnenrolledFreeTrialEmails(args: number[], successHandler: (result: ResponseSuccess<Array<string>>) => void, errorHandler?: (error: DTOException) => void): void;
    getWhitelistTeachers(successHandler: (result: Array<string>) => void, errorHandler?: (error: DTOException) => void): void;
    instructorAcceptFreeTrial(freeTrialId: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    instructorDeclineFreeTrial(freeTrialId: number, declineReason: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    markTrialsAsCompleted(trialIds: Array<number>, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    precancelFreeTrial(taskId: number, reason: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    scheduleFreeTrialFromParentAvailability(taskId: number, freeTrialDto: FreeTrialDTO, differentTime: boolean, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    searchPreCancelledTrials(query: string, limit: number, successHandler: (result: ResponseSuccess<Array<TrackingTask>>) => void, errorHandler?: (error: DTOException) => void): void;
    studentConfirm(freeTrialId: number, successHandler: (result: ResponseSuccess<string>) => void, errorHandler?: (error: DTOException) => void): void;
    studentRequestReschedule(freeTrialId: number, successHandler: (result: ResponseSuccess<string>) => void, errorHandler?: (error: DTOException) => void): void;
    submitInstructorFeedback(SubmitFreeTrialFollowUpDto: SubmitFreeTrialFollowUpDto, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    submitStudentFeedback(studentPersonId: number, rating: number, comment: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    unPrecancelFreeTrial(taskId: number, reason: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    updateInstructorFeedback(instructorFeedbackDto: SubmitFreeTrialFollowUpDto, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    updateReachOut(freeTrialID: number, enrollmentConversion: string, nextReachOutTimeEpoch: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class CrmGeoInfosService {
    getList(query: string, successHandler: (result: ResponseSuccess<Array<GeoInfoDto>>) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(foreignKeyCrmId: number, successHandler: (result: ResponseSuccess<Array<GeoInfoDto>>) => void, errorHandler?: (error: DTOException) => void): void;
    setGeoInfo(dto: GeoInfoDto, successHandler: (result: GeoInfoDto) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class PsetGradingService {
    autoGrade(gradeInputs: Array<StudentGradeInput>, successHandler: (result: Array<GradeResponse>) => void, errorHandler?: (error: DTOException) => void): void;
    getClassSessionGradeGroupDTO(classSessionId: number, psetId: number, successHandler: (result: ClassSessionGradeGroupDTO) => void, errorHandler?: (error: DTOException) => void): void;
    saveGrade(gradeInputs: Array<StudentGradeInput>, lockedAndGradedStatus: Array<StudentGradeStatus>, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class TechTestService {
    failTechTestStep(step: string, os: string, browser: string, userAgentHeader: string, testStartTime: number, testMode: string, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    failTechTestStepWithResult(step: string, os: string, browser: string, userAgentHeader: string, testStartTime: number, testMode: string, resultJson: string, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getStudentLatestResults(personId: number, successHandler: (result: UserTechTestResultDto) => void, errorHandler?: (error: DTOException) => void): void;
    getTechTestUser(expectedPersonId: number, successHandler: (result: TechTestUserDto) => void, errorHandler?: (error: DTOException) => void): void;
    getThisUserTechTestSteps(successHandler: (result: UserTechTestStepsDto) => void, errorHandler?: (error: DTOException) => void): void;
    getUserTechTestSteps(personId: number, successHandler: (result: UserTechTestStepsDto) => void, errorHandler?: (error: DTOException) => void): void;
    onFailInterfaceTest(personId: number, step: string, reason: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    onPassInterfaceTest(personId: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    passTechTestStep(step: string, os: string, browser: string, userAgentHeader: string, testStartTime: number, testMode: string, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    passTechTestStepWithResult(step: string, os: string, browser: string, userAgentHeader: string, testStartTime: number, testMode: string, resultJson: string, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    studentPassedAllTests(personId: number, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class KtbyteEarthTaskService {
    RemoveTAFromClass(taId: number, classSessionId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    RemoveTAFromClassSessionLessonTimes(taId: number, classSessionLessonTimeIds: Array<number>, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    addTaskWorklog(taskId: number, comment: string, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    assignAssistantInstructorToAllClassSessionLessonTimes(teacherId: number, section: number, classSessionId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    assignAssistantInstructorToClassSession(teacherId: number, section: number, classSessionId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    assignAssistantInstructorToClassSessionLessonTimes(teacherId: number, section: number, classSessionLessonTimeIds: Array<number>, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    assignTaskToAdmins(task: TrackingTask, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    assignTaskToPerson(task: TrackingTask, assigneePersonId: number, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    countAllTasksAssignedToMeAndMyRolesWithStates(states: Array<string>, successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    countAllTasksAssignedToOnlyMeWithStates(states: Array<string>, successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    createClassSessionLessonTimes(request: NewCSLTRequest, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    createTask(simpleName: string, dataJson: string, deadlineEpochSeconds: number, priority: number, state: string, step: string, assignedToPersonId: number, classSessionId: number, classSessionLessonTimeId: number, targetPersonId: number, successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    getAdmins(successHandler: (result: Array<KtbyteEarthUser>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllAdminOpenTasks(successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllJobs(successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllLateTasks(successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllOpenJobs(successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllOpenTasksByTitle(titleShort: string, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksAssignedToMe(successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksAssignedToMeAndMyRolesWithStates(states: string[], successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksAssignedToMeWithStates(states: string[], includeRolesTasks: boolean, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksAssignedToOnlyMeWithStates(states: string[], successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksByCategory(category: string, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksByClassSession(classSessionId: number, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksByClassSessionLessonTime(classSessionLessonTimeId: number, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksByTargetPersonId(targetPersonId: number, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksByTitle(titleShort: string, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksCreatedByMe(successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllTasksCreatedByMeWithState(state: string, successHandler: (result: Array<TrackingTask>) => void, errorHandler?: (error: DTOException) => void): void;
    getAssignedPsetsToClassSession(classSessionId: number, successHandler: (result: Array<KtbytePset>) => void, errorHandler?: (error: DTOException) => void): void;
    getAvailableOpsMembersForTrialTimeSlot(trialDateEpoch: number, successHandler: (result: Array<number>) => void, errorHandler?: (error: DTOException) => void): void;
    getAvailableStaffForTask(task: EnumTaskType, step: EnumFreeTrialStep, dueDateEpoch: number, isChina: boolean, successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    getCalendarItemsBatchBetweenEpochs(startEpoch: number, endEpoch: number, successHandler: (result: CalendarItemsBatch) => void, errorHandler?: (error: DTOException) => void): void;
    getCalendarItemsBatchByUserBetweenEpochs(personId: number, startEpoch: number, endEpoch: number, successHandler: (result: CalendarItemsBatch) => void, errorHandler?: (error: DTOException) => void): void;
    getClassSessionAndLessonTimesAndUsers(classSessionIds: Array<number>, classSessionLessonTimeIds: Array<number>, personIds: Array<number>, successHandler: (result: ClassSessionAndLessonTimesAndUsers) => void, errorHandler?: (error: DTOException) => void): void;
    getClassSessionAssistantInstructor(classSessionId: number, successHandler: (result: Array<KtbyteEarthUser>) => void, errorHandler?: (error: DTOException) => void): void;
    getClassSessionFromLessonID(classSessionLessonTimeId: number, successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    getClassSessionLessonTimeAssistantInstructor(classSessionLessonTimeId: number, successHandler: (result: Array<KtbyteEarthUser>) => void, errorHandler?: (error: DTOException) => void): void;
    getClassSessionLessonTimes(classSessionId: number, successHandler: (result: Array<KtbyteClassSessionLessonTime>) => void, errorHandler?: (error: DTOException) => void): void;
    getClassSessionLessonTimesForStudent(personId: number, classSessionId: number, successHandler: (result: Array<KtbyteClassSessionLessonTime>) => void, errorHandler?: (error: DTOException) => void): void;
    getClassSessionList(includeClosed: boolean, successHandler: (result: Array<KtbyteClassSession>) => void, errorHandler?: (error: DTOException) => void): void;
    getClassSessionStudents(classSessionId: number, successHandler: (result: Array<KtbyteEarthUser>) => void, errorHandler?: (error: DTOException) => void): void;
    getFiremen(successHandler: (result: Array<KtbyteEarthUser>) => void, errorHandler?: (error: DTOException) => void): void;
    getLessonsBetweenEpochs(startEpoch: number, endEpoch: number, successHandler: (result: Array<KtbyteClassSessionLessonTimeWithExtraInfo>) => void, errorHandler?: (error: DTOException) => void): void;
    getNumAssistantInstructorsRequired(classSessionLessonTimeId: number, successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    getStaffPersonIds(successHandler: (result: Array<number>) => void, errorHandler?: (error: DTOException) => void): void;
    getStudents(successHandler: (result: Array<KtbyteEarthUser>) => void, errorHandler?: (error: DTOException) => void): void;
    getTASection(classSessionLessonTimeId: number, taId: number, successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    getTask(taskId: number, successHandler: (result: TrackingTask) => void, errorHandler?: (error: DTOException) => void): void;
    getTaskWorklog(task: TrackingTask, successHandler: (result: Array<TaskWorklogDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    getTeachers(successHandler: (result: Array<KtbyteEarthUser>) => void, errorHandler?: (error: DTOException) => void): void;
    getWhatIs3Plus2(successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    reassignOpsFreeTrialTask(taskId: number, fTrialId: number, timeSlotId: number, dueDateEpoch: number, assignedId: number, successHandler: (result: ResponseSuccess<void>) => void, errorHandler?: (error: DTOException) => void): void;
    resolveConfirmMakeupTeacher(taskId: number, action: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    searchClassSessionList(searchParam: string, includeClosed: boolean, successHandler: (result: Array<KtbyteClassSession>) => void, errorHandler?: (error: DTOException) => void): void;
    sendEmailFromNoReply(to: Array<string>, subject: string, body: string, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    sendEmailRelatedToTask(taskId: number, sendToCreator: boolean, sendToAssignee: boolean, sendToTeam: boolean, sendToParents: boolean, subject: string, body: string, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    sendReminderEmails(successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    sendTextAsAdmin(phoneNumbers: Array<string>, personIds: Array<number>, body: string, sendToFirstPhoneNumberOnly: boolean, successHandler: (result: Array<string>) => void, errorHandler?: (error: DTOException) => void): void;
    updateTaskById(task: TrackingTask, assignedToPersonId: number, dataJson: string, priority: number, state: string, step: string, deadlineEpochSeconds: number, successHandler: (result: TrackingTask) => void, errorHandler?: (error: DTOException) => void): void;
    updateTaskData(taskid: number, dataJson: string, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    updateTaskState(task: TrackingTask, newState: string, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    updateTaskStep(taskid: number, step: string, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class WorkshopsService {
    getOpenWorkshops(workshopName: string, successHandler: (result: ResponseSuccess<Array<ClassSessionDTO>>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class PartnerContractsService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOneByPersonId(personId: number, successHandler: (result: ResponseSuccess<PartnerContractDto>) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class ClassSessionMakeService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    createGroup(data: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    deleteGroup(id: number, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getListGroup(query: string, successHandler: (result: ResponseSuccess<GetListResponseDto<ClassSessionMakeDTO>>) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyGroup(ids: Array<number>, successHandler: (result: ResponseSuccess<Array<ClassSessionMakeDTO>>) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReferenceGroup(successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOneGroup(id: number, successHandler: (result: ResponseSuccess<ClassSessionMakeDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    submitWithLessonsAndTeachers(calendar: string, humanCategory: string, lessonTimeDates: string, category: number, location: number, set: number, fee: number, capacity: number, curricula: number, humanFormat: string, sessionSerialized: string, techType: string, time: string, duration: number, instructor: string, tas: string[], successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    updateGroup(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: ResponseSuccess<ClassSessionMakeDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class KTStorageService {
    getUsername(successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    isAuthor(projectid: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    readCurrentUser(projectid: number, successHandler: (result: ResponseSuccess<string>) => void, errorHandler?: (error: DTOException) => void): void;
    readGlobal(projectid: number, successHandler: (result: ResponseSuccess<string>) => void, errorHandler?: (error: DTOException) => void): void;
    readReadonly(projectid: number, successHandler: (result: ResponseSuccess<string>) => void, errorHandler?: (error: DTOException) => void): void;
    readSecret(projectid: number, successHandler: (result: ResponseSuccess<string>) => void, errorHandler?: (error: DTOException) => void): void;
    readUser(projectid: number, username: string, successHandler: (result: ResponseSuccess<string>) => void, errorHandler?: (error: DTOException) => void): void;
    writeCurrentUser(projectid: number, data: string, successHandler: (result: ResponseSuccess<string>) => void, errorHandler?: (error: DTOException) => void): void;
    writeGlobal(projectid: number, data: string, successHandler: (result: ResponseSuccess<string>) => void, errorHandler?: (error: DTOException) => void): void;
    writeReadonly(projectid: number, data: string, successHandler: (result: ResponseSuccess<string>) => void, errorHandler?: (error: DTOException) => void): void;
    writeSecret(projectid: number, data: string, successHandler: (result: ResponseSuccess<string>) => void, errorHandler?: (error: DTOException) => void): void;
    writeUser(projectid: number, username: string, data: string, successHandler: (result: ResponseSuccess<string>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class ClassRecommendationService {
    getCallerRoles(successHandler: (result: Role[]) => void, errorHandler?: (error: DTOException) => void): void;
    getCurrentParentChildrenRecommendations(successHandler: (result: Array<ClassRecommendationModelDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getCurrentUserRecommendations(successHandler: (result: Array<ClassRecommendationModelDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getRecommendation(studentId: number, classSessionId: number, successHandler: (result: ClassRecommendationModelDto) => void, errorHandler?: (error: DTOException) => void): void;
    getRecommendationsByClassSessionIds(classSessionIds: Array<number>, successHandler: (result: Array<ClassRecommendationModelDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getRecommendationsByClassSessionSerialized(sessionSerialized: string, successHandler: (result: Array<ClassRecommendationModelDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getRecommendationsByStudentIds(studentIds: Array<number>, successHandler: (result: Array<ClassRecommendationModelDto>) => void, errorHandler?: (error: DTOException) => void): void;
    sendClassRecommendationEmail(studentId: number, classSessionId: number, successHandler: (result: ClassRecommendationModelDto) => void, errorHandler?: (error: DTOException) => void): void;
    setFinalFeedbackAndRecommendedNextClasses(dto: ClassRecommendationModelDto, successHandler: (result: ClassRecommendationModelDto) => void, errorHandler?: (error: DTOException) => void): void;
    setOpsApproval(dto: ClassRecommendationModelDto, successHandler: (result: ClassRecommendationModelDto) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class KtbyteCrmCacheService {
    getContactAndVmInfoByPersonId(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getPersonIdsWithNoEnrollmentMatchingRegex(personIds: Array<number>, includeIfMissingThisEnrollmentRegex: string, mustHaveThisEnrollmentRegex: string, successHandler: (result: Array<number>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class GeoInfosService {
    getCallerRoles(successHandler: (result: Role[]) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: ResponseSuccess<Array<GeoInfoDto>>) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(foreignKeyCrmId: number, successHandler: (result: ResponseSuccess<Array<GeoInfoDto>>) => void, errorHandler?: (error: DTOException) => void): void;
    setGeoInfo(dto: GeoInfoDto, successHandler: (result: GeoInfoDto) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class EnrollmentService {
    enrollFreeTrialByAgent(dto: FreeTrialEnrollmentDto, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllOpsAdditionalOptions(successHandler: (result: Array<OpsAdditionalOptionsDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getChildren(pst: ProgressStateTransfer, successHandler: (result: ResponseSuccess<Array<EnrollmentChild>>) => void, errorHandler?: (error: DTOException) => void): void;
    newEnrollmentProgressFromClassSessionSerialized(classSessionSerialized: string, successHandler: (result: ResponseSuccess<string>) => void, errorHandler?: (error: DTOException) => void): void;
    setAllOpsAdditionalOption(dtoArray: OpsAdditionalOptionsDto[], successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    setOpsAdditionalOption(dto: OpsAdditionalOptionsDto, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    simpleAccountCreateAndEnrollTrial(dto: FreeTrialEnrollmentDto, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class ProjectCompilationService {
    compile(projectId: number, debug: boolean, successHandler: (result: ProcessingCompilationResult) => void, errorHandler?: (error: DTOException) => void): Abortable;
    compileWithCode(javacode: string, candiesNames: string[], candiesToBeFetched: string[], javablockCode: string, debug: boolean, successHandler: (result: ProcessingCompilationResult) => void, errorHandler?: (error: DTOException) => void): Abortable;
    sync: any;
}
declare class KtbyteCrmEmailService {
    addUsersByCourseSessionSerialized(users: Array<number>, courseSessionSerialized: string, successHandler: (result: Array<number>) => void, errorHandler?: (error: DTOException) => void): void;
    addUsersByTag(users: Array<number>, tag: string, successHandler: (result: Array<number>) => void, errorHandler?: (error: DTOException) => void): void;
    getRequestIdInfo(requestId: string, successHandler: (result: EmailRequestInfo) => void, errorHandler?: (error: DTOException) => void): void;
    renderEmailContent(studentId: number, classSession: KtbyteClassSession, templateId: number, customTwigVariables: any, successHandler: (result: EmailSubjectAndBody) => void, errorHandler?: (error: DTOException) => void): void;
    sendEmail(studentIds: Array<number>, includeParents: boolean, classSessionId: number, templateId: number, customTwigVariables: any, priority: EnumeratedEmailPriority, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class AgentDashboardService {
    getActiveSessionsOnDate(date: string, successHandler: (result: Array<ClassSessionSummary>) => void, errorHandler?: (error: DTOException) => void): void;
    getActiveStudents(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getCallerRoles(successHandler: (result: Role[]) => void, errorHandler?: (error: DTOException) => void): void;
    getClassSessionSets(successHandler: (result: Array<ClassSessionSetDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getCurricula(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getCurriculumSessionDetails(code: string, successHandler: (result: Array<StudentClassSessionDetailsDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getFamily(personId: number, successHandler: (result: FamilyDTO) => void, errorHandler?: (error: DTOException) => void): void;
    getLessons(date: string, includeAllPsets: boolean, successHandler: (result: Array<LessonDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getStudentClassSessionDetails(sessionSerialized: string, successHandler: (result: StudentClassSessionDetailsDto) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class ClassSessionMakeSetService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class FreeTrialFeedbackMetricService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getAvailableMetrics(successHandler: (result: ResponseSuccess<Array<FreeTrialFeedbackMetricDto>>) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class ShowcaseBetaService {
    compile(projectId: number, javacode: string, debugMode: boolean, successHandler: (result: ProcessingCompilationResult) => void, errorHandler?: (error: DTOException) => void): Abortable;
    getProjectForGallery(search: string, orderBy: string, page: number, perPage: number, successHandler: (result: ShowcaseBetaProjectOverviewResponse) => void, errorHandler?: (error: DTOException) => void): void;
    getTotalProjects(successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class FollowersService {
    followUser(userToFollow: UserFollowerDto, successHandler: (result: ResponseSuccess<UserFollowerResponse>) => void, errorHandler?: (error: DTOException) => void): void;
    getFollowers(userId: number, successHandler: (result: ResponseSuccess<UserFollowersResponse>) => void, errorHandler?: (error: DTOException) => void): void;
    getFollowing(userId: number, successHandler: (result: ResponseSuccess<UserFollowersResponse>) => void, errorHandler?: (error: DTOException) => void): void;
    unfollowUser(userToUnfollow: UserFollowerDto, successHandler: (result: ResponseSuccess<UserFollowerResponse>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class TimelineService {
    getCallerRoles(successHandler: (result: Role[]) => void, errorHandler?: (error: DTOException) => void): void;
    getEventsByCrmId(crmId: number, successHandler: (result: Array<EventDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getFamilyByCrmId(crmId: number, successHandler: (result: FamilyDTO) => void, errorHandler?: (error: DTOException) => void): void;
    getNotesByCrmId(crmId: number, successHandler: (result: Array<NoteDto>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class AdsService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    createAd(data: string, successHandler: (result: ResponseSuccess<AdDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    createQRCode(adId: number, successHandler: (result: ResponseSuccess<WeChatCustomQRCodeResponse>) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    deleteAd(id: number, successHandler: (result: ResponseSuccess<AdDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOneAd(id: number, successHandler: (result: ResponseSuccess<AdDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    updateAd(id: number, paramsJson: string, successHandler: (result: ResponseSuccess<AdDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class CoderBetaService {
    baseFolder(successHandler: (result: CoderBetaFolder) => void, errorHandler?: (error: DTOException) => void): void;
    compile(projectId: number, psetId: number, problemNumber: number, javacode: string, candiesNames: string[], candiesToBeFetched: string[], javablockcode: string, debugMode: boolean, successHandler: (result: ProcessingCompilationResult) => void, errorHandler?: (error: DTOException) => void): Abortable;
    deleteProject(projectId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    getCorrect(problemid: number, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    getCurriculaFolder(folder: CoderBetaFolder, successHandler: (result: CoderBetaFolder) => void, errorHandler?: (error: DTOException) => void): void;
    getCurriculaForPset(psetid: number, successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    getExportedProject(projectId: number, successHandler: (result: CoderBetaProjectDTO) => void, errorHandler?: (error: DTOException) => void): void;
    getGradeStatus(successHandler: (result: CoderBetaGradedMap) => void, errorHandler?: (error: DTOException) => void): void;
    getMinutesUntilClass(classSessionId: number, successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    getPSetFolder(folder: CoderBetaFolder, successHandler: (result: CoderBetaFolder) => void, errorHandler?: (error: DTOException) => void): void;
    getProblemFile(problem: CoderBetaProblemFile, successHandler: (result: CoderBetaFileReturn) => void, errorHandler?: (error: DTOException) => void): void;
    getProcessingLibraries(successHandler: (result: Array<ProcessingLibraryDTO>) => void, errorHandler?: (error: DTOException) => void): void;
    getProjectFile(project: CoderBetaProjectFile, successHandler: (result: CoderBetaProjectReturn) => void, errorHandler?: (error: DTOException) => void): void;
    getProjectFromId(projectId: number, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    gradeProblem(request: CoderBetaGradeRequest, successHandler: (result: GradeResponse) => void, errorHandler?: (error: DTOException) => void): void;
    hasCorrect(problemid: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    isProblemCodeSaved(psetId: number, problemNumber: number, code: string, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    isProjectCodeSaved(projectId: number, code: string, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    newProject(successHandler: (result: CoderBetaProjectReturn) => void, errorHandler?: (error: DTOException) => void): void;
    newProjectWithInfo(projectType: string, projectTitle: string, projectCode: string, projectTagLine: string, projectAuthors: string, projectTags: string, projectDescription: string, javaBlockData: string, selectedLibraries: string[], successHandler: (result: CoderBetaProjectReturn) => void, errorHandler?: (error: DTOException) => void): void;
    problemNumberFromPSProblemId(psetProblemId: number, psetId: number, successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    problemNumberFromProblemId(problemId: number, psetId: number, successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    recordBrowserGrading(psetId: number, problemNumber: number, casesPassed: number, totalCases: number, successHandler: (result: ResponseSuccess<void>) => void, errorHandler?: (error: DTOException) => void): void;
    regenerateStorageKey(projectId: number, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    saveProblem(request: CoderBetaGradeRequest, successHandler: (result: CoderBetaSaveResponse) => void, errorHandler?: (error: DTOException) => void): void;
    updateProject(request: CoderBetaProjectSaveRequest, successHandler: (result: CoderBetaProjectSaveResponse) => void, errorHandler?: (error: DTOException) => void): void;
    updateProjectParentFolderId(projectId: string, updatedParentFolderId: string, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    uploadProjectFile(uploadFile: CoderBetaProjectFileUpload, successHandler: (result: CoderBetaProjectFileUploadResponse) => void, errorHandler?: (error: DTOException) => void): void;
    validate(projectId: number, javacode: string, candiesNames: string[], candiesToBeFetched: string[], generateBlocklyXml: boolean, successHandler: (result: ProcessingCompilationResult) => void, errorHandler?: (error: DTOException) => void): Abortable;
    sync: any;
}
declare class ClassesService {
    sendTimeRequestEmail(emailAddress: string, phoneNumber: string, time: string, successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class AgentChatResponseTemplateService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class KtbyteCrmService {
    addEnrollments(childIds: Array<number>, enrollments: Array<Enrollment>, parentId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    addTag(crmId: number, tag: string, triggeredByPersonId: number, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    addToCart(parentId: number, studentId: number, classSessionSerialized: string, triggeredByPersonId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    createRow(personId: number, region: string, successHandler: (result: number) => void, errorHandler?: (error: DTOException) => void): void;
    createVM(personId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    generateReferralCodesForAllPeople(successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllLegacyReferralData(successHandler: (result: Array<ReferralDto>) => void, errorHandler?: (error: DTOException) => void): void;
    getAllVmInfo(successHandler: (result: KtbyteCrmVmInfos) => void, errorHandler?: (error: DTOException) => void): void;
    getChildren(parentId: number, successHandler: (result: KtbyteCrmRows) => void, errorHandler?: (error: DTOException) => void): void;
    getEnrolledGroupTags(studentId: number, successHandler: (result: Array<string>) => void, errorHandler?: (error: DTOException) => void): void;
    getEnrolledGroupTagsByPersonId(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getEnrolledStudentsMap(classSessionList: Array<KtbyteClassSession>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getEnrollments(studentId: number, successHandler: (result: Array<Enrollment>) => void, errorHandler?: (error: DTOException) => void): void;
    getFamily(personId: number, successHandler: (result: KtbyteCrmRows) => void, errorHandler?: (error: DTOException) => void): void;
    getGuardian(studentId: number, successHandler: (result: KtbyteCrmRow) => void, errorHandler?: (error: DTOException) => void): void;
    getParentEmails(personId: number, successHandler: (result: KtbyteCrmParentInfo) => void, errorHandler?: (error: DTOException) => void): void;
    getParents(studentId: number, successHandler: (result: KtbyteCrmRows) => void, errorHandler?: (error: DTOException) => void): void;
    getPartner(affiliatePersonId: number, successHandler: (result: KtbyteCrmPartner) => void, errorHandler?: (error: DTOException) => void): void;
    getPeople(personIds: Array<number>, successHandler: (result: Array<KtbyteCrmRow>) => void, errorHandler?: (error: DTOException) => void): void;
    getPeopleByIdAndTags(personIds: Array<number>, tags: Array<string>, successHandler: (result: Array<PersonSearchResult>) => void, errorHandler?: (error: DTOException) => void): void;
    getPerson(personId: number, successHandler: (result: KtbyteCrmRow) => void, errorHandler?: (error: DTOException) => void): void;
    getPersonByCrmID(crmId: number, successHandler: (result: PersonDto) => void, errorHandler?: (error: DTOException) => void): void;
    getPersonByCrmId(crmId: number, successHandler: (result: KtbyteCrmRow) => void, errorHandler?: (error: DTOException) => void): void;
    getPersonByPersonId(personId: number, successHandler: (result: PersonDto) => void, errorHandler?: (error: DTOException) => void): void;
    getPersonSearchResultFromPersonId(personId: number, type: string, successHandler: (result: PersonSearchResult) => void, errorHandler?: (error: DTOException) => void): void;
    getRecommendationsAndTags(studentId: number, successHandler: (result: RecommendationsTagsResult) => void, errorHandler?: (error: DTOException) => void): void;
    getReferralCodeFromPersonId(personId: number, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    getStudentsEnrolledIn(sessionSerialized: string, successHandler: (result: KtbyteCrmRows) => void, errorHandler?: (error: DTOException) => void): void;
    getVmInfo(personId: number, successHandler: (result: KtbyteCrmVmInfo) => void, errorHandler?: (error: DTOException) => void): void;
    hasTag(crmId: number, tag: string, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    linkMultiplePeople(studentIds: Array<number>, studentEmails: Array<string>, parentId: number, parentEmail: string, triggeredbyPersonId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    linkPeople(studentId: number, studentemail: string, parentId: number, parentEmail: string, triggeredByPersonId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    linkSingleParentAndSingleStudent(parentPersonId: number, childPersonId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    partnerStatusUpdate(personId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    removeEmailForPerson(personId: number, email: string, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    removeFromCart(parentId: number, studentId: number, classSessionSerialized: string, triggeredByPersonId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    removeTag(crmId: number, tag: string, triggeredByPersonId: number, successHandler: (result: string) => void, errorHandler?: (error: DTOException) => void): void;
    runScript(successHandler: (result: ResponseSuccess<any>) => void, errorHandler?: (error: DTOException) => void): void;
    searchByPhone(phone: string, successHandler: (result: Array<KtbyteCrmRow>) => void, errorHandler?: (error: DTOException) => void): void;
    searchPersonByNameAndType(firstName: string, lastName: string, phone: string, type: string, tags: Array<string>, successHandler: (result: Array<PersonSearchResult>) => void, errorHandler?: (error: DTOException) => void): void;
    setNote(crmId: number, note: string, triggeredByPersonId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    setVmInfo(personId: number, vminfo: string, triggeredByPersonId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    updateEnrollment(studentId: number, newEnrollment: Enrollment, triggeredByPersonId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    updateGuardians(parentId: number, guardian1crmidhint: number, guardian2crmidhint: number, guardian1firstname: string, guardian1lastname: string, address: string, guardian1email: string, guardian1phone: string, guardian2firstname: string, guardian2lastname: string, guardian2email: string, guardian2phone: string, triggeredByPersonId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    updateParent(parentId: number, firstname: string, lastname: string, email: string, phone: string, address: string, wechat: string, preferredContactLanguage: string, triggeredByPersonId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    updateParentByCrmId(crmId: number, parentPersonId: number, firstName: string, lastName: string, email: string, phone: string, address: string, wechat: string, preferredContactLanguage: string, triggeredByPersonId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    updateParentWithSecondGuardian(parentId: number, firstname: string, lastname: string, email: string, phone: string, address: string, wechat: string, secondGuardian: string, triggeredByPersonId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    updateRecommendation(studentId: number, recommendation: string, triggeredByPersonId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    updateStudent(studentId: number, firstname: string, lastname: string, gender: string, dob: string, schooltype: string, schoolname: string, schoolgrade: string, schoolprogramming: string, allergies: string, photorelease: string, goals: string, otherquestions: string, triggeredByPersonId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    updateStudentName(personId: number, firstName: string, lastName: string, triggeredByPersonId: number, successHandler: (result: boolean) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class TofuTagsService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getTagByTagType(tagTypeOrdinal: number, successHandler: (result: ResponseSuccess<Array<TofuTagDTO>>) => void, errorHandler?: (error: DTOException) => void): void;
    getTagsRelatedToFreeTrialId(freeTrialId: number, successHandler: (result: ResponseSuccess<Array<TofuTagDTO>>) => void, errorHandler?: (error: DTOException) => void): void;
    getTagsRelatedToStudentPersonId(studentPersonId: number, successHandler: (result: ResponseSuccess<Array<TofuTagDTO>>) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    updateTagsFromCrmId(newTags: Array<TofuTagDTO>, crmId: number, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    updateTagsFromFreeTrial(newTags: Array<TofuTagDTO>, freeTrialId: number, successHandler: () => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class FreeTrialClassRecsService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getAllClassSessionSets(successHandler: (result: ResponseSuccess<Array<ClassSessionSetDto>>) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class PeopleCreditsService {
    create(data: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    createWithByPersonId(data: string, byPersonId: number, successHandler: (result: ResponseSuccess<PersonCreditDto>) => void, errorHandler?: (error: DTOException) => void): void;
    delete(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getCreditBalanceByPersonId(personId: number, successHandler: (result: ResponseSuccess<number>) => void, errorHandler?: (error: DTOException) => void): void;
    getList(query: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getMany(ids: Array<number>, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getManyReference(successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    getOne(id: number, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    update(id: number, updatedDataJson: string, previousDataJson: string, successHandler: (result: any) => void, errorHandler?: (error: DTOException) => void): void;
    sync: any;
}
declare class ConstantsFreeTrial {
    static MAX_TIMESLOT_TRIALS: number;
    static TEMP_TIMESLOT_ID: number;
}
declare class ConstantsClassSession {
    static SESSIONSERIALIZED_REGEX: string;
    static HUMAN_CATEGORIES: string[];
    static HUMAN_CATEGORIES_$LI$(): string[];
}
declare namespace classes {
    enum EnumClassEnv {
        ONLINE = 0,
        IN_PERSON = 1
    }
    /** @ignore */
    class EnumClassEnv_$WRAPPER {
        protected _$ordinal: number;
        protected _$name: string;
        value: any;
        constructor(_$ordinal: number, _$name: string, value: any);
        getValue(): string;
        name(): string;
        ordinal(): number;
        compareTo(other: any): number;
    }
}
declare namespace classes {
    enum EnumOnlineClassType {
        VM = 0,
        CODER_CLASSROOM = 1,
        NEW_CODER_CLASSROOM = 2
    }
    /** @ignore */
    class EnumOnlineClassType_$WRAPPER {
        protected _$ordinal: number;
        protected _$name: string;
        value: any;
        constructor(_$ordinal: number, _$name: string, value: any);
        getValue(): string;
        name(): string;
        ordinal(): number;
        compareTo(other: any): number;
    }
}
declare namespace classes {
    enum EnumClassroomType {
        CLASS_SESSION = 0,
        INDIE_SESSION = 1
    }
    /** @ignore */
    class EnumClassroomType_$WRAPPER {
        protected _$ordinal: number;
        protected _$name: string;
        value: any;
        constructor(_$ordinal: number, _$name: string, value: any);
        getValue(): string;
        name(): string;
        ordinal(): number;
        compareTo(other: any): number;
    }
}
declare namespace classes.logging {
    enum EnumAttendanceValue {
        LATE = 0,
        LATE_WITH_COMPLICATIONS = 1,
        PRESENT = 2,
        ABSENT = 3,
        PRESENT_WITH_COMPLICATIONS = 4
    }
    /** @ignore */
    class EnumAttendanceValue_$WRAPPER {
        protected _$ordinal: number;
        protected _$name: string;
        value: any;
        constructor(_$ordinal: number, _$name: string, value: any);
        getValue(): string;
        name(): string;
        ordinal(): number;
        compareTo(other: any): number;
    }
}
declare enum EnumeratedPaymentStatus {
    IN_CART = 0,
    PAYMENT_PENDING = 1,
    PAYMENT_INCOMPLETE = 2,
    PAID = 3,
    CANCELLED = 4
}
/** @ignore */
declare class EnumeratedPaymentStatus_$WRAPPER {
    protected _$ordinal: number;
    protected _$name: string;
    label: any;
    constructor(_$ordinal: number, _$name: string, label: any);
    getLabel(): string;
    static getStrValues(): string[];
    static getLabeledVals(): string[];
    name(): string;
    ordinal(): number;
    compareTo(other: any): number;
}
declare namespace classsessions {
    enum EnumClassSessionTechType {
        IN_PERSON = 0,
        CODER = 1,
        NEW_CODER = 2,
        VM = 3,
        MINECRAFT = 4
    }
    /** @ignore */
    class EnumClassSessionTechType_$WRAPPER {
        protected _$ordinal: number;
        protected _$name: string;
        id: any;
        getId(): string;
        constructor(_$ordinal: number, _$name: string, value: any);
        getValue(): string;
        name(): string;
        ordinal(): number;
        compareTo(other: any): number;
    }
}
declare enum EnumPaymentMethod {
    CASH_OR_CHECK = 0,
    CREDIT_CARD = 1,
    WECHAT = 2,
    ALIPAY = 3,
    PARTNER = 4,
    FREE = 5
}
/** @ignore */
declare class EnumPaymentMethod_$WRAPPER {
    protected _$ordinal: number;
    protected _$name: string;
    value: any;
    constructor(_$ordinal: number, _$name: string, value: any);
    getValue(): string;
    name(): string;
    ordinal(): number;
    compareTo(other: any): number;
}
declare enum EnumDiscountValueType {
    AMOUNT = 0,
    PERCENTAGE = 1
}
/** @ignore */
declare class EnumDiscountValueType_$WRAPPER {
    protected _$ordinal: number;
    protected _$name: string;
    value: any;
    constructor(_$ordinal: number, _$name: string, value: any);
    getValue(): string;
    name(): string;
    ordinal(): number;
    compareTo(other: any): number;
}
declare enum EnumStripeAccountLabel {
    US = 0,
    HK = 1
}
declare enum EnumProgressType {
    FREE_TRIAL_PST = 0,
    ENROLLMENT_PST = 1,
    ACCOUNT_CHOOSE_PST = 2,
    ACCOUNT_PARENT_PST = 3,
    ACCOUNT_SINGLE_CHILD_PST = 4,
    ACCOUNT_CHILDREN_PST = 5,
    NOT_LOGGED_IN = 6,
    PARENT_LOGGED_IN = 7,
    STUDENT_LOGGED_IN = 8,
    FREE_TRIAL_PT = 9,
    ENROLLMENT_PT = 10,
    ACCOUNT_CREATION_PT = 11
}
/** @ignore */
declare class EnumProgressType_$WRAPPER {
    protected _$ordinal: number;
    protected _$name: string;
    value: any;
    constructor(_$ordinal: number, _$name: string, value: any);
    getId(): string;
    getValue(): string;
    name(): string;
    ordinal(): number;
    compareTo(other: any): number;
}
declare namespace coder {
    enum EnumCoderMode {
        RUN = 0,
        PROJECT = 1,
        PROBLEM = 2,
        VIDEO = 3,
        VM = 4
    }
    /** @ignore */
    class EnumCoderMode_$WRAPPER {
        protected _$ordinal: number;
        protected _$name: string;
        mode: any;
        constructor(_$ordinal: number, _$name: string, mode: any);
        toString(): string;
        name(): string;
        ordinal(): number;
        compareTo(other: any): number;
    }
}
declare enum EnumFreeTrialStep {
    DONE = 0,
    THREE_DAY_BEFORE_CLASS = 1,
    SENT = 2,
    PENDING = 3,
    TWO_WEEKS_BEFORE_CLASS_EMAIL_SENT = 4,
    OVER_TWO_WEEKS_BEFORE_CLASS = 5,
    NOT_SENT = 6,
    DENIED = 7,
    ONE_WEEK_BEFORE_CLASS = 8,
    ONE_WEEK_BEFORE_CLASS_EMAIL_AND_TEXT_SENT = 9,
    APPROVED = 10,
    INCOMPLETE = 11,
    TEXTED_NO_RESPONSE = 12,
    SENT_NO_RESPONSE = 13,
    RESPONSE_INTERESTED = 14,
    RESPONSE_INTERESTED_NEED_HELP = 15,
    RESPONSE_NOT_INTERESTED = 16,
    COMPLETE = 17,
    TWO_WEEKS_BEFORE_CLASS = 18,
    NOT_RESPONDED = 19,
    PENDING_TA_APPROVAL = 20,
    PICK_AND_CONFIRM_TIME = 21,
    CONFIRM_TIME = 22,
    ASSIGN_INSTRUCTOR = 23,
    WAITING_APPROVAL = 24,
    APPROVE_REC = 25,
    INSTRUCTOR_CONFIRM = 26,
    FOLLOW_UP = 27,
    REACH_OUT = 28,
    NOENROLL = 29,
    ADDED = 30,
    SCHEDULING_TRIAL = 31,
    TRIAL_SCHEDULED = 32,
    REACH_OUT_IN_2020 = 33,
    TRIAL_RESCHEDULE_REQUIRED = 34,
    TRIAL_RECOMMENDATION_SENT = 35,
    ENROLLED = 36,
    REACHED_OUT = 37,
    TOO_YOUNG = 38
}
/** @ignore */
declare class EnumFreeTrialStep_$WRAPPER {
    protected _$ordinal: number;
    protected _$name: string;
    id: any;
    static of(value: any): EnumFreeTrialStep;
    getId(): string;
    constructor(_$ordinal: number, _$name: string, value: any);
    getValue(): string;
    name(): string;
    ordinal(): number;
    compareTo(other: any): number;
}
declare namespace fires {
    enum EnumFireType {
        CLASS = 0,
        TECH_NOTE = 1,
        WEBSITE = 2,
        OTHER = 3
    }
    /** @ignore */
    class EnumFireType_$WRAPPER {
        protected _$ordinal: number;
        protected _$name: string;
        value: any;
        constructor(_$ordinal: number, _$name: string, value: any);
        getValue(): string;
        name(): string;
        ordinal(): number;
        compareTo(other: any): number;
    }
}
declare enum EnumTaskPersonIdAssignments {
    ADMIN_PERSONID = 0,
    SYSTEM_PERSONID = 1,
    OPS_PERSONID = 2,
    FIREMAN_PERSONID = 3,
    TOFU_PERSONID = 4
}
/** @ignore */
declare class EnumTaskPersonIdAssignments_$WRAPPER {
    protected _$ordinal: number;
    protected _$name: string;
    value: any;
    constructor(_$ordinal: number, _$name: string, value: any);
    getValue(): number;
    name(): string;
    ordinal(): number;
    compareTo(other: any): number;
}
/**
 * Enum for listing where a tag or a crm note
 * can be applied from
 * @enum
 * @property {EnumAppliedFromSource} FREE_TRIAL
 * @property {EnumAppliedFromSource} AGENT_CHAT
 * @property {EnumAppliedFromSource} ADMIN_DASHBOARD
 * @property {EnumAppliedFromSource} TASK
 * @property {EnumAppliedFromSource} CRM_DATA_CHANGE
 * @property {EnumAppliedFromSource} ENROLLMENT
 * @class
 */
declare enum EnumAppliedFromSource {
    FREE_TRIAL = 0,
    AGENT_CHAT = 1,
    ADMIN_DASHBOARD = 2,
    TASK = 3,
    CRM_DATA_CHANGE = 4,
    ENROLLMENT = 5
}
declare namespace students {
    enum EnumTechTestResult {
        NEVER_TAKEN = 0,
        ONE_OR_MORE_STEPS_FAILED = 1,
        ALL_PASSED_DIFFERENT_TIMES = 2,
        ALL_PASSED_DIFFERENT_BROWSER = 3,
        BACKGROUND_PASSED = 4,
        ALL_PASSED = 5
    }
}
declare enum EnumTagType {
    TYPING_SPEED = 0,
    BEHAVIOR = 1,
    COMMUNICATION = 2,
    TRIAL_PERFORMANCE = 3
}
/** @ignore */
declare class EnumTagType_$WRAPPER {
    protected _$ordinal: number;
    protected _$name: string;
    value: any;
    constructor(_$ordinal: number, _$name: string, value: any);
    getValue(): string;
    name(): string;
    ordinal(): number;
    compareTo(other: any): number;
}
declare namespace referrals {
    enum EnumReferralPaymentRecipient {
        PARTNER = 0,
        KTBYTE = 1
    }
    /** @ignore */
    class EnumReferralPaymentRecipient_$WRAPPER {
        protected _$ordinal: number;
        protected _$name: string;
        value: any;
        constructor(_$ordinal: number, _$name: string, value: any);
        getValue(): string;
        name(): string;
        ordinal(): number;
        compareTo(other: any): number;
    }
}
declare class FreeTrialReportCardDto {
    studentFirstName: string;
    studentLastName: string;
    metrics: Array<FreeTrialFeedbackMetricScoreDto>;
    classLevelRec: string;
    classRecs: Array<ClassRecommendationDto>;
    publicNote: string;
    wpm: number;
    referral: string;
    parentStudentGoals: string[];
    tags: string[];
    tofuTags: Array<TofuTagDTO>;
    sanitizedRecommendations: string[];
    isFeedbackCompleted: boolean;
    assignedTeacherName: string;
    constructor();
}
declare class AdDTO {
    id: number;
    adName: string;
    postTimestampEpochMilli: number;
    cost: number;
    postUrl: string;
    totalLikes: number;
    totalLikesUpdatedTimestampEpochMilli: number;
    totalViews: number;
    totalViewsUpdatedTimestampEpochMilli: number;
    goalTotalViews: number;
    goalTotalLeads: number;
    goalTotalTrials: number;
    goalTotalEnrollments: number;
    wechatQRCode: WeChatCustomQRCodeResponse;
    totalLeads: number;
    totalTrials: number;
    totalEnrollments: number;
    revenueBySemester: any;
    revenue: number;
    viewToLeadRate: number;
    leadToTrialRate: number;
    trialToEnrollmentRate: number;
    costPerLead: number;
    costPerTrial: number;
    customerAquisitionCost: number;
    constructor();
}
declare class UserTechTestStepsDto {
    websocket: Array<TechTestStepDto>;
    audio: Array<TechTestStepDto>;
    bandwidth: Array<TechTestStepDto>;
    jsBenchmark: Array<TechTestStepDto>;
    webcam: Array<TechTestStepDto>;
    mic: Array<TechTestStepDto>;
    annex: Array<TechTestStepDto>;
    addStepDto(stepDto: TechTestStepDto): void;
    constructor();
}
declare class DesktopStateAndURL {
    state: any;
    url: string;
    instanceState: any;
    getInstanceState(): any;
    setInstanceState(instanceState: any): void;
    getState(): any;
    setState(state: any): void;
    getUrl(): string;
    setUrl(url: string): void;
    constructor(state: any, instanceState: any, url: string);
}
declare class PartnerContractDto {
    id: number;
    partnerPersonId: number;
    partnerFirstName: string;
    partnerLastName: string;
    partnerUsername: string;
    rewards: Array<PartnerContractRewardDto>;
    timestamp: number;
    constructor();
}
declare class ProjectRecommendationsResponse {
    projects: Array<UserProjectResponse>;
    constructor(projects: Array<UserProjectResponse>);
}
declare class StaffFreeTimeBlockDto {
    personId: number;
    startTimeEpoch: number;
    endTimeEpoch: number;
    constructor();
}
declare class ReplicationBucketDTO {
    lowerBound: number;
    upperBound: number;
    isFinal: boolean;
    table: string;
    constructor(lowerBound: number, upperBound: number, isFinal: boolean, table: string);
}
declare class ClassSessionSummary {
    classSessionId: number;
    sessionSerialized: string;
    firstSession: number;
    lastSession: number;
    students: Array<KtbyteEarthUser>;
    teachers: Array<KtbyteEarthUser>;
    recommendationSubmittedCount: number;
    recommendationApprovedCount: number;
    recommendationEmailedCount: number;
    constructor(classSessionId: number, sessionSerialized: string, firstSession: number, lastSession: number, students: Array<KtbyteEarthUser>, teachers: Array<KtbyteEarthUser>, recommendationSubmittedCount: number, recommendationApprovedCount: number, recommendationEmailedCount: number);
}
declare class KtbyteCrmVmInfo {
    personId: number;
    vmUsername: string;
    constructor();
}
declare class CoderBetaNode {
    name: string;
    node_type: string;
    constructor(name: string, node_type: string);
    /**
     *
     * @return {string}
     */
    toString(): string;
}
declare class FreeTrialClassRecsWithStudentId {
    studentId: number;
    freeTrialRecs: Array<ClassRecommendationDto>;
    constructor();
}
declare class KtbyteEarthUser {
    id: number;
    personId: number;
    personEmail: string;
    email: string;
    username: string;
    secrethash: string;
    firstName: string;
    lastName: string;
    heardFrom: string;
    referralCode: string;
    referralValueType: string;
    phone: string;
    lastLoginTime: number;
    referralValue: number;
    bestTechTestScore: number;
    roles: Array<string>;
    vmInfo: string;
    techTestPassed: string;
    totalTechTestComputers: number;
    orientations: Array<OrientationDto>;
    totalEarnedCredit: number;
    totalAvailableCredit: number;
    totalPendingCredit: number;
    constructor(id?: any, personId?: any, personEmail?: any, email?: any, username?: any, secrethash?: any, referralCode?: any, firstName?: any, lastName?: any, lastLoginTime?: any);
    setBestTechTestScore(score: number): void;
    setRoles(roles: Array<string>): void;
    getId(): number;
    setId(value: number): void;
    getPersonId(): number;
    setPersonId(value: number): void;
    getPersonEmail(): string;
    setPersonEmail(value: string): void;
    getEmail(): string;
    setEmail(value: string): void;
    getUsername(): string;
    setUsername(value: string): void;
    getFirstName(): string;
    setFirstName(value: string): void;
    getLastName(): string;
    setLastName(value: string): void;
    getSecrethash(): string;
    setSecretHash(value: string): void;
    getHeardFrom(): string;
    setHeardFrom(value: string): void;
    getReferralCode(): string;
    setReferralCode(value: string): void;
    setReferralValue(value: number): void;
    getReferralValue(): number;
    setReferralValueType(value: string): void;
    getReferralValueType(): string;
    getVmInfo(): string;
    getBestTechTestScore(): number;
    getLastLoginTime(): number;
    setLastLoginDate(value: number): void;
    getRoles(): Array<string>;
    toString(): string;
    getPhone(): string;
    setPhone(phone: string): void;
}
declare class TableDifferenceHolderDTO {
    onlyHere: Array<number>;
    onlyThere: Array<number>;
    different: Array<number>;
    hereType: string;
    thereType: string;
    constructor();
}
declare class ReplicationMissingDataBatchResponse {
    datas: Array<ReplicationTableData>;
    constructor(datas: Array<ReplicationTableData>);
}
declare class ReferralShareDto {
    id: number;
    referrerPersonId: number;
    referrerName: string;
    refereePersonId: number;
    refereeName: string;
    shareType: string;
    shareTimestamp: number;
    firstFulfillmentTimestamp: number;
    timesFulfilled: number;
    route: string;
    refereeIp: string;
    refereeUserAgent: string;
    constructor();
}
declare class AgentTaskDto {
    created: number;
    taskDescription: string;
    comment: string;
    constructor();
}
declare class FreeTrialSolution {
    static TYPE_CHECKBOX: string;
    static TYPE_RADIO: string;
    corrects: boolean[];
    correct: boolean;
    show: boolean;
    constructor(corrects?: any, correct?: any, show?: any);
}
declare class CsltSingleUserEventsDto {
    personId: number;
    userType: string;
    firstName: string;
    lastName: string;
    attendanceEvents: Array<CsltUserEventDto>;
    screenFocusEvents: Array<CsltUserEventDto>;
    compilationEvents: Array<CsltUserEventDto>;
    constructor();
}
declare class ProjectCommentResponse {
    id: number;
    votes: number;
    name: string;
    avatar: string;
    username: string;
    content: string;
    voted: string;
    createdAt: string;
    constructor(id: number, name: string, avatar: string, username: string, content: string, votesCount: number, voted: string, createdAt: string);
}
declare class ClassSessionRecommendationDto {
    id: number;
    sessionSerialized: string;
    constructor();
}
declare class WeeklongSessionSetInfo {
    shortcode: string;
    name: string;
    description: string;
    prerequisites: string;
    fee: number;
    discountedFee: number;
    sessions: Array<WeeklongSessionInfo>;
    slideshow: string;
    constructor();
}
declare class KtbyteCrmRows {
    rows: Array<KtbyteCrmRow>;
    constructor();
}
declare class NotificationDTO {
    id: number;
    personId: number;
    message: string;
    createdTimeEpoch: number;
    wasSeen: boolean;
    resolutionLink: string;
    constructor();
    getResolutionLink(): string;
    setResolutionLink(resolutionLink: string): void;
    isWasSeen(): boolean;
    setWasSeen(wasSeen: boolean): void;
    getCreatedTimeEpoch(): number;
    setCreatedTimeEpoch(createdTimeEpoch: number): void;
    getMessage(): string;
    setMessage(message: string): void;
    getPersonId(): number;
    setPersonId(personId: number): void;
    getId(): number;
    setId(id: number): void;
}
declare class PersonSearchResult {
    constructor(personId?: any, first?: any, last?: any, type?: any, coupons?: any);
    personId: number;
    first: string;
    last: string;
    type: string;
    coupons: Array<string>;
    enrollments: Array<Enrollment>;
    getPersonId(): number;
    setPersonId(personId: number): void;
    getFirst(): string;
    setFirst(first: string): void;
    getLast(): string;
    setLast(last: string): void;
    getType(): string;
    setType(type: string): void;
    getCoupons(): Array<string>;
    setCoupons(coupons: Array<string>): void;
    getEnrollments(): Array<Enrollment>;
    setEnrollments(enrollments: Array<Enrollment>): void;
}
declare class RecommendationDto {
    created: number;
    classCode: string;
    forClassCode: string;
    custom: boolean;
    constructor(created?: any, classCode?: any, forClassCode?: any, custom?: any);
    getCreated(): number;
    setCreated(created: number): void;
    getClassCode(): string;
    setClassCode(classCode: string): void;
    getForClassCode(): string;
    setForClassCode(forClassCode: string): void;
    getCustom(): boolean;
    setCustom(custom: boolean): void;
}
declare class PersonSummaryDTO {
    personId: number;
    crmId: number;
    firstName: string;
    lastName: string;
    username: string;
    classSessions: Array<ClassSessionDto>;
    email: string;
    phone: string;
    secretHash: string;
    constructor(personId: number, crmId: number, firstName: string, lastName: string, username: string, classSessions: Array<ClassSessionDto>, email: string, phone: string, secretHash: string);
}
declare class GradeResponse {
    status: string;
    error: string;
    output: string;
    errorLine: number;
    cases: Array<TestCaseResult>;
    points: number;
    constructor();
}
declare class ClassSessionSetRecommendationDto {
    classSessionSetId: number;
    shortcode: string;
    constructor();
}
declare class ParentEnrollmentsDto {
    childrenEnrollments: any;
    classSessionSetIdToClassSessionSet: any;
    constructor();
    addChildEnrollment(childUser: KtbyteEarthUser, classSession: KtbyteClassSession): void;
    addFreeTrial(childUser: KtbyteEarthUser, trialDto: FreeTrialDTO): void;
    addRecommendations(childUser: KtbyteEarthUser, recommendations: ClassRecommendationModelDto): void;
    hasAnyEnrollments(): boolean;
}
declare class UserActionRewardDto {
    id: number;
    actionId: number;
    actionTitle: string;
    rewardValueType: string;
    reward: number;
    rewardEarner: string;
    constructor();
}
declare class ReferralDto {
    id: number;
    paymentRecipient: string;
    referrerPersonId: number;
    referrerName: string;
    refereePersonId: number;
    refereeName: string;
    refereeUsername: string;
    refereeParentName: string;
    refereeParentEmail: string;
    refereeParentPhone: string;
    refereeParentWechatId: string;
    studentAlternativeName: string;
    age: number;
    gender: string;
    note: string;
    timestamp: number;
    /**
     *
     * @param {*} o
     * @return {boolean}
     */
    equals(o: any): boolean;
    constructor();
}
declare class UserFollowerResponse {
    id: number;
    followersCount: number;
    followingCount: number;
    heartsCount: number;
    heartedCount: number;
    username: string;
    name: string;
    avatar: string;
    followed: boolean;
    constructor(id: number, followersCount: number, followingCount: number, heartsCount: number, heartedCount: number, username: string, name: string, avatar: string, followed: boolean);
    setId(id: number): void;
    setFollowersCount(followersCount: number): void;
    setFollowingCount(followingCount: number): void;
    setUsername(username: string): void;
    setName(name: string): void;
    setAvatar(avatar: string): void;
    setFollowed(followed: boolean): void;
    setHeartsCount(hearts: number): void;
    setHeartedCount(hearts: number): void;
}
declare abstract class Dto {
    id: number;
    setId(id: number): void;
    constructor();
}
declare class PartnerContractRewardDto {
    id: number;
    contractId: number;
    actionId: number;
    actionTitle: string;
    rewardValueType: string;
    rewardEarnerType: string;
    reward: number;
    constructor(actionId?: any, actionTitle?: any, rewardValueType?: any, rewardEarnerType?: any, reward?: any);
}
declare class TechTestStepDto {
    personId: number;
    step: EnumeratedTechTestStep;
    isPassed: boolean;
    os: string;
    browser: string;
    userAgentHeader: string;
    testStartTimeEpoch: number;
    testMode: TechTestStepDto.TechTestMode;
    timestampMilliseconds: number;
    resultJson: string;
    constructor(personId?: any, step?: any, isPassed?: any, os?: any, browser?: any, timestampMilliseconds?: any, resultJson?: any);
}
declare namespace TechTestStepDto {
    enum TechTestMode {
        BACKGROUND = 0,
        INTERFACE = 1
    }
    /** @ignore */
    class TechTestMode_$WRAPPER {
        protected _$ordinal: number;
        protected _$name: string;
        value: any;
        constructor(_$ordinal: number, _$name: string, value: any);
        getValue(): string;
        name(): string;
        ordinal(): number;
        compareTo(other: any): number;
    }
}
declare class FreeTrialFeedbackMetricDto {
    id: number;
    title: string;
    icon: string;
    description: string;
    required: boolean;
    constructor();
}
declare namespace FreeTrialFeedbackMetricDto {
    enum EnumFreeTrialFeedbackMetricTitle {
        COMPUTATIONAL_THINKING = 0,
        PROGRAMMING_KNOWLEDGE = 1,
        COMMUNICATION = 2,
        COMPUTER_MECHANICS = 3
    }
    /** @ignore */
    class EnumFreeTrialFeedbackMetricTitle_$WRAPPER {
        protected _$ordinal: number;
        protected _$name: string;
        value: any;
        constructor(_$ordinal: number, _$name: string, value: any);
        getValue(): string;
        name(): string;
        ordinal(): number;
        compareTo(other: any): number;
    }
}
declare class KtbyteCrmPartner {
    id: number;
    primary_personid: number;
    signed_status: number;
    contract_language: string;
    tuition_type: string;
    marketing_type: string;
    operations_type: string;
    tuitioncollection_type: string;
    initial_bonus_count: number;
    initial_bonus_rate_percentage: number;
    newonlinestudent_rate_percent: number;
    continuingstudent_rate_percent: number;
    newhybridstudent_rate_percent: number;
    expiration_date_str: string;
    hybrid_type: string;
    address: string;
    getAddress(): string;
    setAddress(address: string): void;
    business_name: string;
    getHybrid_type(): string;
    setHybrid_type(hybrid_type: string): void;
    getId(): number;
    setId(id: number): void;
    getPrimary_personid(): number;
    setPrimary_personid(primary_personid: number): void;
    getSigned_status(): number;
    setSigned_status(signed_status: number): void;
    getContract_language(): string;
    setContract_language(contract_language: string): void;
    getTuition_type(): string;
    setTuition_type(tuition_type: string): void;
    getMarketing_type(): string;
    setMarketing_type(marketing_type: string): void;
    getOperations_type(): string;
    setOperations_type(operations_type: string): void;
    getTuitioncollection_type(): string;
    setTuitioncollection_type(tuitioncollection_type: string): void;
    getInitial_bonus_count(): number;
    setInitial_bonus_count(initial_bonus_count: number): void;
    getInitial_bonus_rate_percentage(): number;
    setInitial_bonus_rate_percentage(initial_bonus_rate_percentage: number): void;
    getNewonlinestudent_rate_percent(): number;
    setNewonlinestudent_rate_percent(newonlinestudent_rate_percent: number): void;
    getContinuingstudent_rate_percent(): number;
    setContinuingstudent_rate_percent(continuingstudent_rate_percent: number): void;
    getNewhybridstudent_rate_percent(): number;
    setNewhybridstudent_rate_percent(newhybridstudent_rate_percent: number): void;
    getExpiration_date_str(): string;
    setExpiration_date_str(expiration_date_str: string): void;
    constructor();
}
declare class AnswerResponse {
    question: string;
    response: string;
    getQuestion(): string;
    getResponse(): string;
    constructor(question: string, response: string);
}
declare class NewCSLTRequest {
    constructor(classSessionSerialized: string, dates: string[], startTime: string, duration: number);
    classSessionSerialized: string;
    dates: string[];
    startTime: string;
    duration: number;
}
declare class CoderBetaProjectReturn {
    projectDTO: CoderBetaProjectDTO;
    studentid: number;
    constructor(studentid: number, projectDTO: CoderBetaProjectDTO);
}
interface ProblemDto {
    coursenumberstring: string;
    psetname: string;
    psetnumber: string;
    psetid: number;
    problemnumber: string;
    problemid: number;
    psetproblemid: number;
    title: string;
    titleanchor: string;
    textrecording: string;
    filelocation: string;
    points: string;
    statement: string;
    submitURL: string;
    originalDefault: string;
    defaultCode: string;
}
declare class GetUserProjectsDto {
    userId: number;
    orderBy: string;
    search: string;
    constructor(userId: number, orderBy: string, search: string);
}
declare class QuotaResults {
    blocks: number;
    blocksQuota: number;
    blocksLimit: number;
    files: number;
    filesQuota: number;
    filesLimit: number;
    getBlocks(): number;
    constructor(blocks: number, blocksQuota: number, blocksLimit: number, files: number, filesQuota: number, filesLimit: number);
    getBlocksQuota(): number;
    getBlocksLimit(): number;
    getFiles(): number;
    getFilesQuota(): number;
    getFilesLimit(): number;
}
declare class ReplicationTableInfo {
    maxMasterTime: number;
    maxMasterTimeNonMatching: number;
    maxSlaveTime: number;
    maxSlaveTimeNonMatching: number;
    foundRowWithMasterId: boolean;
    constructor();
}
declare class PersonDto {
    id: number;
    primaryPersonId: number;
    secondaryPersonIds: string;
    parentRowIds: string;
    childRowIds: string;
    firstName: string;
    lastName: string;
    secondaryEmails: string;
    phone: string;
    address: string;
    heardFrom: string;
    referralCode: string;
    referralValue: number;
    referralValueType: string;
    birthDate: string;
    recommendation: string;
    gender: string;
    schoolInfo: string;
    otherJson: string;
    tags: string;
    note: string;
    isRemoved: boolean;
    vminfo: string;
    trialTime: number;
    trialSession: string;
    typingSpeed: number;
    freeTrial: string;
    availability: string;
    preferredContactLanguage: string;
    fromAdId: number;
    region: string;
    constructor();
}
/**
 * Class representing getList request parameters
 * @class
 */
declare class GetListRequestDto {
    sort: Array<string>;
    range: Array<number>;
    filter: string;
    constructor();
}
declare class RecommendationsDto {
    good: Array<RecommendationDto>;
    ok: Array<RecommendationDto>;
    bad: Array<RecommendationDto>;
    constructor();
}
declare class ReferrerSingleTypeShareStatsDto {
    referrerPersonId: number;
    totalShares: number;
    totalFulfilledShares: number;
    constructor(referrerPersonId: number);
}
declare class HelpMeetingDto {
    isOpen: boolean;
    url: string;
    constructor(isOpen: boolean, url: string);
}
declare class ClassroomPadHistoryDto {
    id: number;
    roomId: string;
    roomType: string;
    username: string;
    openPadWindow: string;
    textPad: string;
    blocklyPad: string;
    createdDateEpoch: number;
    constructor();
}
declare class ClassSessionMakeLocationDTO {
    id: number;
    name: string;
    constructor(id: number, name: string);
}
declare class ClassSessionMakeSetDTO {
    id: number;
    code: string;
    fee: number;
    constructor(id: number, code: string, fee: number);
}
declare class ClassSessionMakeDTO {
    id: number;
    sessionSerialized: string;
    duration: number;
    username: string;
    category: number;
    location: number;
    set: number;
    curricula: number;
    humanFormat: number;
    techType: number;
    time: number;
    humanTime: string;
    instructorId: number;
    tas: Array<number>;
    fee: number;
    capacity: number;
    calendarPreset: number;
    lessonDates: any;
    firstLessonTime: string;
    lessonsTotal: number;
    constructor(id: number, sessionSerialized: string, duration: number, username: string, firstLessonTime: string, lessonsTotal: number);
}
declare class ClassSessionMakeInstructorDTO {
    id: number;
    username: string;
    name: string;
    constructor(id: number, username: string, name: string);
}
declare class ClassSessionMakeCurriculaDTO {
    id: number;
    code: string;
    constructor(id: number, code: string);
}
declare class ReplicationMissingDataBatchRequest {
    requests: Array<ReplicationMissingDataBatchRequest.ReplicationMissingDataRequest>;
    replicationId: string;
    lastDeleteTime: number;
    constructor(requests: Array<ReplicationMissingDataBatchRequest.ReplicationMissingDataRequest>);
}
declare namespace ReplicationMissingDataBatchRequest {
    class ReplicationMissingDataRequest {
        tableClassName: string;
        slaveMaxAllTimeMs: number;
        slaveMaxNonmasterTimeMs: number;
        fetchAllMissing: boolean;
        fetchMatchingMissing: boolean;
        constructor(tableClassName: string, slaveMaxAllTimeMs: number, slaveMaxNonmasterTimeMs: number, fetchAllMissing: boolean, fetchMatchingMissing: boolean);
    }
}
declare class ResponseSuccess<T> {
    success: boolean;
    reason: string;
    data: T;
    constructor(success?: any, reason?: any);
    getSuccess(): boolean;
    setSuccess(success: boolean): void;
    getReason(): string;
    setReason(reason: string): void;
    getData(): T;
    setData(data: T): void;
}
declare class ReplicationTableSpecificInfo {
}
declare class SankeyLinkDto {
    source: string;
    target: string;
    value: number;
    constructor(source: string, target: string, value: number);
}
declare class RegionDTO {
    id: number;
    name: string;
    registryUrl: string;
    constructor(id: number, name: string, registryUrl: string);
    getId(): number;
    setId(id: number): void;
    getName(): string;
    setName(name: string): void;
    getRegistryUrl(): string;
    setRegistryUrl(registryUrl: string): void;
}
declare class DesktopDTO {
    id: number;
    syncSizeMb: number;
    name: string;
    turnOffWhenDisconnected: boolean;
    keepOnUntil: number;
    cpuLimit: string;
    memLimit: string;
    regionId: number;
    lastInstanceSize: number;
    _cached_DesktopInstances: Array<DesktopInstanceDTO>;
    _cached_Region: RegionDTO;
    _cached_getStateNonSynchronized: string;
    _cached_getMasterIfOnlyOneUnsafe: DesktopInstanceDTO;
    constructor(id?: any, syncSizeMb?: any, name?: any, turnOffWhenDisconnected?: any, keepOnUntil?: any, cpuLimit?: any, memlimit?: any, regionId?: any, lastInstanceSize?: any, lastStopTimeSeconds?: any);
    getName(): string;
    setName(name: string): void;
    getId(): number;
    setId(id: number): void;
    getSyncSizeMb(): number;
    setSyncSizeMb(syncSizeMb: number): void;
    isTurnOffWhenDisconnected(): boolean;
    getTurnOffWhenDisconnected(): boolean;
    setTurnOffWhenDisconnected(turnOffWhenDisconnected: boolean): void;
    getKeepOnUntil(): number;
    setKeepOnUntil(keepOnUntil: number): void;
    getCpuLimit(): string;
    setCpuLimit(cpuLimit: string): void;
    getMemLimit(): string;
    setMemLimit(memLimit: string): void;
    getRegionId(): number;
    setRegionId(regionId: number): void;
    getLastInstanceSize(): number;
    setLastInstanceSize(lastInstanceSize: number): void;
}
declare class DesktopInstanceDTO {
    id: number;
    desktopId: number;
    nodeId: number;
    state: string;
    stateTime: number;
    loopDevice: string;
    guacUsername: string;
    guacPassword: string;
    guacPort: number;
    vncPort: number;
    sshPort: number;
    statusPort: number;
    guacSshPort: number;
    successiveFails: number;
    _cached_Node: NodeDTO;
    constructor(id?: any, desktopId?: any, nodeId?: any, state?: any, stateTime?: any, loopDevice?: any, guacUsername?: any, guacPassword?: any, guacPort?: any, vncPort?: any, sshPort?: any, statusPort?: any, guacSshPort?: any, successiveFails?: any);
    getId(): number;
    setId(id: number): void;
    getDesktopId(): number;
    setDesktopId(desktopId: number): void;
    getNodeId(): number;
    setNodeId(nodeId: number): void;
    getState(): string;
    setState(state: string): void;
    getStateTime(): number;
    setStateTime(stateTime: number): void;
    getLoopDevice(): string;
    setLoopDevice(loopDevice: string): void;
    getGuacUsername(): string;
    setGuacUsername(guacUsername: string): void;
    getGuacPassword(): string;
    setGuacPassword(guacPassword: string): void;
    getGuacPort(): number;
    setGuacPort(guacPort: number): void;
    getVncPort(): number;
    setVncPort(vncPort: number): void;
    getSshPort(): number;
    setSshPort(sshPort: number): void;
    getStatusPort(): number;
    setStatusPort(statusPort: number): void;
    getGuacSshPort(): number;
    setGuacSshPort(guacSshPort: number): void;
    getSuccessiveFails(): number;
    setSuccessiveFails(successiveFails: number): void;
}
declare class ClusterDTO {
    id: number;
    name: string;
    regionId: number;
    gproxyHostName: string;
    gproxySshPort: number;
    gproxyApacheHttps: boolean;
    successiveFails: number;
    linkedNodeId: number;
    _cached_Region: RegionDTO;
    constructor(id: number, name: string, regionId: number, gproxyHostName: string, gproxySshPort: number, gproxyApacheHttps: boolean, successiveFails: number, linkedNodeId: number);
    getId(): number;
    setId(id: number): void;
    getName(): string;
    setName(name: string): void;
    getRegionId(): number;
    setRegionId(regionId: number): void;
    getGproxyHostName(): string;
    setGproxyHostName(gproxyHostName: string): void;
    getGproxySshPort(): number;
    setGproxySshPort(gproxySshPort: number): void;
    isGproxyApacheHttps(): boolean;
    getGproxyApacheHttps(): boolean;
    setGproxyApacheHttps(gproxyApacheHttps: boolean): void;
    getSuccessiveFails(): number;
    setSuccessiveFails(successiveFails: number): void;
    getLinkedNodeId(): number;
    setLinkedNodeId(linkedNodeId: number): void;
}
declare class NodeDTO {
    id: number;
    sshHostname: string;
    sshPort: number;
    humanName: string;
    sshUsername: string;
    openPortsMin: number;
    openPortsMax: number;
    preferNumberOfDesktops: number;
    clusterId: number;
    successiveFails: number;
    disabled: boolean;
    terraformNodeId: number;
    _cached_Cluster: ClusterDTO;
    constructor(id: number, sshHostname: string, sshPort: number, humanName: string, sshUsername: string, openPortsMin: number, openPortsMax: number, preferNumberOfDesktops: number, clusterId: number, successiveFails: number, disabled: boolean, terraformNodeId: number);
    getId(): number;
    setId(id: number): void;
    getSshHostname(): string;
    setSshHostname(sshHostname: string): void;
    getSshPort(): number;
    setSshPort(sshPort: number): void;
    getHumanName(): string;
    setHumanName(hostName: string): void;
    getSshUsername(): string;
    setSshUsername(sshUsername: string): void;
    getOpenPortsMin(): number;
    setOpenPortsMin(openPortsMin: number): void;
    getOpenPortsMax(): number;
    setOpenPortsMax(openPortsMax: number): void;
    getPreferNumberOfDesktops(): number;
    setPreferNumberOfDesktops(preferNumberOfDesktops: number): void;
    getClusterId(): number;
    setClusterId(clusterId: number): void;
    getSuccessiveFails(): number;
    setSuccessiveFails(successiveFails: number): void;
    isDisabled(): boolean;
    getDisabled(): boolean;
    setDisabled(disabled: boolean): void;
    getTerraformNodeId(): number;
    setTerraformNodeId(terraformNodeId: number): void;
}
declare enum AgentTaskState {
    INCOMPLETE = 0,
    COMPLETE = 1,
    WAITING_APPROVAL = 2
}
/** @ignore */
declare class AgentTaskState_$WRAPPER {
    protected _$ordinal: number;
    protected _$name: string;
    value: any;
    constructor(_$ordinal: number, _$name: string, value: any);
    /**
     *
     * @return {string}
     */
    toString(): string;
    static fromString(text: any): AgentTaskState;
    name(): string;
    ordinal(): number;
    compareTo(other: any): number;
}
declare class AppointmentDto {
    id: number;
    assignedToPersonId: number;
    title: string;
    startTimeEpoch: number;
    endTimeEpoch: number;
    opPersonId: number;
    notes: string;
    busy: boolean;
    constructor();
}
declare class CoderBetaGradeRequest {
    problemId: string;
    psetId: string;
    studentCode: string;
    javablockCode: string;
    constructor();
}
declare class CoderBetaProjectFileUpload {
    static UPLOAD_TYPE_IMAGE: string;
    static UPLOAD_TYPE_ZIP: string;
    projectId: string;
    uploadType: string;
    fileName: string;
    content: string;
    constructor(projectId: string, uploadType: string, fileName: string, content: string);
    getProjectId(): string;
    setProjectId(projectId: string): void;
    getUploadType(): string;
    getFileName(): string;
    setFileName(fileName: string): void;
    setUploadType(uploadType: string): void;
    getContent(): string;
    setContent(content: string): void;
}
declare class CurriculumLessonPlanDto {
    id: number;
    curriculumId: number;
    lessonNumber: number;
    syllabusMarkdown: string;
    internalDescription: string;
    canonicalProjectId: number;
    constructor();
}
declare class StudentProjectDto {
    id: number;
    name: string;
    description: string;
    constructor();
}
declare class OpsAdditionalOptionsDto {
    id: number;
    type: string;
    labels: string[];
    constructor();
}
declare class CurriculumPsetsLessonPlans {
    curriculum: CurriculumDto;
    psets: Array<PSetDto>;
    lessonPlans: Array<CurriculumLessonPlanDto>;
    constructor();
}
declare class ClassSessionSetDto {
    id: number;
    shortCode: string;
    shortCodeHuman: string;
    slugString: string;
    humanName: string;
    humanDifficulty: string;
    syllabus: string;
    slideShow: string;
    classInfo: string;
    linkDeprecated: string;
    humanAgeRecommendation: string;
    weeklongNote: string;
    summerEveningNote: string;
    semesterOnlineNote: string;
    semesterInPersonNote: string;
    imageLink: string;
    masterId: string;
    masterTimeMs: number;
    slaveTimeMs: number;
    recommendations: RecommendationsDto;
    hasGradedAssignments: boolean;
    isOnline: boolean;
    classesControllerAcademicLevel: string;
    classesControllerDifficulty: number;
    classesControllerMaxDifficulty: number;
    classesControllerPrerequisite: string;
    classesControllerGroup: string;
    canonicalCurriculumId: number;
    getId(): number;
    constructor();
}
declare class ClassSessionIntendedAssignmentDto {
    id: number;
    classSessionId: number;
    psetId: number;
    weight: number;
    graderPersonId: number;
    gradeTime: number;
    duedate: number;
    constructor();
}
declare class CurriculumDto {
    id: number;
    code: string;
    name: string;
    autoAssignPSet: boolean;
    useEarthClassesPage: boolean;
    description: string;
    internalDescription: string;
    classPageColumns: string[];
    duplicatedFromId: number;
    classSessionSetId: number;
    constructor();
}
/**
 *
 * +-----------------------------+--------------+------+-----+---------+----------------+
 * | Field                       | Type         | Null | Key | Default | Extra          |
 * +-----------------------------+--------------+------+-----+---------+----------------+
 * | id                          | int(11)      | NO   | PRI | NULL    | auto_increment |
 * | sessionserialized           | varchar(255) | YES  |     | NULL    |                |
 * | extendedstaytag             | varchar(255) | YES  |     | NULL    |                |
 * | class_session_location      | int(11)      | YES  | MUL | NULL    |                |
 * | fee                         | int(11)      | YES  |     | NULL    |                |
 * | semester                    | varchar(255) | YES  |     | NULL    |                |
 * | humanprice                  | varchar(255) | YES  |     | NULL    |                |
 * | human_category              | varchar(100) | YES  |     | NULL    |                |
 * | human_format                | varchar(50)  | YES  |     | NULL    |                |
 * | paymenttype                 | int(11)      | YES  |     | NULL    |                |
 * | category                    | int(11)      | YES  |     | NULL    |                |
 * | calendar                    | varchar(255) | YES  |     | NULL    |                |
 * | time                        | varchar(255) | YES  |     | NULL    |                |
 * | curriculumid                | int(11)      | YES  | MUL | NULL    |                |
 * | class_session_set           | int(11)      | YES  | MUL | NULL    |                |
 * | hidden                      | tinyint(1)   | YES  |     | NULL    |                |
 * | closed                      | tinyint(1)   | YES  |     | NULL    |                |
 * | per_section_meeting_ids     | mediumtext   | YES  |     | NULL    |                |
 * | class_type_enum_id          | int(11)      | YES  |     | NULL    |                |
 * | tech_type                   | varchar(255) | YES  |     | NULL    |                |
 * | num_ta_per_student_required | int(11)      | YES  |     | NULL    |                |
 * | min_num_ta_required         | int(11)      | YES  |     | NULL    |                |
 * | tokbox_session_id           | varchar(100) | YES  |     | NULL    |                |
 * | tokbox_session_ip           | varchar(45)  | YES  |     | NULL    |                |
 * | is_routed                   | tinyint(1)   | YES  |     | 0       |                |
 * | use_annex                   | tinyint(1)   | YES  |     | 0       |                |
 * | master_id                   | varchar(255) | YES  | MUL | NULL    |                |
 * | master_timems               | bigint(20)   | YES  | MUL | NULL    |                |
 * | slave_timems                | bigint(20)   | YES  | MUL | NULL    |                |
 * | annex_server_id             | int(11)      | YES  |     | 2       |                |
 * +-----------------------------+--------------+------+-----+---------+----------------+
 * @class
 */
declare class ClassSessionDto {
    id: number;
    sessionSerialized: string;
    extendedStayTag: string;
    classSessionLocation: number;
    fee: number;
    semester: string;
    humanPrice: string;
    humanCategory: string;
    paymentType: number;
    category: number;
    calendar: string;
    time: string;
    curriculumId: number;
    classSessionSet: number;
    hidden: boolean;
    closed: boolean;
    perSectionMeetingIds: string;
    techType: string;
    numTaPerStudentRequired: number;
    masterId: string;
    masterTimeMs: number;
    slaveTimeMs: number;
    annexServerId: number;
    constructor(id?: any, calendar?: any, time?: any);
    static ToDisplayScheduleInformation(id: number, calendar: string, time: string): ClassSessionDto;
}
declare class ClassSessionLessonTimeDto {
    id: number;
    classSessionId: number;
    lessonNumber: number;
    title: string;
    description: string;
    url: string;
    image: string;
    lessonTime: string;
    lessonTimeEpoch: number;
    lessonDurationMinutes: number;
    masterId: string;
    masterTimeMs: number;
    slaveTimeMs: number;
    instructors: Array<KtbyteLessonTimeInstructor>;
    notes: string;
    workshopStudentIds: number[];
    opsPersonIds: number[];
    constructor();
}
declare class PSetDto {
    id: number;
    curriculumId: number;
    number: number;
    title: string;
    description: string;
    points: number;
    free: boolean;
    psetType: string;
    constructor();
}
declare class KtbyteCrmEmailStep {
    static ACTION_ADD_RECIPIENT_BY_CRMID: number;
    static ACTION_REMOVE_RECIPIENT_BY_CRMID: number;
    static ACTION_ADD_RECIPIENT_BY_TAG: number;
    static ACTION_REMOVE_RECIPIENT_BY_TAG: number;
    static ACTION_ADD_RECIPIENT_BY_courseSessionSerialized: number;
    static ACTION_REMOVE_RECIPIENT_BY_courseSessionSerialized: number;
    static ACTION_ADD_RECIPIENT_BY_EMAIL: number;
    static ACTION_REMOVE_RECIPIENT_BY_EMAIL: number;
    static ACTION_ADD_RECIPIENT_PARENTS: number;
    static ACTION_SET_TEMPLATE: number;
    static ACTION_SET_CUSTOM_CONTENT: number;
    static ACTION_SET_QUEUE_TIME: number;
    static ACTION_SEND_INSTANT: number;
    actionType: number;
    actionParamNumerous: Array<string>;
    constructor(actionType?: any, actionParam?: any);
}
declare class SearchLinkDto {
    id: number;
    title: string;
    link: string;
    constructor(id: number, title: string, link: string);
}
declare class CoderBetaShowcaseProjectResponse {
    totalvisits: number;
    monthlyvisits: number;
    projectDTO: CoderBetaProjectDTO;
    constructor(integer: number, monthlyvisits: number, projectDTO: CoderBetaProjectDTO);
}
declare class PsetWithMetadata {
    pset: KtbytePset;
    numProblems: number;
    teacherIdToProblemsDone: any;
    comments: Array<PsetCommentDTO>;
    constructor();
}
declare class PsetCommentDTO {
    teacherId: number;
    comment: string;
    constructor();
}
declare class ProjectCommentDto {
    projectId: number;
    content: string;
    constructor(projectId: number, content: string);
}
declare class ClassStudentRecommendationsDto {
    recommendations: Array<RecommendationDto>;
    description: string;
    constructor(recommendations?: any, description?: any);
    getRecommendations(): Array<RecommendationDto>;
    setRecommendations(recommendations: Array<RecommendationDto>): void;
    getDescription(): string;
    setDescription(description: string): void;
}
declare class RevenueDto {
    totalRevenue: number;
    contributors: any;
    constructor();
}
declare class FreeTrialTimeSlotDto {
    id: number;
    teacherPersonId: number;
    teacherFirstName: string;
    teacherLastName: string;
    opsPersonIds: Array<number>;
    opsPersonNames: Array<string>;
    startTimeEpoch: number;
    durationMinutes: number;
    type: string;
    classroomId: number;
    classEnvironment: string;
    trials: Array<FreeTrialDTO>;
    conflicted: boolean;
    constructor();
}
declare class FreeTrialStatsDto {
    total: number;
    totalCancelled: number;
    totalCompleted: number;
    totalConversions: number;
    weeks: Array<FreeTrialPeriodStatsDto>;
    months: Array<FreeTrialPeriodStatsDto>;
    constructor(total?: any, totalCancelled?: any, totalCompleted?: any, totalConversions?: any, weeks?: any, months?: any);
}
declare class CalendarEventSource {
    classSessionId: number;
    color: string;
    events: Array<KtbyteClassSessionLessonTime>;
    constructor();
}
declare class StudentClassRecommendationsDto {
    constructor();
    description: string;
    updated: number;
    recommendationList: Array<StudentClassRecommendationDto>;
}
declare class FreeTrialNoteDto {
    id: number;
    trialId: number;
    text: string;
    authorPersonId: number;
    authorFirstName: string;
    authorLastName: string;
    createdTimeEpoch: number;
    constructor();
}
declare class WeeklongCouponInfo {
    username: string;
    code: string;
    discount: string;
    constructor();
}
/**
 * Compilation result object contract
 * @class
 */
declare class ProcessingCompilationResult {
    transactionId: string;
    sourceLength: number;
    success: boolean;
    durationMillis: number;
    problems: Array<ProcessingCompilationProblem>;
    errorMessage: string;
    jsCode: string;
    /**
     * { candyName => CandyJavaScriptContent }
     */
    candiesFilesAndJsCode: any;
    completion: Array<string>;
    blocklyXml: string;
    sourceMap: string;
    generatedCodeLineOffset: number;
    constructor();
}
declare class ChildEnrollmentsDto {
    childUser: KtbyteEarthUser;
    selfStudyClasses: Array<KtbyteClassSession>;
    activeClasses: Array<KtbyteClassSession>;
    inactiveClasses: Array<KtbyteClassSession>;
    freeTrial: FreeTrialDTO;
    recommendations: Array<ClassRecommendationModelDto>;
    constructor(childUser: KtbyteEarthUser);
    addClassSession(classSession: KtbyteClassSession): void;
    addFreeTrial(trialDto: FreeTrialDTO): void;
    addRecommendations(recommendations: ClassRecommendationModelDto): void;
}
declare class KtbyteCrmVmInfos {
    vmUsernames: any;
    constructor();
}
declare class PsetInfo {
    id: number;
    number: number;
    title: string;
    type: PsetInfo.Type;
    done: boolean;
    good: boolean;
    averageGrade: number;
    constructor(id?: any, number?: any, title?: any, type?: any, done?: any, good?: any, average?: any);
}
declare namespace PsetInfo {
    enum Type {
        LECTURE = 0,
        HOMEWORK = 1,
        TEST = 2
    }
    /** @ignore */
    class Type_$WRAPPER {
        protected _$ordinal: number;
        protected _$name: string;
        key: any;
        constructor(_$ordinal: number, _$name: string, key: any);
        static from(key: any): PsetInfo.Type;
        name(): string;
        ordinal(): number;
        compareTo(other: any): number;
    }
}
declare class CurriculumEditorDto {
    curriculumPsetsLessonPlans: CurriculumPsetsLessonPlans;
    allClassSessionSets: Array<ClassSessionSetDto>;
    classSessionsInCurriculum: Array<ClassSessionDto>;
    duplicatedFrom: CurriculumDto;
    duplicatedBys: Array<CurriculumDto>;
    constructor();
}
declare class StripeAccountDto {
    accountLabel: string;
    publicKey: string;
    constructor(enumAccountLabel?: any, publicKey?: any);
    getAccountLabel(): string;
    setAccountLabel(value: string): void;
    getPublicKey(): string;
    setPublicKey(value: string): void;
}
declare class CoderBetaProjectSaveResponse {
    hasError: boolean;
    response: string;
    projectDTO: CoderBetaProjectDTO;
    constructor(hasError: boolean, response: string, projectDTO: CoderBetaProjectDTO);
}
declare class KtbyteEarthUserList {
    users: Array<KtbyteEarthUser>;
    constructor();
}
declare class FreeTrialEnrollmentDto {
    isChinaTrial: boolean;
    adId: number;
    studentFirstName: string;
    studentLastName: string;
    studentUsername: string;
    studentBirthDate: string;
    studentBirthMonth: number;
    studentBirthYear: number;
    gender: string;
    experience: string;
    geoLocation: string;
    timezone: string;
    startTimeEpoch: number;
    timeSlotDto: FreeTrialTimeSlotDto;
    originallyDesiredTimeSlotDto: FreeTrialTimeSlotDto;
    availableTimes: number[];
    location: string;
    parentCrmId: number;
    encryptedParentCrmId: string;
    parentFirstName: string;
    parentLastName: string;
    parentUsername: string;
    parentEmail: string;
    parentPhone: string;
    parentWechatId: string;
    preferredContactLanguage: string;
    heardFrom: string;
    constructor();
}
declare class RecommendationsTagsResult {
    recommendations: ClassStudentRecommendationsDto;
    tags: Array<string>;
    constructor();
}
declare class TestCaseResult {
    id: number;
    success: boolean;
    input: string;
    expected: string;
    output: string;
    constructor(id: number, success: boolean, input: string, expected: string, output: string);
}
declare class EnrolledStudentMap {
    map: any;
    users: any;
    constructor(map: any, users: any);
}
declare class CandyJavaScriptContent {
    candiesFileNames: Array<string>;
    candiesJsCode: Array<string>;
    constructor(candiesFileNames: Array<string>, candiesJsCode: Array<string>);
}
declare class KtbyteEarthProjectsActionResult {
    status: string;
    constructor();
}
declare abstract class ProgressStateWriteJson {
    skip: boolean;
    autoSubmit: boolean;
    constructor();
}
declare class ProgressStateType {
    static FREE_TRIAL_PST: string;
    static ENROLLMENT_PST: string;
    static ACCOUNT_CHOOSE_PST: string;
    static ACCOUNT_PARENT_PST: string;
    static ACCOUNT_SINGLE_CHILD_PST: string;
    static ACCOUNT_CHILDREN_PST: string;
    static NOT_LOGGED_IN: string;
    static PARENT_LOGGED_IN: string;
    static STUDENT_LOGGED_IN: string;
    static FREE_TRIAL_PT: string;
    static ENROLLMENT_PT: string;
    static ACCOUNT_CREATION_PT: string;
}
declare class InitiationBatch {
    progressStates: Array<ProgressStateTransfer>;
    progresses: any;
    isnew: boolean;
    redirect: boolean;
    csrf: string;
    roles: string[];
    constructor();
}
declare class ProgressDTO {
    id: number;
    activeStateId: number;
    userPersonId: number;
    type: string;
    sessionHash: string;
    constructor();
}
/**
 * Allows us to convert a java Exception to a DTO object.
 * Note that we did not make this extends Exception because
 * JSweet does something special with it to convert to a JS Error
 * @class
 */
declare class DTOException {
    detailMessage: string;
    errorCode: string;
    stackTrace: DTOException.DTOStackTraceElement[];
    suppressedExceptions: DTOException[];
    constructor();
}
declare namespace DTOException {
    abstract class DTOStackTraceElement {
        declaringClass: string;
        fileName: string;
        lineNumber: number;
        methodName: string;
        constructor();
    }
}
declare class ProgressAndStateBundle {
    pst: ProgressStateTransfer;
    ps: ProgressDTO;
    constructor(ps: ProgressDTO, pst: ProgressStateTransfer);
}
declare class ProgressStateTransfer {
    id: number;
    progressId: number;
    placeInProgress: number;
    stateType: string;
    writeJson: ProgressStateWriteJson;
    readJson: ProgressStateReadJson;
    isUser: boolean;
    message: string;
    hasError: boolean;
    constructor(id?: any, stateType?: any, progressId?: any, placeInProgress?: any, writeJson?: any, readJson?: any);
}
declare class ProgressStateException extends Error {
    errorCode: ProgressStateException.ErrorCode;
    static __com_ktbyte_dto_progressstate_ProgressStateException_serialVersionUID: number;
    constructor(err: ProgressStateException.ErrorCode);
    getErrorCode(): ProgressStateException.ErrorCode;
    getMessage(): string;
}
declare namespace ProgressStateException {
    enum ErrorCode {
        FinishedWithChildNoParent = 0,
        ErrorWithPreviousState = 1
    }
    /** @ignore */
    class ErrorCode_$WRAPPER {
        protected _$ordinal: number;
        protected _$name: string;
        message: any;
        constructor(_$ordinal: number, _$name: string, message: any);
        getMessage(): string;
        name(): string;
        ordinal(): number;
        compareTo(other: any): number;
    }
}
declare class ExtendedStayData {
    cartItemExtendedFrom: number;
    cartItemExtendedTo: number;
    constructor();
}
declare class TempUserDTO {
    username: string;
    password: string;
    id: number;
    progressId: number;
    passwordLength: number;
    personId: number;
    constructor();
}
declare class Person {
    constructor();
    firstName: string;
    lastName: string;
    username: string;
    email: string;
    personId: number;
    tempUserId: number;
    changeable: boolean;
    firstNameLocked: boolean;
    lastNameLocked: boolean;
}
declare class ProgressStateReadJson {
    linkedStudents: Array<number>;
    constructor();
}
declare class SankeyNodeDto {
    id: number;
    name: string;
    constructor(name?: any);
}
declare class EnrolledClassSessionDto {
    enrollment: Enrollment;
    classSession: KtbyteClassSession;
    constructor();
}
declare class FreeTrialClassRecsDto {
    id: number;
    classTypeName: string;
    classSessionSets: Array<ClassSessionSetDto>;
    constructor();
}
declare class ReplicationAction {
    master_id: string;
    type: string;
    rowId: number;
    master_timems: number;
    dataAsJson: string;
    className: string;
    constructor();
}
declare class ClassroomEventDto {
    csltId: number;
    event: string;
    eventValue: string;
    timestampEpoch: number;
    server: string;
    constructor(csltId?: any, event?: any, eventValue?: any, timestampEpoch?: any);
}
declare enum EnumeratedTechTestStep {
    WEBSOCKET = 0,
    BANDWIDTH = 1,
    JS_BENCHMARK = 2,
    AUDIO = 3,
    WEBCAM = 4,
    MIC = 5,
    SCREEN_RESOLUTION = 6,
    ANNEX = 7
}
/** @ignore */
declare class EnumeratedTechTestStep_$WRAPPER {
    protected _$ordinal: number;
    protected _$name: string;
    value: any;
    constructor(_$ordinal: number, _$name: string, value: any);
    getValue(): string;
    name(): string;
    ordinal(): number;
    compareTo(other: any): number;
}
interface Abortable {
    canAbort(): boolean;
    abort(): any;
}
declare class UserTechTestResultDto {
    websocket: TechTestStepDto;
    bandwidth: TechTestStepDto;
    jsBenchmark: TechTestStepDto;
    audio: TechTestStepDto;
    webcam: TechTestStepDto;
    mic: TechTestStepDto;
    screenResolution: TechTestStepDto;
    annex: TechTestStepDto;
    constructor();
}
declare class StudentReferralDataDto {
    childUser: KtbyteEarthUser;
    enumReferralPaymentReceiver: string;
    activeClasses: Array<EnrolledClassSessionDto>;
    inactiveClasses: Array<EnrolledClassSessionDto>;
    selfStudyClasses: Array<EnrolledClassSessionDto>;
    freeTrial: FreeTrialDTO;
    constructor(childUser: KtbyteEarthUser);
    addEnrolledClassSession(enrolledClassSession: EnrolledClassSessionDto): void;
}
declare class ClassSessionStaffingTaskDTO {
    classSessionId: number;
    sessionSerialized: string;
    classSize: number;
    problems: Array<string>;
    constructor();
}
declare class TofuTaskDTO {
    static ADDED: string;
    static SCHEDULING_TRIAL: string;
    static REACH_OUT_IN_2020: string;
    static TRIAL_SCHEDULED: string;
    static TRIAL_RESCHEDULE_REQUIRED: string;
    static TRIAL_RECOMMENDATION_SENT: string;
    static TOO_YOUNG: string;
    static REACH_OUT: string;
    static REACHED_OUT: string;
    static ENROLLED: string;
    static NOENROLL: string;
    static AUDITING: string;
    static steps: string[];
    static steps_$LI$(): string[];
    latestMessageViewedByAgentIds: Array<number>;
    lastMessageTimeSeconds: number;
    constructor();
}
declare class TaskWorklogDTO {
    id: number;
    taskId: number;
    creatorPersonId: number;
    comment: string;
    createdTime: number;
    constructor();
}
declare class OpsTrialTaskAssignmentDTO {
    id: number;
    startTimeEpoch: number;
    opsPersonIds: Array<number>;
    timeSlotId: number;
    constructor();
}
declare class DoTechTestTaskDTO {
    studentId: number;
    studentName: string;
    classSessionId: number;
    sessionSerialized: string;
    techType: string;
    firstClassTime: number;
    isChina: boolean;
    constructor();
}
declare namespace DoTechTestTaskDTO {
    enum Step {
        OVER_TWO_WEEKS_BEFORE_CLASS = 0,
        TWO_WEEKS_BEFORE_CLASS = 1,
        TWO_WEEKS_BEFORE_CLASS_EMAIL_SENT = 2,
        TWO_WEEKS_BEFORE_CLASS_EMAIL_AND_TEXT_SENT = 3,
        ONE_WEEK_BEFORE_CLASS = 4,
        ONE_WEEK_BEFORE_CLASS_EMAIL_SENT = 5,
        ONE_WEEK_BEFORE_CLASS_EMAIL_AND_TEXT_SENT = 6,
        THREE_DAY_BEFORE_CLASS = 7,
        THREE_DAY_BEFORE_CLASS_EMAIL_SENT = 8,
        THREE_DAY_BEFORE_CLASS_EMAIL_AND_TEXT_SENT = 9,
        THREE_DAY_BEFORE_CLASS_CALL_PLACED = 10,
        TECH_FAILED_IN_CLASS = 11,
        DONE = 12
    }
}
declare class FireTaskDto {
    fireId: string;
    fireType: string;
    fireReasons: Array<string>;
    workLog: Array<FireTaskDto.WorkLog>;
    taskId: number;
    reporterPersonId: number;
    reporterFirstName: string;
    reporterLastName: string;
    reporterUsername: string;
    studentPersonId: number;
    studentFirstName: string;
    studentLastName: string;
    studentUsername: string;
    studentEmail: string;
    studentPhoneNumbers: Array<string>;
    parentFullNames: Array<string>;
    parentEmails: Array<string>;
    parentPhoneNumbers: Array<string>;
    classroomInfo: ClassroomInfoDto;
    isLoaded: boolean;
    constructor();
    addWorkLog(comment: string, agentId: number, agentFirstName: string, agentLastName: string): void;
}
declare namespace FireTaskDto {
    class WorkLog {
        __parent: any;
        comment: string;
        firePersonId: number;
        firePersonFirstName: string;
        firePersonLastName: string;
        timeStamp: number;
        constructor(__parent: any);
    }
}
declare class HomeworkReminderTaskDTO {
    psetId: number;
    numAttemptedProblems: number;
    numProblems: number;
    emailRequestId: string;
    dueDateMillisecond: number;
    nextLessonTimeId: number;
    static STEP_NOT_SENT: string;
    static STEP_PENDING: string;
    static STEP_SENT: string;
    constructor();
}
declare class TechTestTaskDTO {
    studentName: string;
    isChina: boolean;
    testResult: UserTechTestResultDto;
    constructor();
}
declare class TaskQuery {
    createdByPersonIds: Array<number>;
    classSimpleNames: Array<string>;
    states: Array<TaskState>;
    steps: Array<string>;
    assignedToPersonIds: Array<number>;
    classSessionIds: Array<number>;
    classSessionLessonTimeIds: Array<number>;
    targetPersonId: Array<number>;
    deadlineEpochSeconds: number;
    atMostOnePerField: boolean;
    withPersonIds(...personIds: number[]): TaskQuery;
    withClassSimpleNames(...classSimpleNames: string[]): TaskQuery;
    withStates(...states: TaskState[]): TaskQuery;
    withSteps(...steps: string[]): TaskQuery;
    withAssignedToPersonIds(...assignedToPersonIds: number[]): TaskQuery;
    withClassSessionIds(...classSessionIds: number[]): TaskQuery;
    withClassSessionLessonTimeIds(...classSessionLessonTimeIds: number[]): TaskQuery;
    withTargetPersonId(...targetPersonId: number[]): TaskQuery;
    withDeadlineBefore(deadlineEpochSeconds: number): TaskQuery;
    buildQuery(): TaskQuery.ActiveJDBCInputs;
    toTrackingTask(): TrackingTask;
    static join(values: Array<any>, delimiter: string): string;
    constructor();
}
declare namespace TaskQuery {
    class ActiveJDBCInputs {
        query: string;
        params: any[];
        constructor();
    }
}
declare class ClassRecommendationTaskDto {
}
declare class KtbytePset {
    id: number;
    number: number;
    title: string;
    psetType: string;
    constructor();
}
declare class SendWelcomeEmailTaskDTO {
    studentId: number;
    studentName: string;
    sessionSerialized: string;
    classSessionId: number;
    emailRequestId: string;
    emailStatus: string;
    isChina: boolean;
    static STEP_NOT_SENT: string;
    static STEP_PENDING: string;
    static STEP_SENT: string;
    constructor();
}
declare class CreateVMTaskDTO {
    studentId: number;
    studentName: string;
    isChina: boolean;
    constructor();
}
declare class CalendarItemsBatch {
    lessonTimes: Array<KtbyteClassSessionLessonTimeWithExtraInfo>;
    trialTimeSlots: Array<FreeTrialTimeSlotDto>;
    appointments: Array<AppointmentDto>;
    constructor();
}
/**
 * OPEN -> IN_PROGRESS -> ESCALATED         -> CLOSED or IN_PROGRESS or OPEN
 * RESOLVED_BY_AGENT
 * @enum
 * @property {TaskState} OPEN
 * @property {TaskState} IN_PROGRESS
 * @property {TaskState} ESCALATED
 * @property {TaskState} RESOLVED_BY_AGENT
 * @property {TaskState} CLOSED
 * @property {TaskState} STALE
 * @class
 */
declare enum TaskState {
    OPEN = 0,
    IN_PROGRESS = 1,
    ESCALATED = 2,
    RESOLVED_BY_AGENT = 3,
    CLOSED = 4,
    STALE = 5
}
/** @ignore */
declare class TaskState_$WRAPPER {
    protected _$ordinal: number;
    protected _$name: string;
    constructor(_$ordinal: number, _$name: string);
    static getNonClosedStates(): TaskState[];
    static getNonStaleStates(): TaskState[];
    name(): string;
    ordinal(): number;
    compareTo(other: any): number;
}
declare class ClassSessionAndLessonTimesAndUsers {
    classSessions: Array<KtbyteClassSession>;
    users: Array<KtbyteEarthUser>;
    lessonTimes: Array<KtbyteClassSessionLessonTime>;
    constructor();
}
declare class KtbyteCrmParentInfo {
    firstname: string;
    lastname: string;
    parentemails: string;
    constructor();
}
declare class ProjectCommentsResponse {
    comments: Array<ProjectCommentResponse>;
    constructor(comments: Array<ProjectCommentResponse>);
}
declare class StudentClassSessionDetailsDto {
    sessionSerialized: string;
    sessionId: number;
    instructors: Array<KtbyteEarthUser>;
    students: Array<StudentClassSessionDetailsDto.StudentGradeDto>;
    averages: Array<PsetInfo>;
    constructor(sessionSerialized: string, sessionId: number, instructors: Array<KtbyteEarthUser>, students: Array<StudentClassSessionDetailsDto.StudentGradeDto>, averages: Array<PsetInfo>);
}
declare namespace StudentClassSessionDetailsDto {
    class StudentGradeDto {
        studentId: number;
        firstName: string;
        lastName: string;
        username: string;
        secretHash: string;
        grades: any;
        constructor(studentId: number, firstName: string, lastName: string, username: string, secretHash: string, grades: any);
    }
}
declare class EmailRequestInfo {
    templateId: number;
    classSessionId: number;
    customTwigVariables: any;
    studentsToAddresses: any;
    studentsToSentStatus: any;
    constructor();
}
declare enum EnumeratedEmailPriority {
    NONE = 0,
    VERYLOW = 1,
    LOW = 2,
    MEDIUM = 3,
    HIGH = 4,
    VERYHIGH = 5,
    ASAP = 6
}
/** @ignore */
declare class EnumeratedEmailPriority_$WRAPPER {
    protected _$ordinal: number;
    protected _$name: string;
    priorityAsInt: any;
    constructor(_$ordinal: number, _$name: string, priorityAsInt: any);
    getPriorityAsInt(): number;
    static fromPriorityAsInt(priority: any): EnumeratedEmailPriority;
    name(): string;
    ordinal(): number;
    compareTo(other: any): number;
}
declare class EmailSubjectAndBody {
    subject: string;
    body: string;
    constructor(subject: string, body: string);
}
declare enum EnumeratedStudentStatusCategory {
    FREETRIAL = 0,
    REGISTRATION = 1,
    ENROLLMENT = 2
}
declare class PIdPair {
    psetId: number;
    problemNumber: number;
    constructor(psetId: number, problemNumber: number);
    equals(o: any): boolean;
    hashCode(): number;
}
declare class SankeyStatsDto {
    nodes: Array<SankeyNodeDto>;
    links: Array<SankeyLinkDto>;
    constructor();
    addNode(node: SankeyNodeDto): void;
    addNodes(...nodes: SankeyNodeDto[]): void;
    addLink(link: SankeyLinkDto): void;
    addLinks(...links: SankeyLinkDto[]): void;
}
declare class ErrorReportDto {
    id: number;
    language: string;
    message: string;
    route: string;
    filename: string;
    line: number;
    column: number;
    username: string;
    timestampInSecs: number;
    constructor();
}
declare class UserSignUpInfoDto {
    firstName: string;
    lastName: string;
    email: string;
    phoneNumber: string;
    acceptText: boolean;
    acceptCall: boolean;
    constructor();
}
declare class UserFollowerDto {
    following_id: number;
    constructor(following_id: number);
}
declare class CsltDto {
    id: number;
    classSessionId: number;
    lessonNumber: number;
    lessonTimeEpoch: number;
    lessonDurationMinutes: number;
    title: string;
    description: string;
    constructor(id?: any, classSessionId?: any, lessonNumber?: any, lessonTimeEpoch?: any, lessonDurationMinutes?: any, title?: any, description?: any);
}
declare class UserFollowersResponse {
    followers: Array<UserFollowerResponse>;
    constructor(followers: Array<UserFollowerResponse>);
}
declare class StudentGradeSummary {
    student: KtbyteEarthUser;
    homeworkGrade: number;
    lectureGrade: number;
    quizGrade: number;
    isChina: boolean;
    constructor(student: KtbyteEarthUser, homeworkGrade: number, lectureGrade: number, quizGrade: number, isChina: boolean);
}
declare class CoderBetaSaveResponse {
    result: string;
    constructor(result: string);
}
declare class TrackingTask {
    simpleTaskName: string;
    id: number;
    searchKeyPrimary: number;
    searchKeySecondary: number;
    dataJson: string;
    deadlineEpoch: number;
    priority: number;
    state: TaskState;
    step: string;
    createdByPersonId: number;
    targetPersonId: number;
    createdByPersonFirstName: string;
    createdByPersonLastName: string;
    createTime: number;
    updateTime: number;
    assignedToPersonId: number;
    assignedToPersonFirstName: string;
    assignedToPersonLastName: string;
    classSessionId: number;
    classSessionLessonTimeId: number;
    classSessionSerialized: string;
    notified: boolean;
    worklog: Array<TaskWorklogDTO>;
    subTaskIds: Array<number>;
    constructor();
    groupHash(): number;
    hashCode(): number;
    equals(o: any): boolean;
}
declare class FamilyDTO {
    parent: PersonSummaryDTO;
    students: Array<PersonSummaryDTO>;
    constructor(parent: PersonSummaryDTO, students: Array<PersonSummaryDTO>);
}
declare class CsltUserEventDto {
    userPersonId: number;
    csltId: number;
    event: string;
    timestampEpoch: number;
    constructor(userPersonId?: any, csltId?: any, event?: any, timestampEpoch?: any);
}
declare class DesktopConfig {
    cpuLimit: string;
    memLimit: string;
    syncSizeMb: number;
    region: string;
    constructor(cpuLimit: string, memLimit: string, syncSizeMb: number, region: string);
    getCpuLimit(): string;
    setCpuLimit(cpuLimit: string): void;
    getMemLimit(): string;
    setMemLimit(memLimit: string): void;
    getSyncSizeMb(): number;
    setSyncSizeMb(syncSizeMb: number): void;
    getRegion(): string;
    setRegion(region: string): void;
}
declare class ReplicationStatusResponseDTO {
    hashes: any;
    tableRows: any;
    tableTypes: any;
    constructor();
}
declare class SubmitFreeTrialFollowUpDto {
    constructor();
    taskId: number;
    classLevelRec: string;
    freeTrialId: number;
    recommendation: Array<string>;
    incompleteTrialNote: string;
    publicNote: string;
    wpm: number;
    freeTrialCompleted: boolean;
    parentStudentGoals: string[];
    tags: string[];
    tofuTags: Array<TofuTagDTO>;
    sanitizedRecommendations: string[];
    isFeedbackCompleted: boolean;
    metrics: Array<FreeTrialFeedbackMetricScoreDto>;
}
declare class ProblemDTO {
    problemNumber: number;
    problemId: number;
    title: string;
    points: number;
    mode: string;
    starterCode: string;
    solutionCode: string;
    problemText: string;
    browserVerificationCode: string;
    problemGrades: Array<ProblemGrade>;
    constructor();
}
declare class ClassSessionGradeGroupDTO {
    problems: Array<ProblemDTO>;
    gradeStatuses: Array<StudentGradeStatus>;
    classSessionId: number;
    sessionSerialized: string;
    psetTitle: string;
    psetId: number;
    intendedAssignment: ClassSessionIntendedAssignmentDto;
    constructor();
}
declare class ProblemGrade {
    studentId: number;
    pointsDeducted: number;
    studentAnswer: string;
    studentJavaBlocks: string;
    gradingNotes: string;
    lastModified: string;
    constructor();
}
/**
 * Represents the grading notes/points of a student's psetanswer from a teacher / staff member
 * @class
 */
declare class StudentGradeInput {
    studentId: number;
    psetId: number;
    problemId: number;
    problemNumber: number;
    pointsOff: number;
    gradingNotes: string;
    constructor();
}
declare class StudentGradeStatus {
    studentId: number;
    psetId: number;
    classSessionId: number;
    assignmentId: number;
    fullName: string;
    username: string;
    gradeString: string;
    status: number;
    constructor();
}
/**
 * Represents the current state of the Earth DB on a server
 * It pulled by a slave to get rows needed for synchronization
 *
 * Per table:
 * The maximum timestamp associated with any row.
 * (This is used to determine whether to give any rows to slave)
 * For any row, if the master time stamp is past the slave_timems on the slave server, then slave needs it.
 * The maximum timestamp associated with rows matching the master_id of the call-ee
 * (This is used to determine whether to give any rows in lazy mode)
 *
 * @author user
 * @class
 */
declare class ReplicationTableData {
    replicationId: string;
    max_master_timems: number;
    max_master_matching_timems: number;
    actionsForAllMissing: Array<ReplicationAction>;
    actionsForMatchingMissing: Array<ReplicationAction>;
    constructor();
}
declare enum Role {
    ROLE_ADMIN = 0,
    ROLE_DEV = 1,
    ROLE_AGENT = 2,
    ROLE_TEACHER = 3,
    ROLE_TA = 4,
    ROLE_PARENT = 5,
    ROLE_STUDENT = 6,
    ROLE_PARTNER = 7
}
/** @ignore */
declare class Role_$WRAPPER {
    protected _$ordinal: number;
    protected _$name: string;
    roleString: any;
    constructor(_$ordinal: number, _$name: string, s: any);
    getRoleString(): string;
    name(): string;
    ordinal(): number;
    compareTo(other: any): number;
}
declare class CoderBetaGradedMap {
    results: any;
    constructor(results: any);
}
declare class FreeTrialMCResponse {
    corrects: boolean[];
    isCorrect: boolean;
    constructor(corrects: boolean[], isCorrect: boolean);
}
declare class ReferralDiscountDto {
    referrerFirstName: string;
    referrerLastNameInitial: string;
    isPartner: boolean;
    referralCode: string;
    value: number;
    valueType: string;
    discountString: string;
    constructor();
}
declare class LessonDto {
    classSessionId: number;
    instructors: Array<KtbyteEarthUser>;
    classSessionLessonTime: ClassSessionLessonTimeDto;
    curriculum: KtbyteCurriculum;
    classSessionSerialized: string;
    psets: Array<PsetInfo>;
    dghCount: number;
    dglCount: number;
    nghCount: number;
    nglCount: number;
    dbhCount: number;
    dblCount: number;
    nbhCount: number;
    nblCount: number;
    ghAvg: number;
    glAvg: number;
    bhAvg: number;
    blAvg: number;
    studentCount: number;
    constructor(classSessionId: number, instructors: Array<KtbyteEarthUser>, classSessionLessonTime: ClassSessionLessonTimeDto, curriculum: KtbyteCurriculum, classSessionSerialized: string, psets: Array<PsetInfo>, studentCount: number);
    static count(psets: Array<PsetInfo>, done: boolean, good: boolean, classwork: boolean): number;
    static averageGrade(psets: Array<PsetInfo>, good: boolean, classwork: boolean): number;
}
declare class ClassRecommendationDto {
    classSessionId: number;
    name: string;
    translatedName: string;
    icon: string;
    imageUrl: string;
    detailPageUrl: string;
    description: string;
    descriptionI18n: string;
    shortCode: string;
    shortCodeHuman: string;
    inPerson: boolean;
    constructor();
}
declare class KtbyteClassSessionStudentList {
    classSession: KtbyteClassSession;
    students: Array<PersonEnrollment>;
    constructor(classSession: KtbyteClassSession, students: Array<PersonEnrollment>);
}
declare class KtbyteClassSessionStudent {
    personId: number;
    section: number;
    username: string;
    firstName: string;
    lastName: string;
    email: string;
    secretHash: string;
    lastJoinTimeTimestamp: number;
    region: string;
    ktPoints: number;
    presentInPast2Hours: boolean;
    constructor();
}
declare class KtbyteCurriculum {
    id: number;
    code: string;
    name: string;
    autoAssignPset: boolean;
    hasGradedPsets: boolean;
    constructor();
}
declare class KtbyteLessonTimeInstructor {
    personId: number;
    isMainInstructor: boolean;
    section: number;
    constructor();
}
declare class KtbyteClassSession {
    static humanReadableCategory: string[];
    static humanReadableCategory_$LI$(): string[];
    static numLessonsCategory: number[];
    static numLessonsCategory_$LI$(): number[];
    static CATEGORY_SEMESTER: number;
    static CATEGORY_WEEKLONG: number;
    static CATEGORY_SUMMER_EVENING: number;
    static CATEGORY_HALF_EVENING: number;
    static CATEGORY_HALF_SEMESTER: number;
    static CATEGORY_THIRD_SEMESTER: number;
    static CATEGORY_EIGHT_WEEKS: number;
    static CATEGORY_TEN_DAYS: number;
    static CATEGORY_FOUR_WEEKS: number;
    static CATEGORY_THREE_WEEKS: number;
    static CATEGORY_TWELVE_WEEKS: number;
    static CATEGORY_SEVENTEEN_WEEKS: number;
    static CATEGORY_TWELVE_WEEKS_PLUS_SNOW_DAY: number;
    static CATEGORY_BIWEEKLY: number;
    static CATEGORY_TWELVE_BIWEEKLY: number;
    static TECH_TYPES: string[];
    static TECH_TYPES_$LI$(): string[];
    static HUMAN_FORMATS: string[];
    static HUMAN_FORMATS_$LI$(): string[];
    static SESSIONSERIALIZED_REGEX: string;
    static HUMAN_CATEGORIES: string[];
    static HUMAN_CATEGORIES_$LI$(): string[];
    id: number;
    sessionSetCodeHuman: string;
    sessionSetCode: string;
    sessionSetName: string;
    sessionSetImageLink: string;
    mainInstructorFirstName: string;
    mainInstructorLastName: string;
    description: string;
    sessionSerialized: string;
    perSectionMeetingIds: string;
    time: string;
    calendar: string;
    location: string;
    locationMapLink: string;
    isActive: boolean;
    isSelfStudy: boolean;
    __isInPerson: boolean;
    category: number;
    techType: string;
    numAIsRequired: number;
    assistantInstructorIds: Array<number>;
    hasGradedAssignemts: boolean;
    annexServerId: number;
    mediaServerLabel: string;
    isWeeklong(): boolean;
    isSemester(): boolean;
    isSummerEvening(): boolean;
    isInPerson(): boolean;
    /**
     *
     * @param {*} o
     * @return {boolean}
     */
    equals(o: any): boolean;
    constructor();
}
declare class KtbyteClassSessionLessonTimeWithExtraInfo {
    lessonTime: KtbyteClassSessionLessonTime;
    closed: boolean;
    classSize: number;
    curriculumCode: string;
    curriculumId: number;
    psetsWithMetaData: Array<PsetWithMetadata>;
    constructor();
}
declare class KtbyteClassSessionLessonTime {
    id: number;
    classSessionId: number;
    classSession: string;
    lessonNumber: number;
    lessonTime: number;
    durationMinutes: number;
    notes: string;
    instructors: Array<KtbyteLessonTimeInstructor>;
    workshopStudentIds: number[];
    opsPersonIds: number[];
    constructor();
}
declare class KtbyteCurriculumPset {
    curriculum: KtbyteCurriculum;
    pset: KtbytePset;
    constructor();
}
declare enum OrientationTopic {
    PARENT_ORIENTATION = 0
}
/** @ignore */
declare class OrientationTopic_$WRAPPER {
    protected _$ordinal: number;
    protected _$name: string;
    value: any;
    constructor(_$ordinal: number, _$name: string, value: any);
    getValue(): string;
    name(): string;
    ordinal(): number;
    compareTo(other: any): number;
}
declare class QuestionResponse {
    question: string;
    value: number;
    constructor();
}
declare class PsetsWithProblems {
    psetid: number;
    assignmentId: number;
    title: string;
    gradeString: string;
    psetType: string;
    assignDate: string;
    dueDate: string;
    finalized: boolean;
    weight: number;
    problems: Array<ProfileProblem>;
    assignmentLastMofified: number;
    constructor(psetid?: any, psetType?: any, gradeString?: any, assignDate?: any, title?: any, dueDate?: any, finalized?: any, weight?: any);
    setGradeString(s: string): void;
    setPsetType(s: string): void;
    setAssignDate(s: string): void;
}
declare class ProgressReportDTO {
    psets: Array<PsetsWithProblems>;
    evals: Array<GroupResponse>;
    courseTitle: string;
    dateUpdated: number;
    username: string;
    name: string;
    overallPerformance: string;
    url: string;
    constructor();
}
declare class GroupResponse {
    name: string;
    questions: Array<QuestionResponse>;
    constructor();
}
declare class ProfileProblem {
    status: number;
    problemid: number;
    numberInPset: number;
    pointsAwarded: number;
    psetAnswerId: number;
    pointsWorth: number;
    mode: string;
    psetId: number;
    static ATTEMPTED_UNGRADED: number;
    static FULL_CREDIT: number;
    static PARTIAL_CREDIT: number;
    static UNATTEMPTED: number;
    constructor(numberInPset: number, problemid: number, psetAnswerId: number, pointsAwarded: number, pointsWorth: number, mode: string, psetId: number);
    setProfileProblemStatus(): void;
}
declare class ClassroomsDto {
    classSessionRooms: Array<KtbyteClassSession>;
    indieRooms: Array<ClassroomInfoDto>;
    constructor();
}
interface ProcessingCompilationProblem {
    message: string;
    severity: string;
    row: number;
    column: number;
}
declare class FreeTrialFeedbackMetricScoreDto {
    metricId: number;
    value: number;
    title: string;
    description: string;
    note: string;
    constructor(title?: any, value?: any, note?: any);
}
declare class PersonEnrollment {
    static OTHER_JSON_KEY_PROFILE_VISITED: string;
    crmId: number;
    firstName: string;
    lastName: string;
    isChina: boolean;
    personId: number;
    vmInfo: string;
    enrollment: Enrollment;
    visitedProfile: boolean;
    constructor(crmId: number, firstName: string, lastName: string, isChina: boolean, personId: number, vmInfo: string, visitedProfile: boolean, enrollment: Enrollment);
}
declare class ProcessingLibraryDTO {
    id: number;
    candyName: string;
    humanName: string;
    version: string;
    hidden: boolean;
    isRequired: boolean;
    descriptionHtml: string;
    imageLink: string;
    javadocLink: string;
    constructor(id: number, candyName: string, humanName: string, version: string, hidden: boolean, isRequired: boolean, descriptionHtml: string, imageLink: string, javadocLink: string);
}
declare class UserProjectResponse {
    id: number;
    hits: number;
    heartsCount: number;
    commentsCount: number;
    title: string;
    name: string;
    avatar: string;
    username: string;
    image: string;
    description: string;
    createdAt: string;
    hearted: boolean;
    constructor(id: number, title: string, name: string, avatar: string, username: string, hearted: boolean, heartsCount: number, commentsCount: number, image: string, hits: number, description: string, createdAt: string);
}
declare class AdAttributionDto {
    crmId: number;
    name: string;
    phone: string;
    heardFromTitle: string;
    adId: number;
    createdDateEpochMilli: number;
    constructor();
}
declare class FreeTrialApproveDto {
    publicNote: string;
    recommendation: string;
    constructor();
}
declare namespace wechat {
    class WeChatAPIResponseCode {
        errmsg: string;
        errcode: number;
        ok(): boolean;
        constructor();
    }
}
declare namespace wechat {
    class WeChatUserInfo {
        nickname: string;
        openid: string;
        constructor();
    }
}
declare namespace wechat { }
declare namespace wechat {
    class WechatChatTranscriptList {
        nickname: string;
        openid: string;
        number: number;
        msgid: number;
        recordlist: Array<WechatChatTranscriptList.MessageRecord>;
        constructor();
    }
    namespace WechatChatTranscriptList {
        class MessageRecord {
            __parent: any;
            openid: string;
            opercode: number;
            text: string;
            time: number;
            worker: string;
            fromUs(): boolean;
            constructor(__parent: any);
        }
    }
}
declare class AgentResponseTemplateDto {
    id: number;
    title: string;
    type: string;
    text: string;
    mediaUrl: string;
    constructor();
}
declare class NotesAndMessages {
    notes: Array<NoteDto>;
    weChatMessages: Array<WeChatAPIMessage>;
    weChatyMessages: Array<WeChatyMessage>;
    constructor();
}
declare class WeChatCustomerSearchFilterDto {
    assigneePersonId: number;
    includeWechatSubscribers: boolean;
    pinnedOnly: boolean;
    tag: string;
    excludeTag: string;
    state: string;
    status: string;
    step: string;
    constructor();
}
declare class WeChatyUrlLink {
    description: string;
    thumbnailUrl: string;
    title: string;
    url: string;
    constructor();
}
declare class WeChatyMessage {
    mentionIdList: string[];
    filename: string;
    id: string;
    text: string;
    timestamp: number;
    type: number;
    fromId: string;
    toId: string;
    roomId: string;
    crmChatMessageId: number;
    crmId: number;
    fromUs: boolean;
    binaryDataBase64: string;
    urlLink: WeChatyUrlLink;
    agentUsername: string;
    respondedByAgentId: number;
    static createTextMessage(toId: string, fromId: string, message: string): WeChatyMessage;
    static Text: number;
    static Img: number;
    static Audio: number;
    static Video: number;
    static Url: number;
    static Attach: number;
    static Open: number;
    static Emoji: number;
    static VoiceRemind: number;
    static ScanGood: number;
    static Good: number;
    static Emotion: number;
    static CardTicket: number;
    static RealtimeShareLocation: number;
    static ChatHistory: number;
    static MiniProgram: number;
    static Transfers: number;
    static RedEnvelopes: number;
    static ReaderType: number;
    constructor();
}
declare class WeChatCustomQRCodeResponse {
    ticket: string;
    expire_seconds: number;
    url: string;
    constructor();
}
declare class WeChatCustomerSearchResultEntry {
    customer: WeChatCustomerInfo;
    searchText: string;
    constructor(customer?: any, searchText?: any);
}
declare class WeChatCustomerInfo {
    id: number;
    openId: string;
    nickName: string;
    avatar: string;
    crmId: number;
    encryptedCrmId: string;
    personId: number;
    secretHash: string;
    userName: string;
    childUsers: Array<WeChatCustomerInfo.ChildUser>;
    wechatyId: string;
    wechatyAgentUsernames: Array<string>;
    weChatHintUsername: string;
    signUpTimeEpochSeconds: number;
    geoInfo: string;
    studentFirstName: string;
    studentLastName: string;
    studentAge: number;
    weChatUsername: string;
    parentName: string;
    parentPhone: string;
    parentEmail: string;
    hearFrom: string;
    preferredContactMethod: string;
    taskId: number;
    freeTrialIds: Array<number>;
    lastMessageTimeSeconds: number;
    task: TrackingTask;
    isPinned: boolean;
    isStarred: boolean;
    isChecked: boolean;
    tags: Array<string>;
    tofuTags: Array<TofuTagDTO>;
    adId: number;
    constructor();
}
declare namespace WeChatCustomerInfo {
    class ChildUser {
        __parent: any;
        personId: number;
        firstName: string;
        lastName: string;
        username: string;
        techTestPassed: boolean;
        constructor(__parent: any);
    }
}
declare class WeChatAPIMessage {
    messageType: string;
    customerOpenId: string;
    createTimeSeconds: number;
    fromUs: boolean;
    messageId: number;
    textMessage: string;
    mediaId: string;
    format: string;
    event: string;
    eventKey: string;
    respondedByAgentId: number;
    crmId: number;
    crmChatMessageId: number;
    constructor(customerOpenId: string, createTimeSeconds: number, messageType: string);
}
declare class WeChatyContact {
    avatar: string;
    friend: boolean;
    id: string;
    name: string;
    alias: string;
    constructor();
}
declare class CurrentStudentParent {
    crmId: number;
    parentId: number;
    username: string;
    secretHash: string;
    wechatNickname: string;
    constructor(crmId: number, personId: number, wechatNickname: string);
}
declare class WeChatCustomerSearchResult {
    results: any;
    constructor();
    addCategoryWithResults(category: string, categoryResults: Array<WeChatCustomerSearchResultEntry>): void;
}
declare class FunnelLeadDto {
    parentName: string;
    personId: number;
    crmId: number;
    tofuTags: Array<TofuTagDTO>;
    firstContactTimeEpochSeconds: number;
    signUpTimeEpochSeconds: number;
    freeTrials: Array<FreeTrialDTO>;
    firstEnrollmentSerialized: string;
    subsequentEnrollmentsSerialized: string;
    constructor();
}
declare class TofuTagDTO {
    id: number;
    tag: string;
    points: number;
    description: string;
    tagType: string;
    static RESPONSIVE: string;
    static GOOD_LEAD: string;
    static BAD_LEAD: string;
    static REPLY_SOON: string;
    static FREE_TRIAL_FEEDBACK_5: string;
    static FREE_TRIAL_FEEDBACK_3_OR_4: string;
    static FREE_TRIAL_FEEDBACK_1_OR_2: string;
    static RESPONSES_AFTER_TRIAL_FEEDBACK_0: string;
    static RESPONSES_AFTER_TRIAL_FEEDBACK_1: string;
    static RESPONSES_AFTER_TRIAL_FEEDBACK_2: string;
    static RESPONSES_AFTER_TRIAL_FEEDBACK_3: string;
    static RESPONSES_AFTER_TRIAL_FEEDBACK_4: string;
    static RESPONSES_AFTER_TRIAL_FEEDBACK_5_PLUS: string;
    static TRIAL_FEEDBACK_TAGS: Array<string>;
    static TRIAL_FEEDBACK_TAGS_$LI$(): Array<string>;
    static RESPONSES_AFTER_TRIAL_FEEDBACK_TAGS: Array<string>;
    static RESPONSES_AFTER_TRIAL_FEEDBACK_TAGS_$LI$(): Array<string>;
    constructor();
}
declare class HeardFromSourceDto {
    id: number;
    title: string;
    type: string;
    assocatedTimeEpoch: number;
    constructor();
}
declare class ReferrerAggregateShareStatsDto {
    referrerPersonId: number;
    totalShares: number;
    totalFulfilledShares: number;
    singleTypeShareStats: any;
    constructor(referrerPersonId: number);
    addSingleTypeShareStat(shareType: EnumReferralShareType, isFulfilled: boolean): void;
    incrementShareCount(dto: ReferrerSingleTypeShareStatsDto, isFulfilled: boolean): ReferrerSingleTypeShareStatsDto;
}
declare class UserActionLogDto {
    id: number;
    personId: number;
    personName: string;
    actionId: number;
    actionTitle: string;
    timestamp: number;
    constructor();
}
declare class WeeklongSessionInfo {
    humanDates: string;
    humanSeason: string;
    iconclass: string;
    sessionSerialized: string;
    constructor();
}
declare class FreeTrialMinDto {
    id: number;
    startTimeEpoch: number;
    studentPersonId: number;
    isCompleted: boolean;
    isCancelled: boolean;
    isEnrolled: boolean;
    constructor();
    getStartTimeEpoch(): number;
}
declare class ClassroomEventsDto {
    csltId: number;
    events: any;
    constructor(csltId?: any, events?: any);
    addEvent(eventDto: ClassroomEventDto): void;
}
declare class CoderBetaFileReturn {
    body: string;
    javablockData: string;
    title: string;
    desc: string;
    problemid: number;
    problemnumber: number;
    singleproblemid: number;
    psetid: number;
    types: string[];
    numbers: number[];
    problemids: number[];
    textrecording: string;
    grademeta: boolean;
    grade_points: string;
    grade_sub_time: string;
    grade_notes: string;
    grade_correct: string;
    default_solution: string;
    mode: string;
    locked: boolean;
    browser_verification_code: string;
    constructor(body: string, javablockData: string, title: string, desc: string, problemid: number, problemnumber: number, singleproblemid: number, psetid: number, types: string[], numbers: number[], problemids: number[], textrecording: string, default_solution: string, mode: string, locked: boolean, browserVerificationCode: string);
    setGradeMeta(points: string, sub_time: string, notes: string, correct: string): void;
}
declare class ClassSessionTeacherDto {
    classSessionId: number;
    teacherPersonId: number;
    isAssistantInstructor: boolean;
    isMainInstructor: boolean;
    section: number;
    constructor();
}
/**
 * Chi Bong 2020-06-26: This is an older style DTO, use ClassSessionDto, which
 * encapsulates fields only in the Class Session Model, unless you really need
 * to use the others defined here.
 * @class
 */
declare class ClassSessionDTO {
    id: number;
    sessionId: number;
    sessionSerialized: string;
    shortCode: string;
    shortCodeHuman: string;
    humanReadable: string;
    sessionSetImageLink: string;
    category: string;
    duration: string;
    calendar: string;
    time: string;
    price: string;
    location: string;
    techType: string;
    paymenttype: number;
    studentPersonIds: Array<number>;
    teachers: Array<ClassSessionTeacherDto>;
    constructor();
}
declare class CoderTechTestResult {
    result: string;
    passedSteps: number[];
    getNumPassedSteps(): number;
    constructor();
}
declare class CoderBetaProjectSaveRequest {
    constructor(projectDTO: CoderBetaProjectDTO, hasMeta: boolean, hasCode: boolean);
    hasMeta: boolean;
    hasCode: boolean;
    projectDTO: CoderBetaProjectDTO;
}
declare abstract class FreeTrialProblem {
    static TYPE_SHORTANSWER: string;
    static TYPE_CHECKBOX: string;
    static TYPE_RADIO: string;
    static TYPE_TYPINGTEST: string;
    static TYPE_FORM: string;
    static TYPE_CALENDAR: string;
    id: number;
    type: string;
    title: string;
    problemdeclaration: string;
    constructor();
}
declare class ShowcaseBetaProjectOverviewResponse {
    responses: Array<CoderBetaShowcaseProjectResponse>;
    pageCount: number;
    constructor(responses: Array<CoderBetaShowcaseProjectResponse>, pageCount: number);
}
declare class EventJson {
}
declare class GeoInfoDto {
    id: number;
    city: string;
    state: string;
    country: string;
    crmId: number;
    urlEncodedEncryptedCrmId: string;
    epochClicked: number;
    countryIso: string;
    ip: string;
    postal: string;
    continent: string;
    isp: string;
    constructor();
}
declare class ClassRecommendationModelDto {
    id: number;
    studentId: number;
    classSessionId: number;
    finalFeedback: string;
    recommendedClassSessionSetIds: Array<number>;
    opsApproved: boolean;
    emailSentTimeEpochMS: number;
    constructor();
}
declare class EventDto {
    id: number;
    crmId: number;
    eventType: string;
    timeStampEpochMillis: number;
    appliedFrom: string;
    appliedByAgentId: number;
    dataJsonObj: EventJson;
    dataJsonStr: string;
    constructor();
}
declare class NoteDto {
    id: number;
    crmId: number;
    note: string;
    timeStampEpochMillis: number;
    appliedFrom: string;
    appliedByAgentId: number;
    constructor();
}
declare class GetListResponseDto<T> {
    data: Array<T>;
    total: number;
    constructor(data?: any, total?: any);
}
declare class TaskData {
    id: number;
    taskTypeId: number;
    priority: number;
    state: string;
    personId: number;
    username: string;
    firstName: string;
    lastName: string;
    personEmail: string;
    email: string;
    staffId: number;
    assignedToPersonId: number;
    ta_id: number;
    classSessionId: number;
    description: string;
    classSessionLessonTimeId: number;
    classSessionSerialized: string;
    classSessionLessonTimeIds: Array<number>;
    classSessionsSerialized: Array<string>;
    taSection: number;
    startTime: number;
    endTime: number;
    deadlineEpoch: number;
    staffingId: number;
    attendance: string;
    participation: string;
    oh: boolean;
    comment: string;
    emailSent: boolean;
    constructor();
}
declare class CsltUserEventsDto {
    csltId: number;
    studentUserEventsDtos: Array<CsltSingleUserEventsDto>;
    teacherUserEventsDtos: Array<CsltSingleUserEventsDto>;
    constructor(csltId: number, studentUserEventsDtos: Array<CsltSingleUserEventsDto>, teacherUserEventsDtos: Array<CsltSingleUserEventsDto>);
}
declare class CheckoutBatch {
    cartItems: Array<CartItemDTO>;
    checkoutPriceData: CheckoutPriceData;
    classSessions: any;
    defaultCoupon: string;
    defaultReferralCode: string;
    roles: string[];
    newStudents: boolean;
    constructor();
}
/**
 * Represents the pricing data shown in the checkout page.
 * !!!!Note that is coupon is invalid, not all fields will be filled properly!!!!
 *
 * subtotal refers to the total price of all items in cart before any type of coupon/credit/discount
 *
 * The order of operations for coupon/credit/discount is as follows:
 * 1. the coupon discount (as a percentage off) is applied
 * 2. the sibling discount is applied (as a percentage off second item onwards)
 * 3. credit, if any, is applied
 * - At this point, this is the price when paying not by check/cash
 * 4. cash and check discount is appied
 * - At this point, this is the price when paying by check/cash
 * @class
 */
declare class CheckoutPriceData {
    subtotal: number;
    total: number;
    totalWithCashCheckDiscount: number;
    cartItemDtosWithPriceData: Array<CartItemDTO>;
    discountString: string;
    appliedReferralDiscountDto: ReferralDiscountDto;
    dollarsOffPerReferredStudent: number;
    dollarsOffFromCoupon: number;
    dollarsOffFromReferral: number;
    dollarsOffFromReferredStudents: number;
    dollarsOffFromReturning: number;
    siblingDiscount: number;
    cashCheckDiscount: number;
    usedCredit: number;
    creditToGrantAfterPayment: number;
    appliedDiscountCode: string;
    submittedDiscountCode: string;
    alertMessage: string;
    constructor();
}
declare class CartItemDTO {
    parentId: number;
    id: number;
    sessionHash: string;
    type: string;
    childInfo: ChildBase;
    fee: number;
    appliedCouponCode: string;
    appliedReferralCode: string;
    dollarsOffFromCoupon: number;
    dollarsOffFromReferral: number;
    dollarsOffFromReturning: number;
    siblingDiscount: number;
    creditApplied: number;
    creditUsed: number;
    cashCheckDiscount: number;
    feeAfterDiscounts: number;
    classSession: ClassSessionDTO;
    trialStartDateTimeInStudentTimezone: string;
    constructor();
}
declare class DiscountDTO {
    constructor(discount: number, message2: string);
    amount: number;
    message: string;
}
declare class CurriculumClassesDTO {
    dghCount: number;
    dglCount: number;
    nghCount: number;
    nglCount: number;
    dbhCount: number;
    dblCount: number;
    nbhCount: number;
    nblCount: number;
    ghAvg: number;
    glAvg: number;
    bhAvg: number;
    blAvg: number;
    classsessions: Array<CurriculumClassesDTO.ClassSessionData>;
    constructor();
}
declare namespace CurriculumClassesDTO {
    class ClassSessionData {
        sessionserialized: string;
        type: string;
        number: number;
        graded: boolean;
        grade: number;
        studentLength: number;
        constructor();
    }
}
declare class CouponDto {
    id: number;
    code: string;
    discountString: string;
    value: number;
    valueType: string;
    message: string;
    startingValidEpochMillis: number;
    endingValidEpochMillis: number;
    includedClassSessionIds: Array<number>;
    excludedClassSessionIds: Array<number>;
    includedPersonIds: Array<number>;
    excludedPersonIds: Array<number>;
    includedUserIds: Array<number>;
    excludedUserIds: Array<number>;
    constructor();
}
declare class KtbyteCrmRow {
    personId: number;
    firstname: string;
    lastname: string;
    email: string;
    gender: string;
    age: string;
    schoolinfo: string;
    otherjson: string;
    vminfo: string;
    tags: string;
    note: string;
    enrollments: Array<Enrollment>;
    address: string;
    phone: Array<string>;
    parentrowids: string;
    childrowids: string;
    referralCode: string;
    referralValue: number;
    referralValueType: string;
    typingspeed: number;
    isremoved: boolean;
    status: string;
    statuslabel: string;
    recommendation: string;
    preferredContactLanguage: string;
    crmid: number;
    username: string;
    region: string;
    equals(o: any): boolean;
    constructor();
}
declare class Enrollment {
    static WELCOME_LETTER_NOT_SENT: string;
    static WELCOME_LETTER_SENT: string;
    static TECH_TEST_NOT_DONE: string;
    static TECH_TEST_EXEMPT_VM_GOTOMEETING_US: string;
    static TECH_TEST_DONE_VM_GOTOMEETING_US: string;
    static TECH_TEST_DONE_VM_ZOOM_CN: string;
    static TECH_TEST_STATES: string[];
    static TECH_TEST_STATES_$LI$(): string[];
    static NO_CERTIFICATE: string;
    static HOLD_CERTIFICATE: string;
    static YES_CERTIFICATE: string;
    static HONORS_CERTIFICATE: string;
    static BAD_PERFORMANCE: string;
    static OK_PERFORMANCE: string;
    static GOOD_PERFORMANCE: string;
    session_serialized: string;
    payment_status: EnumeratedPaymentStatus;
    payment_amount: number;
    coupon: string;
    payment_notes: string;
    enrolled: boolean;
    tech_test_status: string;
    welcome_letter_status: string;
    final_performance: string;
    performance: string;
    order_data: CheckoutPriceData;
    userCreditId: number;
    constructor();
}
declare class CoderBetaProjectFileUploadResponse {
    hasError: boolean;
    error: string;
    constructor(hasError: boolean, error: string);
}
declare class StudentClassRecommendationDto {
    studentId: number;
    description: string;
    shortCode: string;
    shortHumanCode: string;
    humanName: string;
    humanPrice: string;
    timeString: string;
    ageRecommendation: string;
    link: string;
    lessons: string;
    duration: string;
    constructor();
}
declare enum PaymentType {
    CREDIT_CARD = 0,
    WECHAT = 1,
    ALIPAY = 2
}
/** @ignore */
declare class PaymentType_$WRAPPER {
    protected _$ordinal: number;
    protected _$name: string;
    static __static_initialized: boolean;
    static __static_initialize(): void;
    value: any;
    static lookup: any;
    static lookup_$LI$(): any;
    static __static_initializer_0(): void;
    static getFromValue(abbreviation: any): PaymentType;
    constructor(_$ordinal: number, _$name: string, value: any);
    getValue(): string;
    name(): string;
    ordinal(): number;
    compareTo(other: any): number;
}
declare class ReplicationStatusRequestDTO {
    rowsToFetch: Array<ReplicationBucketDTO>;
    hashes: any;
    getTableTypes: boolean;
    constructor();
}
declare class PersonCreditDto {
    id: number;
    userId: number;
    personId: number;
    personName: string;
    status: string;
    type: string;
    discountString: string;
    total: number;
    isAddition: boolean;
    createdTimeEpoch: number;
    note: string;
    byPersonId: number;
    constructor();
}
declare namespace PersonCreditDto {
    enum Status {
        PENDING = 0,
        APPROVED = 1,
        CANCELLED = 2
    }
    enum Type {
        REFERRAL = 0,
        CHECKOUT = 1,
        DIRECT_DEPOSIT = 2,
        OTHER = 3
    }
}
declare class FreeTrialDTO {
    id: number;
    studentPersonId: number;
    parentPersonId: number;
    parentCrmId: number;
    opsPersonIds: Array<number>;
    opsPersonNames: Array<string>;
    hasTofuLead: boolean;
    weChatHintUsername: string;
    startTimeEpoch: number;
    timeSlotId: number;
    shadeRowInFrontEnd: boolean;
    availableTimes: number[];
    originallyDesiredTimeSlotDto: FreeTrialTimeSlotDto;
    originallyDesiredTimeEpochMs: number;
    location: string;
    userGeoSummaryJson: string;
    heardFrom: string;
    teacherConfirmed: boolean;
    studentConfirmed: boolean;
    rescheduleRequested: boolean;
    twoDayReminderSent: boolean;
    sameDayReminderSent: boolean;
    confirmationRemindersSent: boolean;
    isScheduled: boolean;
    isCompleted: boolean;
    isCancelled: boolean;
    studentName: string;
    studentFirstName: string;
    studentLastName: string;
    studentUsername: string;
    studentSecretHash: string;
    studentAge: number;
    studentTimezone: string;
    studentEmail: string;
    experience: string;
    techTestPassed: string;
    totalTechTestComputers: number;
    assignedTeacherId: number;
    assignedTeacherName: string;
    teacherFirstName: string;
    teacherLastName: string;
    parentName: string;
    parentFirstName: string;
    parentLastName: string;
    parentPhone: Array<string>;
    parentWechat: string;
    parentEmail: string;
    parentUsername: string;
    classroomId: number;
    teacherTrialLink: string;
    studentTrialLink: string;
    studentAttendance: string;
    instructorAttendance: string;
    teacherCalendarSent: boolean;
    recommendation: string;
    publicNote: string;
    internalNote: string;
    notes: Array<FreeTrialNoteDto>;
    wpm: number;
    parentStudentGoals: string[];
    tags: string[];
    tofuTags: Array<TofuTagDTO>;
    sanitizedRecommendations: string[];
    isFeedbackCompleted: boolean;
    isChina: boolean;
    preferredContactLanguage: string;
    isEnrolled: boolean;
    enrollmentStatus: string;
    nextReachOutTime: number;
    trialLevel: FreeTrialDTO.Level;
    instructorFeedbackCompleted: boolean;
    instructorFeedbackApproved: boolean;
    studentFeedbackRating: number;
    studentFeedbackComment: string;
    task: TrackingTask;
    instructorStillAvailable: boolean;
    constructor();
    equals(o: any): boolean;
}
declare namespace FreeTrialDTO {
    enum Step {
        PICK_AND_CONFIRM_TIME = 0,
        ASSIGN_INSTRUCTOR = 1,
        INSTRUCTOR_CONFIRM = 2,
        FOLLOW_UP = 3,
        APPROVE_REC = 4,
        REACH_OUT = 5
    }
    enum Location {
        IN_PERSON = 0,
        ONLINE = 1
    }
    enum EnrollmentStatus {
        TOO_YOUNG = 0,
        REACH_OUT = 1,
        REACHED_OUT = 2,
        MIGHT_ENROLL = 3,
        CONVERTED = 4,
        CEASE = 5,
        AUDITING = 6
    }
    enum Level {
        YOUNGEST_BEGINNER = 0,
        YOUNGEST_AVERAGE = 1,
        YOUNGEST_EXPERIENCED = 2,
        YOUNGEST_ADVANCED = 3,
        YOUNGER_BEGINNER = 4,
        YOUNGER_AVERAGE = 5,
        YOUNGER_EXPERIENCED = 6,
        YOUNGER_ADVANCED = 7,
        YOUNG_BEGINNER = 8,
        YOUNG_AVERAGE = 9,
        YOUNG_EXPERIENCED = 10,
        YOUNG_ADVANCED = 11,
        OLDER_BEGINNER = 12,
        OLDER_AVERAGE = 13,
        OLDER_EXPERIENCED = 14,
        OLDER_ADVANCED = 15,
        OLDEST_BEGINNER = 16,
        OLDEST_AVERAGE = 17,
        OLDEST_EXPERIENCED = 18,
        OLDEST_ADVANCED = 19
    }
    /** @ignore */
    class Level_$WRAPPER {
        protected _$ordinal: number;
        protected _$name: string;
        value: any;
        constructor(_$ordinal: number, _$name: string, value: any);
        getValue(): string;
        name(): string;
        ordinal(): number;
        compareTo(other: any): number;
    }
}
declare class ClassroomInfoDto {
    classEnv: string;
    classroomType: string;
    roomId: number;
    onlineClassType: string;
    expectedStudents: Array<KtbyteClassSessionStudent>;
    classSessionId: number;
    csltId: number;
    classSessionLessonTime: KtbyteClassSessionLessonTime;
    sessionSerialized: string;
    trialTimeSlotId: number;
    trialTimeSlotDto: FreeTrialTimeSlotDto;
    annexServerId: number;
    constructor(classEnv?: any, classroomType?: any, onlineClassType?: any, roomId?: any);
    getName(): string;
}
declare class TechTestUserDto {
    userAgentHeader: string;
    isLoggedIn: boolean;
    thisPersonId: number;
    thisPersonFirstName: string;
    thisPersonUsername: string;
    expectedUserPersonId: number;
    expectedUserFirstName: string;
    isParentOfExpectedUser: boolean;
    hasFreeTrial: boolean;
    trialClassroomId: number;
    constructor();
}
declare class ClassTypeDto {
    classType: string;
    humanName: string;
    constructor();
}
declare class CoderBetaProjectDTO {
    studentid: number;
    projectId: number;
    type: string;
    title: string;
    exported: boolean;
    primaryData: string;
    javablockdata: string;
    tagline: string;
    authors: string;
    description: string;
    donationUrl: string;
    commentsCount: number;
    hits: number;
    heartsCount: number;
    hearted: boolean;
    storageKey: string;
    selectedLibraries: string[];
    psetId: number;
    lastModified: number;
    constructor(projectId: number);
    getInstance(project: CoderBetaProjectDTO, hasMeta: boolean, hasCode: boolean): CoderBetaProjectDTO;
}
declare class ReplicationInfo {
    serverName: string;
    infoGroup: any;
    constructor();
}
declare class FreeTrialResponse {
    freeTrialProblem: FreeTrialProblem;
    freeTrialSolution: FreeTrialSolution;
    placement: string;
    constructor();
}
declare class FreeTrialPeriodStatsDto {
    startTime: number;
    endTime: number;
    total: number;
    cancelled: number;
    completed: number;
    conversions: number;
    constructor(startTime: number, endTime: number, total: number, cancelled: number, completed: number, conversions: number);
    addToTotal(): void;
    addToCancelled(): void;
    addToCompleted(): void;
    addToConversions(): void;
}
declare enum EnumReferralShareType {
    LINK = 0,
    QR = 1,
    TEXTLINE = 2,
    TEXT = 3,
    EMAIL = 4,
    FACEBOOK = 5,
    WECHAT = 6
}
/** @ignore */
declare class EnumReferralShareType_$WRAPPER {
    protected _$ordinal: number;
    protected _$name: string;
    value: any;
    constructor(_$ordinal: number, _$name: string, value: any);
    getValue(): string;
    name(): string;
    ordinal(): number;
    compareTo(other: any): number;
}
declare abstract class CoderBetaFile extends CoderBetaNode {
    static FILE_TYPE_PROBLEM: string;
    static FILE_TYPE_PROJECT: string;
    static FILE_TYPE_BLOCKLY_PROJECT: string;
    static FILE_TYPE_PROCESSINGJS_PROJECT: string;
    static FILE_TYPE_HTML_PROJECT: string;
    static FILE_TYPE_VIDEO: string;
    static FILE_TYPE_VM: string;
    file_type: string;
    parentFolderId: string;
    constructor(name: string, fileType: string, parentFolderId: string);
}
declare class CoderBetaFolder extends CoderBetaNode {
    static FOLDER_CURRICULUM: string;
    static FOLDER_PSET: string;
    static FOLDER_TYPE_VIEDOS: string;
    static FOLDER_FILL: string;
    static FOLDER_PSET_CATEGORY: string;
    static FOLDER_TYPE_PSETS: string;
    static FOLDER_TYPE_PROJECTS: string;
    static FOLDER_TYPE_TUTORIALS: string;
    static FOLDER_TYPE_CUSTOM: string;
    static FOLDER_TYPE_VIDEO_CHAPTER: string;
    nodes: Array<CoderBetaNode>;
    loaded: boolean;
    folder_type: string;
    folder_id: string;
    constructor(name: string, folderType: string, folderId: string);
}
declare class FreeTrialMCSolution extends FreeTrialSolution {
    corrects: boolean[];
    isCorrect: boolean;
    constructor(corrects: boolean[], isCorrect: boolean);
}
declare class CalendarPresetDto extends Dto {
    calendar: string;
    humanCategory: string;
    lessonDates: string[];
    constructor();
}
declare class OrientationDto extends Dto {
    personId: number;
    topic: OrientationTopic;
    isVisited: boolean;
    isComplete: boolean;
    numEmailSent: number;
    lastEmailSentTimeSeconds: number;
    isLoginInfoEmailSent: boolean;
    personName: string;
    getId(): number;
    constructor();
}
declare class EnrollmentJson extends ProgressStateWriteJson {
    children: Array<EnrollmentChild>;
    classSessions: any;
    groupInperson: boolean;
    toBeChanged: boolean;
    constructor();
}
declare class AccountChooseJson extends ProgressStateWriteJson {
    allowChooseChild: boolean;
    choice: string;
    constructor();
}
declare class AccountSingleChildJson extends ProgressStateWriteJson {
    child: ChildBase;
    tempUser: TempUserDTO;
    fillFromKtbyteCrmRow(row: KtbyteCrmRow): void;
    constructor();
}
declare class AccountParentJson extends ProgressStateWriteJson {
    parent: Parent;
    secondParent: Parent;
    askForSecondParent: boolean;
    askForAddress: boolean;
    tempUser: TempUserDTO;
    fillFromKtbyteCrmRow(row: KtbyteCrmRow): void;
    constructor();
}
declare class FreeTrialJson extends ProgressStateWriteJson {
    children: Array<FreeTrialChild>;
    hearFrom: string;
    tofucrmid: number;
    constructor();
}
declare class AccountChildrenJson extends ProgressStateWriteJson {
    children: Array<ChildBase>;
    childrenTempUsers: Array<TempUserDTO>;
    fromFTorENR: boolean;
    constructor();
}
declare class ChildBase extends Person {
    constructor(personId?: any);
    changedUsernameAndPassword: boolean;
    isChangingUsernameAndPassword: boolean;
    photoRelease: boolean;
    gender: string;
}
declare class Parent extends Person {
    constructor();
    phonenumber: string;
    address: string;
    city: string;
    state: string;
    wechat: string;
}
declare class TechNoteTaskDTO extends FireTaskDto {
}
declare enum EnumeratedStudentStatus {
    FREETRIAL_REGISTERED = 0,
    FREETRIAL_SCHEDULED = 1,
    FREETRIAL_EMAILED_CONFIRMATION = 2,
    FREETRIAL_TECH_TEST_COMPLETE = 3,
    FREETRIAL_AFFILIATE_PAID = 4,
    FREETRIAL_COMPLETE = 5,
    FREETRIAL_EMAILED_RECOMMENDATION = 6,
    FREETRIAL_FOLLOWED_UP = 7,
    ENROLLMENT_ENROLLED = 8,
    ENROLLMENT_ENROLLED_PAID = 9,
    FREETRIAL_CANCELLED = 10,
    FREETRIAL_MISSED = 11,
    ENROLLMENT_AFFILIATE_PAID = 12
}
/** @ignore */
declare class EnumeratedStudentStatus_$WRAPPER {
    protected _$ordinal: number;
    protected _$name: string;
    category: any;
    label: any;
    step: any;
    constructor(_$ordinal: number, _$name: string, category: any, label: any, step: any);
    getCategory(): EnumeratedStudentStatusCategory;
    getLabel(): string;
    getStep(): number;
    name(): string;
    ordinal(): number;
    compareTo(other: any): number;
}
declare enum EnumTaskType {
    AGENT_TASK_DTO = 0,
    CALL_STUDENT_TO_CONFIRM_FREE_TRIAL_DTO = 1,
    CALL_STUDENT_TO_CONFIRM_MAKEUP_DTO = 2,
    CHECKIN_DTO = 3,
    CHECKOUT_DTO = 4,
    CHECK_IN = 5,
    CHECK_OUT = 6,
    CLASS_SESSION_STAFFING_TASK_DTO = 7,
    CLASS_READINESS = 8,
    CONFIRM_HOURS_DTO = 9,
    CONFIRM_HOURS_OP_DTO = 10,
    CONFIRM_MAKEUP_TEACHER_DTO = 11,
    CONFIRM_EVALUATIONS = 12,
    CONFIRM_REMINDERS = 13,
    CONVERT_CURRENT_STUDENT_TASK_DTO = 14,
    CREATE_VM_TASK_DTO = 15,
    DO_TECH_TEST_TASK_DTO = 16,
    FIND_SUB = 17,
    FIRE_TASK_DTO = 18,
    FREE_TRIAL_DTO = 19,
    HOMEWORK_REMINDER_TASK_DTO = 20,
    ONE_DAY_REMINDER_TASK_DTO = 21,
    ONE_DAY_REMINDER = 22,
    OPS_CONFIRM_EVAL = 23,
    OPS_CONFIRM_HOURS = 24,
    REASSIGN_MAKEUP_INSTRUCTOR_DTO = 25,
    RESUBMIT_EVAL = 26,
    SCHEDULE_MAKEUP_DTO = 27,
    SEND_WELCOME_EMAIL_TASK_DTO = 28,
    SHIFT_CONFIRM_TASK_DTO = 29,
    STAFFING_DTO = 30,
    STUDENT_FEEDBACK_APPROVAL_CRM_DTO = 31,
    STUDENT_FEEDBACK_SUBMIT_DTO = 32,
    STUDENT_MAKEUP_APPROVAL_DTO = 33,
    SUBMIT_EVAL = 34,
    TA_CONFIRM_HOURS = 35,
    TEACH_CLASS = 36,
    TECH_NOTE_TASK_DTO = 37,
    TECH_TEST_TASK_DTO = 38,
    THREE_DAY_REMINDER_TASK_DTO = 39,
    THREE_DAY_REMINDER = 40,
    TOFU_TASK_DTO = 41,
    OPS_TRIAL_TASK_ASSIGNMENT_DTO = 42,
    PARENT_ORIENTATION_TASK_DTO = 43
}
/** @ignore */
declare class EnumTaskType_$WRAPPER {
    protected _$ordinal: number;
    protected _$name: string;
    id: any;
    static of(value: any): EnumTaskType;
    getId(): string;
    constructor(_$ordinal: number, _$name: string, value: any);
    getValue(): string;
    name(): string;
    ordinal(): number;
    compareTo(other: any): number;
}
declare class FreeTrialMCProblem extends FreeTrialProblem {
    defaultselected: boolean[];
    choices: string[];
    constructor(id: number, title: string, problemdeclaration: string, defaultselected: boolean[], choices: string[], hasmultiplecorrectanswers: boolean);
}
declare class FreeTrialCalendarProblem extends FreeTrialProblem {
    finalDecision: string;
    timesString: string;
    constructor();
}
declare class FreeTrialStandardProblem extends FreeTrialProblem {
    defaultsolution: string;
    constructor(id: number, title: string, problemdeclaration: string, defaultsolution: string, type: string);
}
declare class FreeTrialShortResponseProblem extends FreeTrialProblem {
    constructor(id: number, title: string, problemDeclaration: string);
}
declare class TofuDataChangeEvent extends EventJson {
    changes: Array<TofuDataChangeEvent.ChangedField<any>>;
    isMerge: boolean;
    constructor(isMerge?: any);
    addChangeField<T>(fieldName: string, oldValue: T, newValue: T): void;
    hasChanges(): boolean;
}
declare namespace TofuDataChangeEvent {
    class ChangedField<T> {
        fieldName: string;
        oldValue: T;
        newValue: T;
        constructor(fieldName: string, oldValue: T, newValue: T);
    }
}
declare class FreeTrialStateChangeEvent extends EventJson {
    oldState: FreeTrialDTO.EnrollmentStatus;
    newState: FreeTrialDTO.EnrollmentStatus;
    constructor(oldState: FreeTrialDTO.EnrollmentStatus, newState: FreeTrialDTO.EnrollmentStatus);
}
declare class TagChangeEvent extends EventJson {
    addedTagIds: Array<number>;
    removedTagIds: Array<number>;
    constructor(addedTagIds: Array<number>, removedTagIds: Array<number>);
}
declare class TofuStateChangeEvent extends EventJson {
    oldState: string;
    newState: string;
    constructor(oldState: string, newState: string);
}
declare class CoderBetaVmFile extends CoderBetaFile {
    studentPersonId: number;
    url: string;
    constructor(studentPersonId: number, url: string);
}
declare class CoderBetaVideoFile extends CoderBetaFile {
    number: number;
    chapter: number;
    link: string;
    constructor(name: string, chapter: number, number: number, link: string);
}
declare class CoderBetaProblemFile extends CoderBetaFile {
    psetId: number;
    problemNumber: number;
    constructor(name: string, psetId: number, problemNumber: number, parentFileId: string);
}
declare class CoderBetaProjectFile extends CoderBetaFile {
    studentId: number;
    projectId: number;
    constructor(name: string, fileType: string, projectId: number, studentId: number, parentFileId: string);
}
declare class FreeTrialChild extends ChildBase {
    constructor(personId?: any);
    birthMonth: number;
    birthYear: number;
    experience: string;
    hearFrom: string;
    localTime: string;
    freeTrialTimeEpoch: number;
    freeTrialTimeSlotDto: FreeTrialTimeSlotDto;
    availableTimes: number[];
    originallyDesiredTimeSlotDto: FreeTrialTimeSlotDto;
    birthMonthLocked: boolean;
    birthYearLocked: boolean;
    inPerson: boolean;
    timezone: string;
    isChinaTrial: boolean;
}
/**
 * During ProgressState, there is only one EnrollmentChild per child
 * In checkout, there can be multiple EnrollmentChild, with one EnrollmentChild per Cart Item
 * @param {number} personId
 * @class
 * @extends ChildBase
 */
declare class EnrollmentChild extends ChildBase {
    constructor(personId?: any);
    allergies: string;
    classSessionSerialized: string;
    birthMonth: number;
    birthYear: number;
    grade: number;
    chosenClassSessions: string[];
    birthMonthLocked: boolean;
    birthYearLocked: boolean;
    esd: ExtendedStayData;
}
declare enum EnumEventType {
    TOFU_STATE_CHANGE = 0,
    TOFU_DATA_CHANGE = 1,
    FREE_TRIAL_STATE_CHANGE = 2,
    TAG_CHANGE = 3
}
/** @ignore */
declare class EnumEventType_$WRAPPER {
    protected _$ordinal: number;
    protected _$name: string;
    classType: any;
    constructor(_$ordinal: number, _$name: string, classType: any);
    getClassType(): any;
    static getByEventJsonType(classType: any): EnumEventType;
    name(): string;
    ordinal(): number;
    compareTo(other: any): number;
}
