/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.util.model;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.javalite.activejdbc.LazyList;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.ModelDelegate;

public abstract class BaseQueryBuilder<T extends Model> {
    private StringBuilder query = new StringBuilder();
    private List<Object> params = new ArrayList<Object>();
    private String queryPrefix = "";
    private Class<T> modelClass;

    public BaseQueryBuilder(Class<T> modelClass) {
        this.modelClass = modelClass;
    }

    public LazyList<T> query() {
        return ModelDelegate.where(this.modelClass, (String)this.getQuery(), (Object[])this.params.toArray());
    }

    public long count() {
        Long count = ModelDelegate.count(this.modelClass, (String)this.getQuery(), (Object[])this.params.toArray());
        return count == null ? 0L : count;
    }

    private String getQuery() {
        String q = this.query.toString();
        return q.isEmpty() ? "1" : q;
    }

    protected BaseQueryBuilder<T> with(String subquery, Object ... subParams) {
        this.query.append(this.queryPrefix);
        this.query.append('(');
        this.query.append(subquery);
        this.query.append(')');
        this.params.addAll(Arrays.asList(subParams));
        this.queryPrefix = " AND ";
        return this;
    }

    public <I> BaseQueryBuilder<T> withColumnInList(String columnName, Iterable<I> values) {
        return this.withColumnInList(columnName, values, value -> value);
    }

    public <I, O> BaseQueryBuilder<T> withColumnInList(String columnName, Iterable<I> values, Function<I, O> mapper) {
        int size = Iterables.size(values);
        if (size == 0) {
            return this.with("false", new Object[0]);
        }
        this.query.append(this.queryPrefix);
        this.query.append('(');
        this.query.append(columnName);
        this.query.append(" IN (");
        String prefix = "";
        for (I value : values) {
            this.query.append(prefix);
            this.query.append("?");
            this.params.add(mapper.apply(value));
            prefix = ", ";
        }
        this.query.append(")");
        this.query.append(')');
        this.queryPrefix = " AND ";
        return this;
    }

    public BaseQueryBuilder<T> withIds(Iterable<?> ids) {
        return this.withColumnInList("id", ids);
    }

    public <I, O> BaseQueryBuilder<T> withIds(Iterable<I> ids, Function<I, O> mapper) {
        return this.withColumnInList("id", ids, mapper);
    }

    public BaseQueryBuilder<T> withColumnEqualTo(String columnName, Object value) {
        return this.with(columnName + " = ?", value);
    }

    public BaseQueryBuilder<T> withColumnLike(String columnName, Object value) {
        return this.with(columnName + " LIKE ?", "%" + value + "%");
    }

    public BaseQueryBuilder<T> withColumnLessThan(String columnName, Object value) {
        return this.with(columnName + " < ?", value);
    }

    public BaseQueryBuilder<T> withColumnLessThanOrEqualTo(String columnName, Object value) {
        return this.with(columnName + " <= ?", value);
    }

    public BaseQueryBuilder<T> withColumnGreaterThan(String columnName, Object value) {
        return this.with(columnName + " > ?", value);
    }

    public BaseQueryBuilder<T> withColumnGreaterThanOrEqualTo(String columnName, Object value) {
        return this.with(columnName + " >= ?", value);
    }

    public BaseQueryBuilder<T> withColumnNotEqualTo(String columnName, Object value) {
        return this.with(columnName + " != ?", value);
    }
}

