/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.service;

import com.ktbyte.stub.CronJob;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCronService {
    private final transient Logger log = LoggerFactory.getLogger(TaskCronService.class);
    private static final ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(4);
    private final List<CronJob> cronJobs;

    public TaskCronService(CronJob ... cronJobs) {
        this.cronJobs = Arrays.asList(cronJobs);
        this.startTasks();
    }

    private void startTasks() {
        this.cronJobs.forEach(c -> executorService.scheduleAtFixedRate(() -> {
            long startTime = System.currentTimeMillis();
            c.run();
            long endTime = System.currentTimeMillis();
            long lapseTime = endTime - startTime;
            this.log.info(c.getClass().getSimpleName() + " job finished in " + lapseTime + "ms");
        }, c.getInitialDelaySeconds(), c.intervalSeconds(), TimeUnit.SECONDS));
        this.log.info("Started " + this.cronJobs.size() + " cron tasks.");
    }

    public CronJob getCronJobWithName(String className) {
        for (CronJob job : this.cronJobs) {
            if (!job.getClass().getSimpleName().equalsIgnoreCase(className)) continue;
            return job;
        }
        return null;
    }

    public static void schedule(Runnable job, long delaySeconds) {
        executorService.schedule(job, delaySeconds, TimeUnit.SECONDS);
    }

    public static long getSecondsUntilNextHour() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime nextHour = now.withMinute(0).withSecond(0).withNano(0).plus(1L, ChronoUnit.HOURS);
        return now.until(nextHour, ChronoUnit.SECONDS);
    }

    public static long getSecondsUntilNextTimeOfDay(LocalTime ... times) {
        ZonedDateTime now = ZonedDateTime.now(ZoneId.of("America/New_York"));
        Object[] dateTimes = new ZonedDateTime[times.length];
        for (int i = 0; i < times.length; ++i) {
            dateTimes[i] = now.with(times[i]);
            if (!dateTimes[i].isBefore(now)) continue;
            dateTimes[i] = ((ZonedDateTime)dateTimes[i]).plusDays(1L);
        }
        Arrays.sort(dateTimes);
        if (dateTimes.length == 0) {
            return 0L;
        }
        return now.until((Temporal)dateTimes[0], ChronoUnit.SECONDS);
    }
}

