/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.util.model;

import com.ktbyte.util.model.MappedPeekableIterator;
import com.ktbyte.util.model.QuadFunction;
import com.ktbyte.util.model.TriFunction;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Function;

public class JoinIterator<K extends Comparable<? super K>, O>
implements Iterator<O> {
    private MappedPeekableIterator<?, K>[] iters;
    private Function<Object[], O> outputFunction;

    public <A, B> JoinIterator(MappedPeekableIterator<A, K> iterA, MappedPeekableIterator<B, K> iterB, BiFunction<? super A, ? super B, O> function) {
        this(new MappedPeekableIterator[]{iterA, iterB}, objs -> function.apply((Object)objs[0], (Object)objs[1]));
    }

    public <A, B, C> JoinIterator(MappedPeekableIterator<A, K> iterA, MappedPeekableIterator<B, K> iterB, MappedPeekableIterator<C, K> iterC, TriFunction<? super A, ? super B, ? super C, O> function) {
        this(new MappedPeekableIterator[]{iterA, iterB, iterC}, objs -> function.apply(objs[0], objs[1], objs[2]));
    }

    public <A, B, C, D> JoinIterator(MappedPeekableIterator<A, K> iterA, MappedPeekableIterator<B, K> iterB, MappedPeekableIterator<C, K> iterC, MappedPeekableIterator<C, K> iterD, QuadFunction<? super A, ? super B, ? super C, ? super D, O> function) {
        this(new MappedPeekableIterator[]{iterA, iterB, iterC, iterD}, objs -> function.apply(objs[0], objs[1], objs[2], objs[3]));
    }

    public JoinIterator(MappedPeekableIterator<?, K>[] iterators, Function<Object[], O> outputFunction) {
        this.iters = iterators;
        this.outputFunction = outputFunction;
    }

    @Override
    public boolean hasNext() {
        for (int i = 0; i < this.iters.length; ++i) {
            if (!this.iters[i].hasNext()) continue;
            return true;
        }
        return false;
    }

    private K[] getPeekedKeyValues() {
        Comparable[] keyValues = new Comparable[this.iters.length];
        for (int i = 0; i < this.iters.length; ++i) {
            if (!this.iters[i].hasNext()) continue;
            keyValues[i] = (Comparable)this.iters[i].peekMapped();
        }
        return keyValues;
    }

    private K getMin(K[] keyValues) {
        K minKey = keyValues[0];
        for (int i = 1; i < this.iters.length; ++i) {
            K key = keyValues[i];
            if (minKey != null && (key == null || key.compareTo(minKey) >= 0)) continue;
            minKey = key;
        }
        return minKey;
    }

    @Override
    public O next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Comparable[] keyValues = this.getPeekedKeyValues();
        Comparable min = this.getMin(keyValues);
        Object[] input = new Object[this.iters.length];
        for (int i = 0; i < this.iters.length; ++i) {
            if (!min.equals(keyValues[i])) continue;
            input[i] = this.iters[i].next();
        }
        return this.outputFunction.apply(input);
    }
}

