/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.util;

import com.ktbyte.util.IPUtils;
import com.ktbyte.util.StandardizedConfig;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;

public class SendEmailSmtp {
    private static final transient Logger log = LoggerFactory.getLogger(SendEmailSmtp.class);
    private static SendEmailSmtp email;
    private StandardizedConfig config;

    private SendEmailSmtp(StandardizedConfig config) {
        this.config = config;
    }

    public static synchronized SendEmailSmtp get(StandardizedConfig config) {
        if (email == null) {
            email = new SendEmailSmtp(config);
            return email;
        }
        return email;
    }

    public final void logThrowable(Throwable t, Request request, String username) {
        this.logThrowable(t, request, username, null);
    }

    public final void logThrowable(Throwable t, Request request, String username, Map<String, String> paramsForLogging) {
        if (request != null) {
            log.error("Exception for route: " + request.pathInfo(), t);
        }
        if (this.config.getEmailExceptions()) {
            String exceptionStr = ExceptionUtils.getStackTrace((Throwable)t);
            String route = "";
            String url = "";
            String host = "";
            String method = "";
            if (request != null) {
                route = request.pathInfo();
                url = request.url();
                host = request.host();
                method = request.requestMethod();
            }
            if (username == null) {
                username = "<anonymous>";
            }
            String emailBody = "Error on route " + route + "\n" + (request == null ? "" : "IP: " + IPUtils.getRealIp(request) + "\n") + "url: " + url + "\nhost: " + host + "\n" + (paramsForLogging == null ? "" : "params: " + paramsForLogging + "\n") + "method: " + method + "\nusername: " + username + "\nError: " + t.getClass().toString() + "\n" + exceptionStr;
            this.sendCrashReport("Exception: " + t.getClass().toString(), emailBody);
        }
        t.printStackTrace();
    }

    public void sendCrashReport(String title, String body) {
        boolean getEmailExceptions = this.config.getEmailExceptions();
        if (getEmailExceptions) {
            body = body + "\n\n\nbaseUrl=" + this.config.getBaseUrl();
            try {
                this.send("crash@sys.ktbyte.com", title, body, false);
            }
            catch (MessagingException e) {
                log.error("beyond failure... failed to send email about failure");
            }
        } else {
            log.info("Crash Email Not Sent (Because Not Prod): \n\nTitle: " + title + "\n\nBody: \n" + body);
        }
    }

    public void sendAndCatch(String to, String subject, String body, boolean asHtml) {
        this.sendAndCatch(Collections.singletonList(to), subject, body, asHtml);
    }

    public void sendAndCatch(List<String> to, String subject, String body, boolean asHtml) {
        try {
            this.send(to, subject, body, asHtml);
        }
        catch (Exception e) {
            String exceptionStr = ExceptionUtils.getStackTrace((Throwable)e);
            System.err.println("Error sending email");
            e.printStackTrace();
            this.sendCrashReport("failed to email " + to, "subject: \n" + subject + "\n\n\nbody:\n" + body + "\n\n\n" + exceptionStr);
        }
    }

    public void send(String[] to, String subject, String body) throws MessagingException {
        this.send(Arrays.asList(to), subject, body, false);
    }

    public void send(String to, String subject, String body) throws MessagingException {
        this.send(Collections.singletonList(to), subject, body, false);
    }

    public void send(Collection<String> to, String subject, String body) throws MessagingException {
        this.send(to, subject, body, false);
    }

    public void send(String destination, String subject, String body, boolean asHtml) throws MessagingException {
        String from = this.config.getEmailUsername();
        String pass = this.config.getEmailPassword();
        String portStr = this.config.getEmailPort();
        int port = portStr == null ? 587 : Integer.parseInt(portStr);
        this.send(this.config.getEmailHost(), port, from, pass, Collections.singletonList(destination), subject, body, true, asHtml, null);
    }

    public void send(Collection<String> destinations, String subject, String body, boolean asHtml) throws MessagingException {
        String from = this.config.getEmailUsername();
        String pass = this.config.getEmailPassword();
        String portStr = this.config.getEmailPort();
        int port = portStr == null ? 587 : Integer.parseInt(portStr);
        this.send(this.config.getEmailHost(), port, from, pass, destinations, subject, body, true, asHtml, null);
    }

    public void send(String host, int port, String from, String pass, Collection<String> destinations, String subject, String body, boolean ignoreSSL, boolean asHtml, Attachment attachment) throws MessagingException {
        String firstRecipient = destinations.stream().findFirst().orElse(null);
        log.info("Sending email via " + host + ":" + port + " from " + from + " destinations " + destinations.size() + " recipients with subject " + subject + ". First recipient: " + firstRecipient);
        Properties props = System.getProperties();
        if (ignoreSSL) {
            props.put("mail.smtp.ssl.trust", "*");
        }
        if (port != 25) {
            if (port == 587) {
                props.put("mail.smtp.starttls.enable", "true");
            } else if (port == 465) {
                props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                props.put("mail.smtp.socketFactory.port", "465");
            }
        }
        props.put("mail.smtp.host", host);
        if (pass != null) {
            props.put("mail.smtp.user", from);
        }
        if (pass != null) {
            props.put("mail.smtp.password", pass);
        }
        props.put("mail.smtp.port", "" + port);
        if (pass != null) {
            props.put("mail.smtp.auth", "true");
        }
        Session session = Session.getDefaultInstance((Properties)props);
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(from));
        for (String destination : destinations) {
            String EMAIL_PATTERN = "([_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,}))";
            Pattern pattern = Pattern.compile(EMAIL_PATTERN);
            Matcher matcher = pattern.matcher(destination);
            while (matcher.find()) {
                String email = matcher.group(1).toLowerCase().trim();
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(email));
            }
        }
        message.setSentDate(new Date());
        message.setSubject(subject);
        if (attachment == null) {
            if (asHtml) {
                message.setText(body, "utf-8", "html");
            } else {
                message.setText(body);
            }
        } else {
            MimeBodyPart bodyPart = new MimeBodyPart();
            MimeBodyPart attachPart = new MimeBodyPart();
            if (asHtml) {
                bodyPart.setContent((Object)body, "utf-8/html");
            } else {
                bodyPart.setText(body);
            }
            ByteArrayDataSource attachSource = new ByteArrayDataSource(attachment.data, attachment.mimeType);
            attachPart.setDataHandler(new DataHandler((DataSource)attachSource));
            attachPart.setFileName(attachment.filename);
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)bodyPart);
            multipart.addBodyPart((BodyPart)attachPart);
            message.setContent((Multipart)multipart);
        }
        Transport transport = session.getTransport("smtp");
        transport.connect(host, from, pass);
        transport.sendMessage((Message)message, message.getAllRecipients());
        transport.close();
    }

    public static class Attachment {
        public String filename;
        public byte[] data;
        public String mimeType;
    }
}

