/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.dto;

import com.ktbyte.dto.task.KtbytePset;

public class PsetInfo {
    public final int id;
    public final int number;
    public final String title;
    public final Type type;
    public final boolean done;
    public final boolean good;
    public final float averageGrade;

    public PsetInfo(KtbytePset pset, boolean done, boolean good, float averageGrade) {
        this.id = pset.id;
        this.number = pset.number;
        this.title = pset.title;
        this.type = Type.from(pset.psetType);
        this.done = done;
        this.good = good;
        this.averageGrade = averageGrade;
    }

    public PsetInfo(int id, int number, String title, Type type, boolean done, boolean good, float average) {
        this.id = id;
        this.number = number;
        this.title = title;
        this.type = type;
        this.done = done;
        this.good = good;
        this.averageGrade = average;
    }

    static enum Type {
        LECTURE("lec"),
        HOMEWORK("hw"),
        TEST("test");

        private final String key;

        private Type(String key) {
            this.key = key;
        }

        static Type from(String key) {
            for (Type type : Type.values()) {
                if (!type.key.equals(key)) continue;
                return type;
            }
            return null;
        }
    }
}

