/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.util.model;

import com.ktbyte.util.model.MappedPeekableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;

public class GroupIterator<K, V, I extends Comparable<? super I>, O>
implements Iterator<O> {
    private MappedPeekableIterator<K, I> iterK;
    private MappedPeekableIterator<V, I> iterV;
    private BiFunction<? super K, List<V>, O> function;

    private GroupIterator(MappedPeekableIterator<K, I> iterK, MappedPeekableIterator<V, I> iterV, BiFunction<? super K, List<V>, O> function) {
        this.iterK = iterK;
        this.iterV = iterV;
        this.function = function;
    }

    public static <K, V, I extends Comparable<? super I>, O> GroupIterator<K, V, I, O> of(MappedPeekableIterator<K, I> iterK, MappedPeekableIterator<V, I> iterV, BiFunction<? super K, List<V>, O> function) {
        return new GroupIterator<K, V, I, O>(iterK, iterV, function);
    }

    @Override
    public boolean hasNext() {
        return this.iterK.hasNext();
    }

    @Override
    public O next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Comparable index = (Comparable)this.iterK.peekMapped();
        Object key = this.iterK.next();
        ArrayList values = new ArrayList();
        int comp = 0;
        while (this.iterV.hasNext() && (comp = ((Comparable)this.iterV.peekMapped()).compareTo(index)) <= 0) {
            Object value = this.iterV.next();
            if (comp != 0) continue;
            values.add(value);
        }
        return this.function.apply(key, values);
    }
}

