/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.util.partialcontent;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class LimitedInputStream
extends FilterInputStream {
    private final long limit;
    private long pos;

    public LimitedInputStream(InputStream in, long limit) {
        super(in);
        this.limit = limit < 0L ? 0L : limit;
    }

    @Override
    public int read() throws IOException {
        if (this.pos < this.limit) {
            ++this.pos;
            return super.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.limit - this.pos < (long)len && (len = (int)(this.limit - this.pos)) <= 0) {
            return -1;
        }
        int res = super.read(b, off, len);
        if (res > 0) {
            this.pos += (long)res;
        }
        return res;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n > this.limit - this.pos) {
            n = this.limit - this.pos;
        }
        long s = this.in.skip(n);
        this.pos += s;
        return s;
    }

    @Override
    public void reset() throws IOException {
        this.pos = 0L;
        this.in.reset();
    }
}

