/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.service;

import com.ktbyte.dto.progressstate.AccountChildrenJson;
import com.ktbyte.dto.progressstate.AccountChooseJson;
import com.ktbyte.dto.progressstate.AccountParentJson;
import com.ktbyte.dto.progressstate.AccountSingleChildJson;
import com.ktbyte.dto.progressstate.EnrollmentJson;
import com.ktbyte.dto.progressstate.FreeTrialJson;
import com.ktbyte.dto.progressstate.ProgressStateWriteJson;
import com.ktbyte.enums.enrollment.EnumProgressType;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class ProgressStateTypeMapping {
    public static final Map<String, Class<? extends ProgressStateWriteJson>> jsonClasses = Collections.unmodifiableMap(ProgressStateTypeMapping.jsoninit());
    public static final Map<String, Map<String, String>> nextPST = Collections.unmodifiableMap(ProgressStateTypeMapping.nextinit());
    public static final Set<String> progressStateTypes = Collections.unmodifiableSet(ProgressStateTypeMapping.initProgressStates());
    public static final Set<String> progressTypes = Collections.unmodifiableSet(ProgressStateTypeMapping.initProgresses());
    public static final Map<String, String> startOfPTs = Collections.unmodifiableMap(ProgressStateTypeMapping.initStartOfPT());

    public static Map<String, String> initStartOfPT() {
        TreeMap<String, String> mp = new TreeMap<String, String>();
        mp.put(EnumProgressType.FREE_TRIAL_PT.getValue(), EnumProgressType.FREE_TRIAL_PST.getValue());
        mp.put(EnumProgressType.ENROLLMENT_PT.getValue(), EnumProgressType.ENROLLMENT_PST.getValue());
        mp.put(EnumProgressType.ACCOUNT_CREATION_PT.getValue(), EnumProgressType.ACCOUNT_CHOOSE_PST.getValue());
        return mp;
    }

    public static Set<String> initProgresses() {
        TreeSet<String> st = new TreeSet<String>();
        st.add(EnumProgressType.FREE_TRIAL_PT.getValue());
        st.add(EnumProgressType.ENROLLMENT_PT.getValue());
        st.add(EnumProgressType.ACCOUNT_CREATION_PT.getValue());
        return st;
    }

    public static Set<String> initProgressStates() {
        TreeSet<String> st = new TreeSet<String>();
        st.add(EnumProgressType.FREE_TRIAL_PST.getValue());
        st.add(EnumProgressType.ENROLLMENT_PST.getValue());
        st.add(EnumProgressType.ACCOUNT_CHOOSE_PST.getValue());
        st.add(EnumProgressType.ACCOUNT_PARENT_PST.getValue());
        st.add(EnumProgressType.ACCOUNT_SINGLE_CHILD_PST.getValue());
        st.add(EnumProgressType.ACCOUNT_CHILDREN_PST.getValue());
        return st;
    }

    public static Map<String, Class<? extends ProgressStateWriteJson>> jsoninit() {
        TreeMap<String, Class<? extends ProgressStateWriteJson>> mp = new TreeMap<String, Class<? extends ProgressStateWriteJson>>();
        mp.put(EnumProgressType.FREE_TRIAL_PST.getValue(), FreeTrialJson.class);
        mp.put(EnumProgressType.ENROLLMENT_PST.getValue(), EnrollmentJson.class);
        mp.put(EnumProgressType.ACCOUNT_CHOOSE_PST.getValue(), AccountChooseJson.class);
        mp.put(EnumProgressType.ACCOUNT_PARENT_PST.getValue(), AccountParentJson.class);
        mp.put(EnumProgressType.ACCOUNT_SINGLE_CHILD_PST.getValue(), AccountSingleChildJson.class);
        mp.put(EnumProgressType.ACCOUNT_CHILDREN_PST.getValue(), AccountChildrenJson.class);
        return mp;
    }

    public static Map<String, Map<String, String>> nextinit() {
        TreeMap<String, Map<String, String>> mp = new TreeMap<String, Map<String, String>>();
        TreeMap<String, String> freeTrialMP = new TreeMap<String, String>();
        TreeMap<String, String> enrollmentMP = new TreeMap<String, String>();
        TreeMap<String, Object> accountChoseMP = new TreeMap<String, Object>();
        TreeMap<String, String> accountParentMP = new TreeMap<String, String>();
        TreeMap<String, String> accountSingleChildMP = new TreeMap<String, String>();
        TreeMap<String, String> accountChildrenMP = new TreeMap<String, String>();
        mp.put(EnumProgressType.FREE_TRIAL_PST.getValue(), freeTrialMP);
        mp.put(EnumProgressType.ENROLLMENT_PST.getValue(), enrollmentMP);
        mp.put(EnumProgressType.ACCOUNT_CHOOSE_PST.getValue(), accountChoseMP);
        mp.put(EnumProgressType.ACCOUNT_PARENT_PST.getValue(), accountParentMP);
        mp.put(EnumProgressType.ACCOUNT_SINGLE_CHILD_PST.getValue(), accountSingleChildMP);
        mp.put(EnumProgressType.ACCOUNT_CHILDREN_PST.getValue(), accountChildrenMP);
        freeTrialMP.put(EnumProgressType.NOT_LOGGED_IN.getValue(), EnumProgressType.ACCOUNT_CHOOSE_PST.getValue());
        freeTrialMP.put(EnumProgressType.STUDENT_LOGGED_IN.getValue(), EnumProgressType.FREE_TRIAL_PT.getValue());
        freeTrialMP.put(EnumProgressType.PARENT_LOGGED_IN.getValue(), EnumProgressType.ACCOUNT_CHILDREN_PST.getValue());
        enrollmentMP.put(EnumProgressType.NOT_LOGGED_IN.getValue(), EnumProgressType.ACCOUNT_CHOOSE_PST.getValue());
        enrollmentMP.put(EnumProgressType.STUDENT_LOGGED_IN.getValue(), EnumProgressType.ENROLLMENT_PT.getValue());
        enrollmentMP.put(EnumProgressType.PARENT_LOGGED_IN.getValue(), EnumProgressType.ACCOUNT_CHILDREN_PST.getValue());
        accountChoseMP.put(EnumProgressType.NOT_LOGGED_IN.getValue(), null);
        accountChoseMP.put(EnumProgressType.STUDENT_LOGGED_IN.getValue(), null);
        accountChoseMP.put(EnumProgressType.PARENT_LOGGED_IN.getValue(), null);
        accountParentMP.put(EnumProgressType.NOT_LOGGED_IN.getValue(), EnumProgressType.ACCOUNT_CHILDREN_PST.getValue());
        accountParentMP.put(EnumProgressType.STUDENT_LOGGED_IN.getValue(), null);
        accountParentMP.put(EnumProgressType.PARENT_LOGGED_IN.getValue(), EnumProgressType.ACCOUNT_CHILDREN_PST.getValue());
        accountSingleChildMP.put(EnumProgressType.NOT_LOGGED_IN.getValue(), EnumProgressType.ACCOUNT_CREATION_PT.getValue());
        accountSingleChildMP.put(EnumProgressType.STUDENT_LOGGED_IN.getValue(), EnumProgressType.ACCOUNT_CREATION_PT.getValue());
        accountSingleChildMP.put(EnumProgressType.PARENT_LOGGED_IN.getValue(), EnumProgressType.ACCOUNT_CREATION_PT.getValue());
        accountChildrenMP.put(EnumProgressType.NOT_LOGGED_IN.getValue(), EnumProgressType.ACCOUNT_CREATION_PT.getValue());
        accountChildrenMP.put(EnumProgressType.STUDENT_LOGGED_IN.getValue(), EnumProgressType.ACCOUNT_CREATION_PT.getValue());
        accountChildrenMP.put(EnumProgressType.PARENT_LOGGED_IN.getValue(), EnumProgressType.ACCOUNT_CREATION_PT.getValue());
        return mp;
    }
}

