/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.enums;

import com.ktbyte.enums.IdToEnumReadable;
import java.util.List;
import java.util.Map;

public class EnumUtil {
    private EnumUtil() {
    }

    public static <A extends IdToEnumReadable<C>, B extends Class<A>, C> A translateIdToEnum(B enumClass, C id) {
        for (IdToEnumReadable type : (IdToEnumReadable[])enumClass.getEnumConstants()) {
            if (!type.getId().equals(id)) continue;
            return (A)type;
        }
        return null;
    }

    public static <A extends IdToEnumReadable<C>, C> A getEnumFromIdJS(Map<String, List<A>> enumName, C id) {
        for (IdToEnumReadable type : enumName.get("_$wrappers")) {
            if (!type.getId().equals(id)) continue;
            return (A)type;
        }
        return null;
    }

    public static <A extends IdToEnumReadable<C>, C> A getEnumFromOrdinalJS(Map<String, List<A>> enumName, int enumIndex) {
        List<A> allEnums = enumName.get("_$wrappers");
        if (enumIndex >= allEnums.size()) {
            return null;
        }
        return (A)((IdToEnumReadable)allEnums.get(enumIndex));
    }

    public static <A extends IdToEnumReadable<C>, C> List<A> getAllEnumTypesJS(Map<String, List<A>> enumName) {
        return enumName.get("_$wrappers");
    }

    public static <A extends IdToEnumReadable<C>, C> Integer getOrdinalFromIdJS(Map<String, List<A>> enumName, C id) {
        List<A> allEnums = enumName.get("_$wrappers");
        int length = allEnums.size();
        for (int idx = 0; idx < length; ++idx) {
            if (!((IdToEnumReadable)allEnums.get(idx)).getId().equals(id)) continue;
            return idx;
        }
        return null;
    }
}

