/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.util;

import com.ktbyte.util.IPUtils;
import com.ktbyte.util.StandardizedConfig;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;

public class SendEmailSmtp {
    private static final transient Logger log = LoggerFactory.getLogger(SendEmailSmtp.class);
    private static SendEmailSmtp email;
    private StandardizedConfig config;

    private SendEmailSmtp(StandardizedConfig config) {
        this.config = config;
    }

    public static synchronized SendEmailSmtp get(StandardizedConfig config) {
        if (email == null) {
            email = new SendEmailSmtp(config);
            return email;
        }
        return email;
    }

    public final void logThrowable(Throwable t, Request request, String username) {
        this.logThrowable(t, request, username, null);
    }

    public final void logThrowable(Throwable t, Request request, String username, Map<String, String> paramsForLogging) {
        if (request != null) {
            log.error("Exception for route: " + request.pathInfo(), t);
        }
        if (this.config.getEmailExceptions()) {
            String exceptionStr = ExceptionUtils.getStackTrace((Throwable)t);
            String route = "";
            String url = "";
            String host = "";
            String method = "";
            if (request != null) {
                route = request.pathInfo();
                url = request.url();
                host = request.host();
                method = request.requestMethod();
            }
            if (username == null) {
                username = "<anonymous>";
            }
            String emailBody = "Error on route " + route + "\n" + (request == null ? "" : "IP: " + IPUtils.getRealIp(request) + "\n") + "url: " + url + "\nhost: " + host + "\n" + (paramsForLogging == null ? "" : "params: " + paramsForLogging + "\n") + "method: " + method + "\nusername: " + username + "\nError: " + t.getClass().toString() + "\n" + exceptionStr;
            this.sendCrashReport("Exception: " + t.getClass().toString(), emailBody);
        }
        t.printStackTrace();
    }

    public void sendCrashReport(String title, String body) {
        boolean getEmailExceptions = this.config.getEmailExceptions();
        if (getEmailExceptions) {
            String[] recipients = new String[]{"crash@sys.ktbyte.com"};
            body = body + "\n\n\nbaseUrl=" + this.config.getBaseUrl();
            try {
                this.send(recipients, title, body, false);
            }
            catch (MessagingException e) {
                log.error("beyond failure... failed to send email about failure");
            }
        } else {
            log.info("Crash Email Not Sent (Because Not Prod): \n\nTitle: " + title + "\n\nBody: \n" + body);
        }
    }

    public void sendAndCatch(String[] to, String subject, String body, boolean asHtml) {
        try {
            this.send(to, subject, body, asHtml);
        }
        catch (Exception e) {
            String exceptionStr = ExceptionUtils.getStackTrace((Throwable)e);
            System.err.println("Error sending email");
            e.printStackTrace();
            this.sendCrashReport("failed to email " + Arrays.toString(to), "subject: \n" + subject + "\n\n\nbody:\n" + body + "\n\n\n" + exceptionStr);
        }
    }

    public void send(String[] to, String subject, String body) throws AddressException, MessagingException {
        this.send(to, subject, body, false);
    }

    public void send(String[] to, String subject, String body, boolean asHtml) throws AddressException, MessagingException {
        String from = this.config.getEmailUsername();
        String pass = this.config.getEmailPassword();
        String portStr = this.config.getEmailPort();
        int port = portStr == null ? 587 : Integer.parseInt(portStr);
        this.send(this.config.getEmailHost(), port, from, pass, to, subject, body, true, asHtml);
    }

    public void send(String host, int port, String from, String pass, String[] to, String subject, String body, boolean ignoreSSL, boolean asHtml) throws MessagingException {
        String firstRecipient = to.length > 0 ? to[0] : null;
        log.info("Sending email via " + host + ":" + port + " from " + from + " to " + to.length + " recipients with subject " + subject + ". First recipient: " + firstRecipient);
        Properties props = System.getProperties();
        if (ignoreSSL) {
            props.put("mail.smtp.ssl.trust", "*");
        }
        if (port != 25) {
            if (port == 587) {
                props.put("mail.smtp.starttls.enable", "true");
            } else if (port == 465) {
                props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                props.put("mail.smtp.socketFactory.port", "465");
            }
        }
        props.put("mail.smtp.host", host);
        if (pass != null) {
            props.put("mail.smtp.user", from);
        }
        if (pass != null) {
            props.put("mail.smtp.password", pass);
        }
        props.put("mail.smtp.port", "" + port);
        if (pass != null) {
            props.put("mail.smtp.auth", "true");
        }
        Session session = Session.getDefaultInstance((Properties)props);
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(from));
        InternetAddress[] toAddress = new InternetAddress[to.length];
        for (int i = 0; i < toAddress.length; ++i) {
            String toSingle = to[i];
            String EMAIL_PATTERN = "([_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,}))";
            Pattern pattern = Pattern.compile(EMAIL_PATTERN);
            Matcher matcher = pattern.matcher(toSingle);
            while (matcher.find()) {
                String email = matcher.group(1).toLowerCase().trim();
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(email));
            }
        }
        message.setSentDate(new Date());
        message.setSubject(subject);
        if (asHtml) {
            message.setText(body, "utf-8", "html");
        } else {
            message.setText(body);
        }
        Transport transport = session.getTransport("smtp");
        transport.connect(host, from, pass);
        transport.sendMessage((Message)message, message.getAllRecipients());
        transport.close();
    }

    public void send(String host, int port, String from, String pass, String[] to, String subject, String body, boolean ignoreSSL, boolean asHtml, Attachment attachment) throws AddressException, MessagingException {
        log.info("Sending email via " + host + ":" + port + " from " + from + " to " + to.length + " recipients with subject " + subject + ". First recipient: " + to[0]);
        Properties props = System.getProperties();
        if (ignoreSSL) {
            props.put("mail.smtp.ssl.trust", "*");
        }
        if (port != 25) {
            if (port == 587) {
                props.put("mail.smtp.starttls.enable", "true");
            } else if (port == 465) {
                props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                props.put("mail.smtp.socketFactory.port", "465");
            }
        }
        props.put("mail.smtp.host", host);
        if (pass != null) {
            props.put("mail.smtp.user", from);
        }
        if (pass != null) {
            props.put("mail.smtp.password", pass);
        }
        props.put("mail.smtp.port", "" + port);
        if (pass != null) {
            props.put("mail.smtp.auth", "true");
        }
        Session session = Session.getDefaultInstance((Properties)props);
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(from));
        InternetAddress[] toAddress = new InternetAddress[to.length];
        for (int i = 0; i < toAddress.length; ++i) {
            String toSingle = to[i];
            String EMAIL_PATTERN = "([_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,}))";
            Pattern pattern = Pattern.compile(EMAIL_PATTERN);
            Matcher matcher = pattern.matcher(toSingle);
            while (matcher.find()) {
                String email = matcher.group(1).toLowerCase().trim();
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(email));
            }
        }
        message.setSentDate(new Date());
        message.setSubject(subject);
        MimeBodyPart bodyPart = new MimeBodyPart();
        MimeBodyPart attachPart = new MimeBodyPart();
        if (asHtml) {
            bodyPart.setContent((Object)body, "utf-8/html");
        } else {
            bodyPart.setText(body);
        }
        ByteArrayDataSource attachSource = new ByteArrayDataSource(attachment.data, attachment.mimeType);
        attachPart.setDataHandler(new DataHandler((DataSource)attachSource));
        attachPart.setFileName(attachment.filename);
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)bodyPart);
        multipart.addBodyPart((BodyPart)attachPart);
        message.setContent((Multipart)multipart);
        Transport transport = session.getTransport("smtp");
        transport.connect(host, from, pass);
        transport.sendMessage((Message)message, message.getAllRecipients());
        transport.close();
    }

    public boolean validateEmails(String[] addresses) {
        for (String address : addresses) {
            if (this.validateEmail(address)) continue;
            return false;
        }
        return true;
    }

    public boolean validateEmail(String address) {
        try {
            new InternetAddress(address);
        }
        catch (AddressException e) {
            return false;
        }
        return true;
    }

    public class Attachment {
        public String filename;
        public byte[] data;
        public String mimeType;
    }
}

