/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.util;

import com.ktbyte.util.StandardizedConfig;
import org.javalite.activejdbc.Base;
import org.javalite.activejdbc.logging.LogFilter;

public class DatabaseConnection {
    private static String databaseName;
    private static String databaseUsername;
    private static String databasePassword;
    private static String databaseUrlPrefix;
    private static String databaseSuffix;

    public static void connect() {
        if (databaseName == null) {
            throw new RuntimeException("Please run DatabaseConnection.init() first (just once)");
        }
        if (!Base.hasConnection()) {
            Base.open((String)"com.mysql.jdbc.Driver", (String)(databaseUrlPrefix + databaseName + "?useUnicode=true&characterEncoding=UTF-8&nullNamePatternMatchesAll=true"), (String)databaseUsername, (String)databasePassword);
            Base.exec((String)"SET NAMES utf8mb4");
        }
    }

    public static void disconnect() {
        if (Base.hasConnection()) {
            Base.close();
        }
    }

    public static void init(StandardizedConfig config) {
        databaseName = config.getDatabaseName();
        databaseUsername = config.getDatabaseUsername();
        databasePassword = config.getDatabasePassword();
        databaseUrlPrefix = config.getDatabaseUrlPrefix();
        databaseSuffix = config.getDatabaseSuffix();
        if (databaseSuffix == null) {
            databaseSuffix = "";
        }
    }

    static {
        LogFilter.setLogExpression((String)".*(Opened|Closed).*");
        databaseName = null;
        databaseUsername = null;
        databasePassword = null;
        databaseUrlPrefix = null;
        databaseSuffix = null;
    }
}

