/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.stub;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ktbyte.annotation.Authenticate;
import com.ktbyte.stub.ServiceProvider;
import com.ktbyte.stub.VerifyingAuthenticationManager;
import com.ktbyte.util.SendEmailSmtp;
import com.ktbyte.util.StandardizedConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import spark.Request;
import spark.Response;
import spark.Route;
import spark.Spark;

public abstract class SparkServiceRequestHandler<T> {
    Logger log;
    Class<T> serviceType;
    T serviceInstance;
    ServiceProvider<T> serviceProvider;
    StandardizedConfig config;
    boolean isServiceProvider;
    private VerifyingAuthenticationManager authManager;

    private SparkServiceRequestHandler(StandardizedConfig config, Logger log, Class<T> serviceType, VerifyingAuthenticationManager authManager) {
        this.log = log;
        this.serviceType = serviceType;
        this.authManager = authManager;
        this.config = config;
    }

    public SparkServiceRequestHandler(StandardizedConfig config, Logger log, Class<T> serviceType, T serviceInstance, VerifyingAuthenticationManager authManager) {
        this(config, log, serviceType, authManager);
        this.serviceInstance = serviceInstance;
        this.isServiceProvider = false;
        this.init();
    }

    public SparkServiceRequestHandler(StandardizedConfig config, Logger log, Class<T> serviceType, ServiceProvider<T> serviceProvider, VerifyingAuthenticationManager authManager) {
        this(config, log, serviceType, authManager);
        this.serviceProvider = serviceProvider;
        this.isServiceProvider = true;
        this.init();
    }

    protected abstract void init();

    protected final void registerServiceRoute(Route route) {
        try {
            Spark.post((String)("/services/" + this.serviceType.getSimpleName()), (String)"application/json", (Route)route);
        }
        catch (Exception e) {
            this.log.error("service declaration error for " + this.serviceType, (Throwable)e);
        }
    }

    protected final void registerServiceRoute(Route route, String urlPrefix) {
        try {
            Spark.get((String)(urlPrefix + "/services/" + this.serviceType.getSimpleName()), (String)"application/json", (Route)route);
            Spark.post((String)(urlPrefix + "/services/" + this.serviceType.getSimpleName()), (String)"application/json", (Route)route);
        }
        catch (Exception e) {
            this.log.error("service declaration error for " + this.serviceType, (Throwable)e);
        }
    }

    protected final Object handleServiceRequest(Request request, Response response, String currentUsername) {
        String transactionId = null;
        TreeMap<String, String> paramsForLogging = new TreeMap<String, String>();
        try {
            T actualServiceInstance = this.isServiceProvider ? this.serviceProvider.getServiceInstance(request, response) : this.serviceInstance;
            response.type("application/json");
            response.header("Content-Encoding", "gzip");
            Type mapType = new TypeToken<TreeMap<String, String>>(){}.getType();
            Map<String, String> params = null;
            if (request.queryParams("__functionName") == null || request.queryParams("__functionName").length() == 0) {
                String body = request.body();
                params = (Map)new Gson().fromJson(body, mapType);
            } else {
                params = new TreeMap();
                Set paramNames = request.queryParams();
                for (String paramName : paramNames) {
                    params.put(paramName, request.queryParams(paramName));
                }
            }
            paramsForLogging.putAll(params);
            paramsForLogging.replace("password", "****");
            String functionName = (String)params.get("__functionName");
            transactionId = (String)params.get("__tid");
            if (functionName.equals("compile") || functionName.equals("validate")) {
                paramsForLogging.replace("javablockdata", "[\"omitted because long af\"]");
                paramsForLogging.replace("javacode", "[\"omitted because long af\"]");
            } else if (functionName.equals("saveProblem")) {
                paramsForLogging.replace("request", "[\"omitted because long af\"]");
            } else if (functionName.equals("getUsers")) {
                paramsForLogging.replace("personIds", "[\"omitted because super long\"]");
            } else if (functionName.equals("nextProgressState") || functionName.equals("previousProgressState")) {
                paramsForLogging.replace("pst", "[\"omitted\"]");
                paramsForLogging.replace("csrf", "[\"omitted\"]");
            }
            List<String> ignoreTheseFunctions = Arrays.asList("getAllTasksByClassSessionLessonTime", "getTaskCountBy", "updateOrCreateTaskByQuery", "updateTaskByQuery", "getAllTasksBy", "getEnrollments", "getMissingDataBatch", "getCloudVirtualDesktopStateAndURL");
            boolean useDebugForOverlyCommonFunctions = ignoreTheseFunctions.contains(functionName);
            if (useDebugForOverlyCommonFunctions) {
                this.log.debug("dtos service params from user '" + currentUsername + "': " + paramsForLogging);
            } else {
                this.log.info("dtos service params from user '" + currentUsername + "': " + paramsForLogging);
            }
            return SparkServiceRequestHandler.callDtosMethod(params, this.serviceType, actualServiceInstance, this.log, this.authManager);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            SendEmailSmtp.get(this.config).logThrowable(ex, request, currentUsername, paramsForLogging);
            response.status(500);
            Gson gson = new Gson();
            JsonObject payload = new JsonObject();
            payload.addProperty("__tid", transactionId);
            payload.add("__error", gson.toJsonTree((Object)ex));
            String error = new Gson().toJson((JsonElement)payload);
            return error;
        }
    }

    public static boolean verifyAuthentication(Map<String, String> params, VerifyingAuthenticationManager authManager) {
        long remoteTime;
        String timeStr = params.get("__time");
        String sig = params.get("__sig");
        long time = System.currentTimeMillis();
        if (Math.abs(time - (remoteTime = Long.parseLong(timeStr))) > 3600000L) {
            throw new RuntimeException("error: invalid timestamp. local: " + time + " remote: " + remoteTime);
        }
        return authManager.verify("" + remoteTime, sig);
    }

    static <T> String callDtosMethod(Map<String, String> params, Class<? extends T> serviceType, T actualServiceInstance, Logger log, VerifyingAuthenticationManager authManager) throws Exception {
        String functionName = params.get("__functionName");
        String transactionId = params.get("__tid");
        Method method = null;
        for (Method m : serviceType.getMethods()) {
            if (!m.getName().equals(functionName)) continue;
            method = m;
            break;
        }
        if (method != null) {
            boolean verified;
            log.debug("found service method: " + method);
            ArrayList<Object> args = new ArrayList<Object>();
            for (Parameter param : method.getParameters()) {
                log.debug("adding arg " + param.getName() + " : " + param.getType());
                if ("arg0".equals(param.getName())) {
                    String message = "service class " + serviceType + " should be compiled with -parameters option. Or you need to do `mvn install` on dtos";
                    log.error(message);
                    throw new RuntimeException(message);
                }
                args.add(new Gson().fromJson(params.get(param.getName()), param.getParameterizedType()));
            }
            if (method.isAnnotationPresent(Authenticate.class) && !(verified = SparkServiceRequestHandler.verifyAuthentication(params, authManager))) {
                throw new RuntimeException("Could not verify signature");
            }
            try {
                String[] ignoreMethods;
                long startTime = System.currentTimeMillis();
                Object result = method.invoke(actualServiceInstance, args.toArray());
                long endTime = System.currentTimeMillis();
                boolean showLogTimer = true;
                for (String ignoreMethod : ignoreMethods = new String[]{"getCloudVirtualDesktopStateAndURL"}) {
                    if (!method.getName().equals(ignoreMethod)) continue;
                    showLogTimer = false;
                }
                if (showLogTimer) {
                    log.info(serviceType.getSimpleName() + "." + method.getName() + " request finished in " + (endTime - startTime) + "ms, requestId: " + transactionId);
                }
                Gson gson = new Gson();
                JsonObject payload = new JsonObject();
                payload.addProperty("__tid", transactionId);
                payload.add("__result", gson.toJsonTree(result));
                return gson.toJson((JsonElement)payload);
            }
            catch (InvocationTargetException e) {
                Exception cause = null;
                if (e.getCause() instanceof Exception) {
                    cause = (Exception)e.getCause();
                }
                throw cause == null ? e : cause;
            }
        }
        if (!"toString".equals(functionName)) {
            String message = "function " + functionName + " not found in " + serviceType + " (" + actualServiceInstance + ")";
            log.error(message);
            throw new RuntimeException(message);
        }
        return null;
    }
}

