/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.stub;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ktbyte.annotation.Authenticate;
import com.ktbyte.annotation.Retry;
import com.ktbyte.annotation.SwallowErrors;
import com.ktbyte.service.CrmFreeTrialsService;
import com.ktbyte.service.CrmMakeupsService;
import com.ktbyte.service.CrmPeopleService;
import com.ktbyte.service.FreeTrialTimeSlotsService;
import com.ktbyte.service.KtbyteCrmCacheService;
import com.ktbyte.service.KtbyteCrmEmailService;
import com.ktbyte.service.KtbyteCrmService;
import com.ktbyte.service.KtbyteCrmTaskService;
import com.ktbyte.service.KtbyteEarthReplicationService;
import com.ktbyte.service.KtbyteEarthService;
import com.ktbyte.service.KtbyteEarthTaskService;
import com.ktbyte.service.MakeupsService;
import com.ktbyte.service.ProcessingCompilationService;
import com.ktbyte.service.ScalableDockerService;
import com.ktbyte.service.TofuLeadsService;
import com.ktbyte.service.TofuTagsService;
import com.ktbyte.service.VMMService;
import com.ktbyte.stub.SigningAuthenticationManager;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.request.HttpRequestWithBody;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.http.NoHttpResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaServiceHttpStubFactory {
    private static Logger logger = LoggerFactory.getLogger(JavaServiceHttpStubFactory.class);
    private URI baseURI;
    private String serviceName;
    private SigningAuthenticationManager authenticationManager;
    private List<String> methodsExcludedFromLogging = Arrays.asList("VMMService.getCloudVirtualDesktopStateAndURL", "KtbyteCrmTaskService.getAllTasksByClassSessionLessonTime", "KtbyteCrmTaskService.getTaskCountBy", "KtbyteCrmService.getEnrollments");

    public JavaServiceHttpStubFactory(URI baseURI, SigningAuthenticationManager authenticationManager) {
        this.baseURI = baseURI;
        String uriString = baseURI.toString();
        this.serviceName = uriString.substring(uriString.lastIndexOf("/") + 1);
        this.authenticationManager = authenticationManager;
    }

    static JsonObject generatePayLoad(Method m, Object[] args, SigningAuthenticationManager authenticationManager) {
        String transactionId = UUID.randomUUID().toString();
        String functionName = m.getName();
        Gson gson = new Gson();
        JsonObject payload = new JsonObject();
        for (int i = 0; i < m.getParameters().length; ++i) {
            String paramName = m.getParameters()[i].getName();
            if ("arg0".equals(paramName)) {
                logger.error("service class " + m.getDeclaringClass() + " should be compiled with -parameters option");
            }
            payload.addProperty(paramName, gson.toJson(args[i]));
        }
        payload.addProperty("__tid", transactionId);
        payload.addProperty("__functionName", functionName);
        String timeStr = "" + System.currentTimeMillis();
        payload.addProperty("__time", timeStr);
        if (authenticationManager != null && m.isAnnotationPresent(Authenticate.class)) {
            payload.addProperty("__sig", authenticationManager.sign(timeStr));
        }
        return payload;
    }

    private <T> T createHttpInvokeStub(Class<T> serviceType) {
        Object stub = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{serviceType}, (InvocationHandler)new HttpInvokeStub());
        return (T)stub;
    }

    public String getURIPath() {
        return this.baseURI.toString();
    }

    public ProcessingCompilationService createProcessingCompilationService() {
        return this.createHttpInvokeStub(ProcessingCompilationService.class);
    }

    public KtbyteCrmService createKtbyteCrmService() {
        return this.createHttpInvokeStub(KtbyteCrmService.class);
    }

    public CrmPeopleService createCrmPeopleService() {
        return this.createHttpInvokeStub(CrmPeopleService.class);
    }

    public KtbyteCrmTaskService createCrmTaskService() {
        return this.createHttpInvokeStub(KtbyteCrmTaskService.class);
    }

    public KtbyteEarthTaskService createEarthTaskService() {
        return this.createHttpInvokeStub(KtbyteEarthTaskService.class);
    }

    public CrmMakeupsService createCrmMakeupsService() {
        return this.createHttpInvokeStub(CrmMakeupsService.class);
    }

    public MakeupsService createMakeupsService() {
        return this.createHttpInvokeStub(MakeupsService.class);
    }

    public TofuLeadsService createTofuLeadsService() {
        return this.createHttpInvokeStub(TofuLeadsService.class);
    }

    public TofuTagsService createTofuTagsService() {
        return this.createHttpInvokeStub(TofuTagsService.class);
    }

    public CrmFreeTrialsService createCrmFreeTrialsService() {
        return this.createHttpInvokeStub(CrmFreeTrialsService.class);
    }

    public FreeTrialTimeSlotsService createCrmFreeTrialTimeSlotsService() {
        return this.createHttpInvokeStub(FreeTrialTimeSlotsService.class);
    }

    public KtbyteCrmEmailService createCrmEmailService() {
        return this.createHttpInvokeStub(KtbyteCrmEmailService.class);
    }

    public KtbyteCrmCacheService createCrmCacheService() {
        return this.createHttpInvokeStub(KtbyteCrmCacheService.class);
    }

    public KtbyteEarthService createKtbyteEarthService() {
        return this.createHttpInvokeStub(KtbyteEarthService.class);
    }

    public ScalableDockerService createScalableDockerService() {
        return this.createHttpInvokeStub(ScalableDockerService.class);
    }

    public KtbyteEarthReplicationService createKtbyteEarthReplicationService() {
        return this.createHttpInvokeStub(KtbyteEarthReplicationService.class);
    }

    public VMMService createVmmService() {
        return this.createHttpInvokeStub(VMMService.class);
    }

    class HttpInvokeStub
    implements InvocationHandler {
        HttpInvokeStub() {
        }

        @Override
        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            try {
                return this.doInvoke(proxy, m, args);
            }
            catch (Throwable t) {
                boolean hasRetryAnnotation = m.isAnnotationPresent(Retry.class);
                if (hasRetryAnnotation || this.isNoHttpResponseException(t)) {
                    int retries;
                    logger.info("Request failed... Trying again");
                    int n = retries = hasRetryAnnotation ? m.getAnnotation(Retry.class).value() : 3;
                    while (retries-- > 0) {
                        try {
                            Thread.sleep(3000L);
                            return this.doInvoke(proxy, m, args);
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
                if (m.isAnnotationPresent(SwallowErrors.class)) {
                    return null;
                }
                throw new Exception(t.getMessage(), t);
            }
        }

        private boolean isNoHttpResponseException(Throwable t) {
            return t instanceof NoHttpResponseException || t != null && t != t.getCause() && this.isNoHttpResponseException(t.getCause());
        }

        private Object doInvoke(Object proxy, Method m, Object[] args) {
            String transactionId = null;
            try {
                JsonObject payload = JavaServiceHttpStubFactory.generatePayLoad(m, args, JavaServiceHttpStubFactory.this.authenticationManager);
                transactionId = payload.get("__tid").getAsString();
                String uri = JavaServiceHttpStubFactory.this.baseURI.toString();
                String functionName = m.getName();
                long startTime = System.currentTimeMillis();
                HttpRequestWithBody req = Unirest.post((String)uri);
                req.body(payload.toString());
                HttpResponse response = req.getHttpRequest().asString();
                long endTime = System.currentTimeMillis();
                int statusCode = response.getStatus();
                logger.trace("Status: " + statusCode);
                String json = (String)response.getBody();
                String methodName = JavaServiceHttpStubFactory.this.serviceName + "." + functionName;
                if (!JavaServiceHttpStubFactory.this.methodsExcludedFromLogging.contains(methodName)) {
                    logger.info(methodName + " E2E request finished in " + (endTime - startTime) + "ms, requestId: " + transactionId);
                }
                if (statusCode == 500) {
                    Exception exception = (Exception)new Gson().fromJson(json, Exception.class);
                    throw exception;
                }
                if (statusCode != 200) {
                    throw new RuntimeException(" error - status code: " + statusCode);
                }
                if ("null".equals(json)) {
                    return null;
                }
                try {
                    JsonParser parser = new JsonParser();
                    JsonObject result = parser.parse(json).getAsJsonObject();
                    return new Gson().fromJson(result.get("__result"), m.getGenericReturnType());
                }
                catch (Exception t) {
                    logger.error("Failed parsing json: " + json);
                    throw t;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("dtos request error, requestId: " + transactionId, t);
            }
        }
    }
}

