/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.stub;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.ktbyte.stub.JavaServiceHttpStubFactory;
import com.ktbyte.stub.SigningAuthenticationManager;
import com.ktbyte.stub.SparkServiceRequestHandler;
import com.ktbyte.stub.VerifyingAuthenticationManager;
import com.ktbyte.util.DatabaseConnection;
import com.ktbyte.util.SendEmailSmtp;
import com.ktbyte.util.StandardizedConfig;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtosWebSocketRequestHandler<T> {
    private static transient Logger log = LoggerFactory.getLogger(DtosWebSocketRequestHandler.class);
    private Class<T> serviceInterfaceType;
    private StandardizedConfig config;
    private VerifyingAuthenticationManager verifier;
    protected SigningAuthenticationManager signer;
    protected ScheduledThreadPoolExecutor threadPool = new ScheduledThreadPoolExecutor(10);
    private ConcurrentHashMap<String, TransactionInfo> tidToTransactionInfo;
    private Gson gson = new Gson();

    protected DtosWebSocketRequestHandler(StandardizedConfig config, Class<T> serviceInterfaceType) {
        this.config = config;
        this.serviceInterfaceType = serviceInterfaceType;
        this.verifier = config.getPublicKeySet();
        this.signer = config.getPrivateKey();
        this.tidToTransactionInfo = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketMessage
    public void onMessage(Session session, Reader msg) {
        block9: {
            String methodName = null;
            try {
                String tid;
                DatabaseConnection.connect();
                JsonParser parser = new JsonParser();
                JsonObject obj = parser.parse(msg).getAsJsonObject();
                JsonElement tidElement = obj.get("__tid");
                String string = tid = tidElement == null ? null : tidElement.getAsString();
                if (obj.has("__functionName")) {
                    Map params = (Map)this.gson.fromJson((JsonElement)obj, new TypeToken<Map<String, String>>(){}.getType());
                    methodName = obj.get("__functionName") + "";
                    log.debug("Calling dtos method " + methodName);
                    String ret = null;
                    try {
                        ret = SparkServiceRequestHandler.callDtosMethod(params, this.serviceInterfaceType, this, log, this.verifier);
                    }
                    catch (Exception ex) {
                        Gson gson = new Gson();
                        JsonObject payload = new JsonObject();
                        payload.addProperty("__tid", tid);
                        payload.add("__error", gson.toJsonTree((Object)ex));
                        ret = gson.toJson((JsonElement)payload);
                        log.error("Websocket DTOS Exception on tid" + tid, (Throwable)ex);
                        String exceptionStr = "tid: " + tid + "\n\n" + ExceptionUtils.getStackTrace((Throwable)ex);
                        SendEmailSmtp.get(this.config).sendCrashReport("DTOS Websocket crashed on " + methodName, exceptionStr);
                    }
                    Future future = session.getRemote().sendStringByFuture(ret);
                    log.debug("Calling dtos method " + methodName + " done... sending result");
                    future.get(5L, TimeUnit.SECONDS);
                    future.cancel(true);
                    break block9;
                }
                TransactionInfo info = this.tidToTransactionInfo.get(tid);
                if (info != null) {
                    info.returnValue = obj;
                    info.futureTask.run();
                }
            }
            catch (Exception ex) {
                log.error("Websocket DTOS Exception - Protocol level", (Throwable)ex);
                String exceptionStr = ExceptionUtils.getStackTrace((Throwable)ex);
                SendEmailSmtp.get(this.config).sendCrashReport("DTOS Websocket Protocal crashed on " + methodName, exceptionStr);
            }
            finally {
                DatabaseConnection.disconnect();
            }
        }
    }

    public <TT> TT createWebSocketInvokeStub(Supplier<Session> session, Class<TT> serviceType) {
        Object stub = Proxy.newProxyInstance(serviceType.getClassLoader(), new Class[]{serviceType}, (InvocationHandler)new WebSocketInvokeStub(session));
        return (TT)stub;
    }

    class WebSocketInvokeStub
    implements InvocationHandler {
        private Supplier<Session> webSocketSession;

        WebSocketInvokeStub(Supplier<Session> session) {
            this.webSocketSession = session;
        }

        @Override
        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            JsonObject payload = JavaServiceHttpStubFactory.generatePayLoad(m, args, DtosWebSocketRequestHandler.this.signer);
            String tid = payload.get("__tid").getAsString();
            String methodName = DtosWebSocketRequestHandler.this.serviceInterfaceType.getSimpleName() + "." + m.getName();
            log.info("Calling " + methodName);
            this.webSocketSession.get().getRemote().sendStringByFuture(payload.toString());
            FutureTask<JsonObject> futureTask = new FutureTask<JsonObject>(() -> ((TransactionInfo)((DtosWebSocketRequestHandler)DtosWebSocketRequestHandler.this).tidToTransactionInfo.get((Object)tid)).returnValue);
            TransactionInfo info = new TransactionInfo();
            info.futureTask = futureTask;
            DtosWebSocketRequestHandler.this.tidToTransactionInfo.put(tid, info);
            try {
                JsonObject retValue = futureTask.get(10L, TimeUnit.SECONDS);
                futureTask.cancel(true);
                log.info("Calling " + methodName + " done ");
                if (retValue.has("__error")) {
                    log.info(methodName + " finished with error");
                    throw (Exception)DtosWebSocketRequestHandler.this.gson.fromJson(retValue.get("__error"), Exception.class);
                }
                log.info(methodName + " finished with result");
                Object object = DtosWebSocketRequestHandler.this.gson.fromJson(retValue.get("__result"), m.getGenericReturnType());
                return object;
            }
            catch (Throwable e) {
                throw e;
            }
            finally {
                DtosWebSocketRequestHandler.this.tidToTransactionInfo.remove(tid);
            }
        }
    }

    class TransactionInfo {
        FutureTask<JsonObject> futureTask;
        JsonObject returnValue;

        TransactionInfo() {
        }
    }
}

