/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.stub;

import com.ktbyte.stub.DtosWebSocketRequestHandler;
import com.ktbyte.util.StandardizedConfig;
import java.net.ConnectException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeException;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtosWebSocketRequestClient<T>
extends DtosWebSocketRequestHandler<T> {
    private static Logger log = LoggerFactory.getLogger(DtosWebSocketRequestClient.class);
    private WebSocketClient webSocket = new WebSocketClient();
    private volatile Future<Session> sessionFuture = null;
    private URI uri;
    private boolean reconnectIfDisconnected;
    private volatile ScheduledFuture<?> reconnectFuture = null;

    protected DtosWebSocketRequestClient(String url, StandardizedConfig config, Class<T> serviceInterfaceType) {
        super(config, serviceInterfaceType);
        this.uri = URI.create(url);
    }

    public void connect(boolean reconnectIfDisconnected) {
        this.reconnectIfDisconnected = reconnectIfDisconnected;
        try {
            this.webSocket.start();
            this.sessionFuture = this.webSocket.connect((Object)this, this.uri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Session getConnectedSession() {
        if (this.sessionFuture == null) {
            throw new RuntimeException(".connect() must be called before .getConnectedSession() or after .closed()");
        }
        try {
            return this.sessionFuture.get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    @OnWebSocketClose
    public void closed(Session session, int statusCode, String reason) {
        log.warn("WebSocket to " + this.uri + " closed. Reason: " + reason);
        this.sessionFuture = null;
        if (this.reconnectIfDisconnected) {
            this.connect(this.reconnectIfDisconnected);
        }
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
    }

    @OnWebSocketError
    public void onError(Session session, Throwable cause) {
        if ((cause instanceof ConnectException || cause instanceof UpgradeException) && this.reconnectIfDisconnected) {
            if (this.reconnectFuture == null || this.reconnectFuture.isDone()) {
                log.error("Connection error... trying to reconnect to " + this.uri + " in 5 seconds");
                this.reconnectFuture = this.threadPool.schedule(() -> this.connect(this.reconnectIfDisconnected), 5L, TimeUnit.SECONDS);
            }
        } else {
            throw new RuntimeException(cause);
        }
    }
}

