/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.util.partialcontent;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedBandwidthInputStream
extends FilterInputStream {
    private final long limit;
    private long count;
    private final long startTime = System.currentTimeMillis();
    private long check;

    public LimitedBandwidthInputStream(InputStream in, long limit) {
        super(in);
        this.limit = limit;
    }

    @Override
    public int read() throws IOException {
        int found = super.read();
        this.count += found >= 0 ? 1L : 0L;
        this.check += found >= 0 ? 1L : 0L;
        this.tryLimit();
        return found;
    }

    private void tryLimit() {
        if (this.count > 2000000L && this.check >= 4096L) {
            long time = System.currentTimeMillis() - this.startTime + 1L;
            long bps = this.count * 1000L / time;
            if (bps > this.limit) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.check = 0L;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int found = super.read(b, off, len);
        this.count += found >= 0 ? (long)found : 0L;
        this.check += found >= 0 ? (long)found : 0L;
        this.tryLimit();
        return found;
    }
}

