/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.vmm.guac;

import com.ktbyte.dto.GuacUsernameConnectionHostname;
import com.ktbyte.vmm.guac.GuacConnection;
import com.ktbyte.vmm.guac.GuacConnectionParameter;
import com.ktbyte.vmm.guac.GuacConnectionPermission;
import com.ktbyte.vmm.guac.GuacUser;
import java.sql.SQLException;
import java.util.List;
import org.sql2o.Connection;
import org.sql2o.Sql2o;

public class GuacDB {
    private static Sql2o sql2o;
    private static Connection conn;

    public static void connect(String prefix, String user, String pass) {
        sql2o = new Sql2o(prefix, user, pass);
    }

    public static Connection getConnection() {
        try {
            if (conn == null || !conn.getJdbcConnection().isValid(0)) {
                conn = sql2o.open();
            }
        }
        catch (SQLException e) {
            conn = sql2o.open();
        }
        return conn;
    }

    public static <T> List<T> find(String table, Class<T> clazz) {
        String sql = "SELECT * FROM " + table;
        List results = GuacDB.getConnection().createQuery(sql).executeAndFetch(clazz);
        return results;
    }

    public static <T> void deleteByColumn(String table, String column, String value) {
        String sql = "DELETE FROM " + table + " WHERE " + column + " = :val1";
        GuacDB.getConnection().createQuery(sql).addParameter("val1", value).executeUpdate();
    }

    public static <T> void deleteByColumn(String table, String column, String value, String column2, String value2) {
        String sql = "DELETE FROM " + table + " WHERE " + column + " = :val1 AND " + column2 + " = :val2";
        GuacDB.getConnection().createQuery(sql).addParameter("val1", value).addParameter("val2", value2).executeUpdate();
    }

    public static <T> void deleteByColumn(String table, String column, String value, String column2, String value2, String column3, String value3) {
        String sql = "DELETE FROM " + table + " WHERE " + column + " = :val1 AND " + column2 + " = :val2 AND " + column3 + " = :val3";
        GuacDB.getConnection().createQuery(sql).addParameter("val1", value).addParameter("val2", value2).addParameter("val3", value3).executeUpdate();
    }

    public static <T> List<T> findByColumn(String table, String column, String value, Class<T> clazz) {
        String sql = "SELECT * FROM " + table + " WHERE " + column + " = :val1";
        List results = GuacDB.getConnection().createQuery(sql).addParameter("val1", value).executeAndFetch(clazz);
        return results;
    }

    public static <T> List<T> findByColumnLike(String table, String column, String value, Class<T> clazz) {
        String sql = "SELECT * FROM " + table + " WHERE " + column + " LIKE :val1";
        List results = GuacDB.getConnection().createQuery(sql).addParameter("val1", value).executeAndFetch(clazz);
        return results;
    }

    public static <T> List<T> findByColumn(String table, String column, String value, String column2, String value2, Class<T> clazz) {
        String sql = "SELECT * FROM " + table + " WHERE " + column + " = :val1 AND " + column2 + " = :val2";
        List results = GuacDB.getConnection().createQuery(sql).addParameter("val1", value).addParameter("val2", value2).executeAndFetch(clazz);
        return results;
    }

    public static <T> T findFirstByColumn(String table, String column, String value, Class<T> clazz) {
        List<T> results = GuacDB.findByColumn(table, column, value, clazz);
        if (results.size() == 0) {
            return null;
        }
        return results.get(0);
    }

    public static <T> T findFirstByColumnLike(String table, String column, String value, Class<T> clazz) {
        List<T> results = GuacDB.findByColumnLike(table, column, value, clazz);
        if (results.size() == 0) {
            return null;
        }
        return results.get(0);
    }

    public static <T> T findFirstByColumn(String table, String column, String value, String column2, String value2, Class<T> clazz) {
        List<T> results = GuacDB.findByColumn(table, column, value, column2, value2, clazz);
        if (results.size() == 0) {
            return null;
        }
        return results.get(0);
    }

    public static void insert(GuacConnectionPermission conn) {
        String sql = GuacConnectionPermission.insertStatement("guacamole_connection_permission");
        GuacDB.getConnection().createQuery(sql).bind((Object)conn).executeUpdate();
    }

    public static void insert(GuacConnectionParameter conn) {
        String sql = GuacConnectionParameter.insertStatement("guacamole_connection_parameter");
        GuacDB.getConnection().createQuery(sql).bind((Object)conn).executeUpdate();
    }

    public static GuacUser create(String username, String password) {
        String sql = GuacUser.insertStatement("guacamole_user", username, password);
        GuacDB.getConnection().createQuery(sql).executeUpdate();
        return GuacDB.findByColumn("guacamole_user", "username", username, GuacUser.class).get(0);
    }

    public static void insert(GuacConnection conn) {
        String sql = GuacConnection.insertStatement("guacamole_connection");
        GuacDB.getConnection().createQuery(sql).bind((Object)conn).executeUpdate();
    }

    public static void update(GuacConnection conn) {
        String sql = conn.updateStatement("guacamole_connection");
        GuacDB.getConnection().createQuery(sql).bind((Object)conn).executeUpdate();
    }

    public static void update(GuacUser user) {
        String sql = user.updateStatement("guacamole_user");
        GuacDB.getConnection().createQuery(sql).bind((Object)user).executeUpdate();
    }

    public static List<GuacUsernameConnectionHostname> getAllGuacUsernameConnectionHostname() {
        String sql = "SELECT username, guacamole_connection.connection_id, connection_name, parameter_value AS hostname FROM guacamole_user INNER JOIN guacamole_connection INNER JOIN guacamole_connection_permission INNER JOIN guacamole_connection_parameter ON guacamole_connection_parameter.connection_id = guacamole_connection.connection_id AND guacamole_user.user_id = guacamole_connection_permission.user_id AND guacamole_connection_permission.connection_id = guacamole_connection.connection_id WHERE parameter_name = 'hostname' ORDER BY username";
        List results = GuacDB.getConnection().createQuery(sql).executeAndFetch(GuacUsernameConnectionHostname.class);
        return results;
    }
}

