/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.vmm.states;

import com.ktbyte.vmm.states.DesktopInstanceState;
import java.util.List;

public enum DesktopState {
    OFF,
    BOOTING_STEP,
    BOOTING_FAILED,
    ON,
    STOPPING_STEP,
    STOPPING_FAILED,
    SYNC_FAILED,
    OTHER_FAILURE;


    public static DesktopState fromIndividualInstanceStates(List<DesktopInstanceState> instanceStates) {
        int totalNumberOfInstances = instanceStates.size();
        boolean atLeastOneMasterOff = instanceStates.stream().anyMatch(x -> x == DesktopInstanceState.MASTER_OFF);
        long numNotOff = instanceStates.stream().filter(x -> x.toString().startsWith("MASTER") && !x.equals((Object)DesktopInstanceState.MASTER_OFF)).count();
        if (atLeastOneMasterOff && numNotOff == 0L) {
            return OFF;
        }
        long numBooting = instanceStates.stream().filter(x -> x.equals((Object)DesktopInstanceState.MASTER_MOUNT_STEP) || x.equals((Object)DesktopInstanceState.MASTER_BOOT_STEP) || x.equals((Object)DesktopInstanceState.MASTER_ON_STEP)).count();
        long numSlaves = instanceStates.stream().filter(x -> x.toString().startsWith("SLAVE")).count();
        if (numBooting == 1L && numSlaves == (long)(totalNumberOfInstances - 1)) {
            return BOOTING_STEP;
        }
        long numFailedStart = instanceStates.stream().filter(x -> x.equals((Object)DesktopInstanceState.MASTER_MOUNT_FAILED) || x.equals((Object)DesktopInstanceState.MASTER_BOOT_FAILED) || x.equals((Object)DesktopInstanceState.MASTER_ON_FAILED)).count();
        if (numFailedStart > 0L) {
            return BOOTING_FAILED;
        }
        long numOn = instanceStates.stream().filter(x -> x.equals((Object)DesktopInstanceState.MASTER_ON)).count();
        if (numOn == 1L && numSlaves == (long)(totalNumberOfInstances - 1)) {
            return ON;
        }
        long numStopping = instanceStates.stream().filter(x -> x.equals((Object)DesktopInstanceState.MASTER_STOP_STEP) || x.equals((Object)DesktopInstanceState.MASTER_UNMOUNT_STEP)).count();
        if (numStopping == 1L && numSlaves == (long)(totalNumberOfInstances - 1)) {
            return STOPPING_STEP;
        }
        long numFailedStop = instanceStates.stream().filter(x -> x.equals((Object)DesktopInstanceState.MASTER_STOP_FAILED) || x.equals((Object)DesktopInstanceState.MASTER_UNMOUNT_FAILED)).count();
        if (numFailedStop > 0L) {
            return STOPPING_FAILED;
        }
        if (numSlaves == (long)totalNumberOfInstances) {
            return SYNC_FAILED;
        }
        return OTHER_FAILURE;
    }
}

