/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLoader {
    private static final transient Logger log = LoggerFactory.getLogger(ResourceLoader.class);

    public static InputStream getStream(String path) throws IOException {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
    }

    public static byte[] loadFileBytes(String file) {
        try {
            log.debug("Loading resource: " + file);
            InputStream stream = ResourceLoader.getStream(file);
            byte[] out = IOUtils.toByteArray((InputStream)stream);
            stream.close();
            return out;
        }
        catch (Exception e) {
            log.error("Failed loading file " + file + ". Exception: " + e.toString());
            return null;
        }
    }

    public static String loadFileString(String file) {
        try {
            log.debug("Loading resource: " + file);
            InputStream stream = ResourceLoader.getStream(file);
            String out = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            stream.close();
            return out;
        }
        catch (Exception e) {
            log.error("Failed loading file " + file + ". Exception: " + e.toString());
            return null;
        }
    }
}

