/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.stub;

import com.ktbyte.stub.ECPrivateKey;
import com.ktbyte.stub.VerifyingAuthenticationManager;
import java.security.SignatureException;
import java.util.HashSet;
import java.util.Set;
import org.bitcoinj.core.ECKey;
import org.spongycastle.util.encoders.Hex;

public class ECPublicKeySet
implements VerifyingAuthenticationManager {
    private Set<ECKey> pubECKey = new HashSet<ECKey>();

    public ECPublicKeySet(String ... theirPubKeys) {
        for (String theirPubKey : theirPubKeys) {
            this.pubECKey.add(ECKey.fromPublicOnly((byte[])Hex.decode((String)theirPubKey)));
        }
    }

    public ECPublicKeySet(String theirPubKey) {
        this.pubECKey.add(ECKey.fromPublicOnly((byte[])Hex.decode((String)theirPubKey)));
    }

    public ECPublicKeySet(ECPrivateKey priv) {
        this.pubECKey.add(ECKey.fromPublicOnly((byte[])Hex.decode((String)priv.getPublicKey())));
    }

    @Override
    public boolean verify(String message, String signatureHex) {
        String signatureBase64 = new String(Hex.decode((String)signatureHex));
        for (ECKey pub : this.pubECKey) {
            try {
                pub.verifyMessage(message, signatureBase64);
                return true;
            }
            catch (SignatureException signatureException) {
            }
        }
        return false;
    }
}

