/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.util;

import com.ktbyte.util.IPUtils;
import com.ktbyte.util.StandardizedConfig;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;

public class SendEmailSmtp {
    private static final transient Logger log = LoggerFactory.getLogger(SendEmailSmtp.class);
    private static SendEmailSmtp email;
    private StandardizedConfig config;

    private SendEmailSmtp(StandardizedConfig config) {
        this.config = config;
    }

    public static synchronized SendEmailSmtp get(StandardizedConfig config) {
        if (email == null) {
            email = new SendEmailSmtp(config);
            return email;
        }
        return email;
    }

    public final void logThrowable(Throwable t, Request request, String username) {
        log.error("Exception for route: " + request.pathInfo(), t);
        if (this.config.getEmailExceptions()) {
            String exceptionStr = ExceptionUtils.getStackTrace((Throwable)t);
            String route = request.pathInfo();
            String url = request.url();
            String host = request.host();
            String method = request.requestMethod();
            if (username == null) {
                username = "<anonymous>";
            }
            String emailBody = "Error on route " + route + "\nIP: " + IPUtils.getRealIp(request) + "\nurl: " + url + "\nhost: " + host + "\nmethod: " + method + "\nusername: " + username + "\nError: " + t.getClass().toString() + "\n" + exceptionStr;
            this.sendCrashReport("Exception: " + t.getClass().toString(), emailBody);
        }
        t.printStackTrace();
    }

    public void sendCrashReport(String title, String body) {
        if (this.config.getEmailExceptions()) {
            body = body + "\n\n\nbaseUrl=" + this.config.getBaseUrl();
            try {
                this.send(new String[]{"crash@ktbyte.com"}, title, body);
            }
            catch (MessagingException e) {
                log.error("beyond failure... failed to send email about failure");
            }
        }
    }

    public void sendAndCatch(String[] to, String subject, String body, boolean asHtml) {
        try {
            this.send(to, subject, body, asHtml);
        }
        catch (MessagingException e) {
            this.sendCrashReport("failed to email " + Arrays.toString(to), "subject: \n" + subject + "\n\n\nbody:\n" + body);
        }
    }

    public void send(String[] to, String subject, String body) throws AddressException, MessagingException {
        this.send(to, subject, body, false);
    }

    public void send(String[] to, String subject, String body, boolean asHtml) throws AddressException, MessagingException {
        String from = this.config.getEmailUsername();
        String pass = this.config.getEmailPassword();
        this.send(this.config.getEmailHost(), 587, from, pass, to, subject, body, true, asHtml);
    }

    public void send(String host, int port, String from, String pass, String[] to, String subject, String body, boolean ignoreSSL, boolean asHtml) throws AddressException, MessagingException {
        log.info("Sending email via " + host + ":" + port + " from " + from + " to " + to.length + " recipients with subject " + subject + ". First recipient: " + to[0]);
        Properties props = System.getProperties();
        if (ignoreSSL) {
            props.put("mail.smtp.ssl.trust", "*");
        }
        if (port != 25) {
            props.put("mail.smtp.starttls.enable", "true");
        }
        props.put("mail.smtp.host", host);
        if (pass != null) {
            props.put("mail.smtp.user", from);
        }
        if (pass != null) {
            props.put("mail.smtp.password", pass);
        }
        props.put("mail.smtp.port", "" + port);
        if (pass != null) {
            props.put("mail.smtp.auth", "true");
        }
        Session session = Session.getDefaultInstance((Properties)props);
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(from));
        InternetAddress[] toAddress = new InternetAddress[to.length];
        for (int i = 0; i < toAddress.length; ++i) {
            String toSingle = to[i];
            String EMAIL_PATTERN = "([_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,}))";
            Pattern pattern = Pattern.compile(EMAIL_PATTERN);
            Matcher matcher = pattern.matcher(toSingle);
            while (matcher.find()) {
                String email = matcher.group(1).toLowerCase().trim();
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(email));
            }
        }
        message.setSentDate(new Date());
        message.setSubject(subject);
        if (asHtml) {
            message.setText(body, "utf-8", "html");
        } else {
            message.setText(body);
        }
        Transport transport = session.getTransport("smtp");
        transport.connect(host, from, pass);
        transport.sendMessage((Message)message, message.getAllRecipients());
        transport.close();
    }

    public boolean validateEmails(String[] addresses) {
        for (String address : addresses) {
            if (this.validateEmail(address)) continue;
            return false;
        }
        return true;
    }

    public boolean validateEmail(String address) {
        try {
            new InternetAddress(address);
        }
        catch (AddressException e) {
            return false;
        }
        return true;
    }
}

