/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.util.partialcontent;

import com.ktbyte.util.partialcontent.SeekableInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.commons.io.input.CountingInputStream;

public class RandomAccessFileBufferedInputStream
extends SeekableInputStream {
    private final RandomAccessFile raf;
    private final FileInputStream fin;
    private final long startPosition;
    private CountingInputStream cin;
    private long pos;

    public RandomAccessFileBufferedInputStream(File file, long offset) throws IOException {
        this(RandomAccessFileBufferedInputStream.raf(file, offset));
    }

    private static RandomAccessFile raf(File file, long offset) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        if (offset != 0L) {
            RandomAccessFileBufferedInputStream.forceSeek(raf, offset);
        }
        return raf;
    }

    public RandomAccessFileBufferedInputStream(File file) throws IOException {
        this(RandomAccessFileBufferedInputStream.raf(file, 0L));
    }

    public RandomAccessFileBufferedInputStream(RandomAccessFile raf) throws IOException {
        this.raf = raf;
        this.fin = new FileInputStream(raf.getFD());
        this.startPosition = raf.getFilePointer();
        this._reset();
    }

    private void _reset() throws IOException {
        this.pos = this.raf.getFilePointer() - this.startPosition;
        this.cin = new CountingInputStream((InputStream)new BufferedInputStream(this.fin, 4096));
    }

    @Override
    public int read() throws IOException {
        return this.checkRead(this.cin.read());
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.checkRead(this.cin.read(b));
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.checkRead(this.cin.read(b, off, len));
    }

    @Override
    public void close() throws IOException {
        this.cin.close();
        this.cin = null;
        this.raf.close();
    }

    @Override
    public long seek(long position) throws IOException {
        this.checkIdx(position);
        RandomAccessFileBufferedInputStream.forceSeek(this.raf, this.startPosition + position);
        this._reset();
        return this.position();
    }

    @Override
    public long position() throws IOException {
        return this.pos + this.cin.getByteCount();
    }

    @Override
    public long length() {
        try {
            return this.raf.length() - this.startPosition;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static long forceSeek(RandomAccessFile raf, long offset) throws IOException {
        long length = raf.length();
        if (offset >= length) {
            throw new IllegalStateException("trying to seek to (" + offset + ") outside of len (" + length + ")");
        }
        raf.seek(offset);
        if (offset != raf.getFilePointer()) {
            throw new IllegalStateException("seek failed");
        }
        return offset;
    }
}

