/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtil {
    private static final transient Logger log = LoggerFactory.getLogger(ZipUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzip(InputStream istream, String destinationPath, long maxBytesUnzippedLimit) throws IOException {
        ZipInputStream zis = null;
        try {
            ZipEntry entry;
            zis = new ZipInputStream(istream);
            long bytesUnzipped = 0L;
            while ((entry = zis.getNextEntry()) != null) {
                long entrySize = entry.getSize();
                if (entrySize != -1L && entrySize + bytesUnzipped > maxBytesUnzippedLimit) {
                    throw new IOException("Extracted zip file excees size limit of " + maxBytesUnzippedLimit + " bytes.");
                }
                File entryFile = new File(destinationPath, entry.getName());
                if (entry.isDirectory()) {
                    if (entryFile.exists()) {
                        log.warn("Directory " + entryFile + " already exists!");
                        continue;
                    }
                    entryFile.mkdirs();
                    continue;
                }
                if (entryFile.getParentFile() != null && !entryFile.getParentFile().exists()) {
                    entryFile.getParentFile().mkdirs();
                }
                if (!entryFile.exists()) {
                    entryFile.createNewFile();
                }
                FileOutputStream os = null;
                try {
                    os = new FileOutputStream(entryFile);
                    bytesUnzipped += (long)IOUtils.copy((InputStream)zis, (OutputStream)os);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)os);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zis);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)zis);
    }
}

