/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.stub;

import com.ktbyte.stub.SigningAuthenticationManager;
import java.security.SignatureException;
import org.bitcoinj.core.ECKey;
import org.spongycastle.util.encoders.Hex;

public class ECPrivateKey
implements SigningAuthenticationManager {
    private ECKey privECKey;

    public ECPrivateKey(String myPrivKey) {
        this.privECKey = ECKey.fromPrivate((byte[])Hex.decode((String)myPrivKey));
    }

    public ECPrivateKey() {
        this.privECKey = new ECKey();
    }

    @Override
    public String sign(String message) {
        return Hex.toHexString((byte[])this.privECKey.signMessage(message).getBytes());
    }

    public String getPrivKey() {
        return this.privECKey.getPrivateKeyAsHex();
    }

    public String getPublicKey() {
        return Hex.toHexString((byte[])this.privECKey.getPubKey());
    }

    public boolean verify(String message, String signatureHex) {
        String signatureBase64 = new String(Hex.decode((String)signatureHex));
        try {
            this.privECKey.verifyMessage(message, signatureBase64);
        }
        catch (SignatureException e) {
            return false;
        }
        return true;
    }
}

