/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.vmm.guac;

import com.ktbyte.vmm.guac.GuacConnection;
import com.ktbyte.vmm.guac.GuacConnectionHistory;
import com.ktbyte.vmm.guac.GuacConnectionParameter;
import com.ktbyte.vmm.guac.GuacConnectionPermission;
import com.ktbyte.vmm.guac.GuacDB;
import com.ktbyte.vmm.guac.GuacUser;
import com.ktbyte.vmm.guac.GuacUserPermission;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GuacStudentConnections {
    private GuacUser student;
    private GuacConnection rdp;
    private GuacConnection vnc;
    private List<GuacUserPermission> userPermissions;
    private List<GuacConnectionHistory> rdpHistory;
    private List<GuacConnectionParameter> rdpParameters;
    private List<GuacConnectionPermission> rdpPermissions;
    private List<GuacConnectionHistory> vncHistory;
    private List<GuacConnectionParameter> vncParameters;
    private List<GuacConnectionPermission> vncPermissions;

    public GuacUser getStudent() {
        return this.student;
    }

    public GuacConnection getRdp() {
        return this.rdp;
    }

    public GuacConnection getVnc() {
        return this.vnc;
    }

    public List<GuacUserPermission> getUserPermissions() {
        return this.userPermissions;
    }

    public List<GuacConnectionHistory> getRdpHistory() {
        return this.rdpHistory;
    }

    public List<GuacConnectionParameter> getRdpParameters() {
        return this.rdpParameters;
    }

    public List<GuacConnectionPermission> getRdpPermissions() {
        return this.rdpPermissions;
    }

    public List<GuacConnectionHistory> getVncHistory() {
        return this.vncHistory;
    }

    public List<GuacConnectionParameter> getVncParameters() {
        return this.vncParameters;
    }

    public List<GuacConnectionPermission> getVncPermissions() {
        return this.vncPermissions;
    }

    public static GuacStudentConnections fromUser(String username) {
        GuacStudentConnections out = new GuacStudentConnections();
        if (username == null || username.length() < 2) {
            return out;
        }
        out.student = GuacDB.findFirstByColumn("guacamole_user", "username", username, GuacUser.class);
        out.userPermissions = GuacDB.findByColumn("guacamole_user_permission", "affected_user_id", "" + out.student.getUser_id(), GuacUserPermission.class);
        out.rdpPermissions = GuacDB.findByColumn("guacamole_connection_permission", "user_id", "" + out.student.getUser_id(), GuacConnectionPermission.class);
        try {
            out.rdp = GuacDB.findFirstByColumn("guacamole_connection", "connection_id", "" + out.rdpPermissions.get(0).getConnection_id(), GuacConnection.class);
            out.rdpHistory = GuacDB.findByColumn("guacamole_connection_history", "connection_id", "" + out.rdp.getConnection_id(), "user_id", "" + out.student.getUser_id(), GuacConnectionHistory.class);
            out.rdpParameters = GuacDB.findByColumn("guacamole_connection_parameter", "connection_id", "" + out.rdp.getConnection_id(), GuacConnectionParameter.class);
            if (out.rdp.getConnection_name().contains("linux")) {
                out.vnc = out.rdp;
                out.vncHistory = out.rdpHistory;
                out.vncParameters = out.rdpParameters;
                out.vncPermissions = out.rdpPermissions;
            } else {
                Pattern p = Pattern.compile("student([0-9]*)");
                Matcher m = p.matcher(out.rdp.getConnection_name());
                if (!m.find()) {
                    p = Pattern.compile("winacct([0-9]*)");
                    m = p.matcher(out.rdp.getConnection_name());
                    m.find();
                }
                String vmAccountNumber = m.group(1);
                String sql = "SELECT * FROM guacamole_connection WHERE (connection_name LIKE \"%winacct" + vmAccountNumber + "%\" OR connection_name LIKE \"%student" + vmAccountNumber + "%\") AND protocol = \"vnc\"";
                out.vnc = (GuacConnection)GuacDB.getConnection().createQuery(sql).executeAndFetch(GuacConnection.class).get(0);
                out.vncHistory = GuacDB.findByColumn("guacamole_connection_history", "connection_id", "" + out.vnc.getConnection_id(), GuacConnectionHistory.class);
                out.vncParameters = GuacDB.findByColumn("guacamole_connection_parameter", "connection_id", "" + out.vnc.getConnection_id(), GuacConnectionParameter.class);
                out.vncPermissions = GuacDB.findByColumn("guacamole_connection_permission", "connection_id", "" + out.vnc.getConnection_id(), GuacConnectionPermission.class);
            }
        }
        catch (Exception e) {
            System.err.println("Could not find RDP/VNC for " + username);
        }
        return out;
    }
}

