/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.util.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class MessageDigestPasswordEncoderSha512 {
    public static String encodePassword(String password, String salt) {
        try {
            String salted = MessageDigestPasswordEncoderSha512.mergePasswordAndSalt(password, salt);
            MessageDigest mda = MessageDigest.getInstance("SHA-512");
            byte[] digest = mda.digest(salted.getBytes());
            for (int i = 1; i < 5000; ++i) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                outputStream.write(digest);
                outputStream.write(salted.getBytes());
                digest = mda.digest(outputStream.toByteArray());
            }
            return new String(Base64.encodeBase64((byte[])digest));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String mergePasswordAndSalt(String password, String salt) {
        return password + "{" + salt + "}";
    }

    public static String generateSalt() {
        SecureRandom r = new SecureRandom();
        byte[] bytes = new byte[20];
        r.nextBytes(bytes);
        String salt = new String(bytes);
        try {
            MessageDigest mda = MessageDigest.getInstance("SHA-512");
            byte[] digest = mda.digest(salt.getBytes());
            for (int i = 1; i < 5000; ++i) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                outputStream.write(digest);
                outputStream.write(salt.getBytes());
                digest = mda.digest(outputStream.toByteArray());
            }
            return new String(Base64.encodeBase64((byte[])digest));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String hexSha512(String data) {
        try {
            MessageDigest mda = MessageDigest.getInstance("SHA-512");
            byte[] digest = mda.digest(data.getBytes());
            return Hex.encodeHexString((byte[])digest);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String hexSha256(String data) {
        try {
            MessageDigest mda = MessageDigest.getInstance("SHA-256");
            byte[] digest = mda.digest(data.getBytes());
            return Hex.encodeHexString((byte[])digest);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String base64Sha512(String data) {
        try {
            MessageDigest mda = MessageDigest.getInstance("SHA-512");
            byte[] digest = mda.digest(data.getBytes());
            return new String(Base64.encodeBase64((byte[])digest));
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String base64Sha256(String data) {
        try {
            MessageDigest mda = MessageDigest.getInstance("SHA-256");
            byte[] digest = mda.digest(data.getBytes());
            return new String(Base64.encodeBase64((byte[])digest));
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }
}

