/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.dto;

import com.ktbyte.dto.ClassSessionDTO;
import com.ktbyte.dto.DiscountDTO;
import com.ktbyte.dto.Enrollment;
import com.ktbyte.enums.EnumeratedPaymentStatus;
import java.util.ArrayList;
import java.util.List;

public class EnrollmentCartItemDTO {
    private String classSession;
    private String semester;
    private String timeSlot;
    private EnumeratedPaymentStatus status;
    private String studentUsername;
    private int studentid;
    private int parentid;
    private int fee;
    private String grouptag;
    private List<DiscountDTO> discounts = new ArrayList<DiscountDTO>();
    private String coupon;
    private ClassSessionDTO clazz;

    public void setCoupon(String coupon) {
        this.coupon = coupon;
    }

    public int getCost() {
        return this.fee - this.getTotalDiscount();
    }

    public int getTotalDiscount() {
        int sum = 0;
        for (DiscountDTO d : this.discounts) {
            sum += d.amount;
        }
        return sum;
    }

    public void clearDiscounts() {
        this.discounts.clear();
    }

    public void addDiscount(int discount, String message) {
        this.discounts.add(new DiscountDTO(discount, message));
    }

    public List<DiscountDTO> getDiscounts() {
        return this.discounts;
    }

    public String getCoupon() {
        return this.coupon;
    }

    public ClassSessionDTO getClassSessionObject() {
        return this.clazz;
    }

    public EnrollmentCartItemDTO(ClassSessionDTO clazz, int studentid2, int parentid2, String grouptag2, String fee, String chosenClassSession, String chosenTimeSlot, String studentUsername, String coupon, EnumeratedPaymentStatus status) {
        this.clazz = clazz;
        this.studentid = studentid2;
        this.parentid = parentid2;
        this.grouptag = grouptag2;
        this.fee = Integer.parseInt(fee);
        this.classSession = chosenClassSession;
        this.timeSlot = chosenTimeSlot;
        this.status = status;
        this.coupon = coupon;
        this.studentUsername = studentUsername;
    }

    public String getClassSession() {
        return this.classSession;
    }

    public String getTimeSlot() {
        return this.timeSlot;
    }

    public int getStudentid() {
        return this.studentid;
    }

    public int getParentid() {
        return this.parentid;
    }

    public String getStudentUsername() {
        return this.studentUsername;
    }

    public int getFee() {
        return this.fee;
    }

    public EnumeratedPaymentStatus getStatus() {
        return this.status;
    }

    public String getGrouptag() {
        return this.grouptag;
    }

    public boolean inCart() {
        return this.status == EnumeratedPaymentStatus.IN_CART;
    }

    public Enrollment getEnrollment(String paymentNotes, boolean paidCC, boolean paidWeChat) {
        String WECHAT_PAID = "PaidWeChatChargeable";
        Enrollment e = new Enrollment();
        e.session_serialized = this.getGrouptag();
        e.coupon = this.getCoupon();
        e.payment_status = paidCC || paidWeChat && paymentNotes.equals(WECHAT_PAID) ? EnumeratedPaymentStatus.PAID : EnumeratedPaymentStatus.PAYMENT_PENDING;
        Integer payAmount = this.getCost();
        if (paidCC || paidWeChat) {
            e.payment_amount = payAmount;
        } else {
            paymentNotes = paymentNotes + " fee_" + payAmount;
        }
        e.payment_notes = paymentNotes;
        e.enrolled = true;
        return e;
    }
}

