/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.service;

import com.ktbyte.stub.CronJob;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCronService {
    private final transient Logger log = LoggerFactory.getLogger(TaskCronService.class);
    private static final ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(4);
    private final List<CronJob> cronJobs;
    private final long initialDelay = 0L;

    public TaskCronService(CronJob ... cronJobs) {
        this.cronJobs = Arrays.asList(cronJobs);
        this.startTasks();
    }

    private void startTasks() {
        this.cronJobs.forEach(c -> executorService.scheduleAtFixedRate((Runnable)c, 0L, c.intervalSeconds(), TimeUnit.SECONDS));
        this.log.info("Started " + this.cronJobs.size() + " cron tasks.");
    }
}

