/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.stub;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.ktbyte.annotation.Authenticate;
import com.ktbyte.annotation.ContainsRequest;
import com.ktbyte.stub.ServiceProvider;
import com.ktbyte.stub.VerifyingAuthenticationManager;
import com.ktbyte.util.SendEmailSmtp;
import com.ktbyte.util.StandardizedConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import spark.Request;
import spark.Response;
import spark.Route;
import spark.Spark;

public abstract class SparkServiceRequestHandler<T> {
    Logger log;
    Class<T> serviceType;
    T serviceInstance;
    ServiceProvider<T> serviceProvider;
    StandardizedConfig config;
    boolean isServiceProvider;
    private VerifyingAuthenticationManager authManager;

    private SparkServiceRequestHandler(StandardizedConfig config, Logger log, Class<T> serviceType, VerifyingAuthenticationManager authManager) {
        this.log = log;
        this.serviceType = serviceType;
        this.authManager = authManager;
        this.config = config;
    }

    public SparkServiceRequestHandler(StandardizedConfig config, Logger log, Class<T> serviceType, T serviceInstance, VerifyingAuthenticationManager authManager) {
        this(config, log, serviceType, authManager);
        this.serviceInstance = serviceInstance;
        this.isServiceProvider = false;
        this.init();
    }

    public SparkServiceRequestHandler(StandardizedConfig config, Logger log, Class<T> serviceType, ServiceProvider<T> serviceProvider, VerifyingAuthenticationManager authManager) {
        this(config, log, serviceType, authManager);
        this.serviceProvider = serviceProvider;
        this.isServiceProvider = true;
        this.init();
    }

    protected abstract void init();

    protected final void registerServiceRoute(Route route) {
        try {
            Spark.post((String)("/services/" + this.serviceType.getSimpleName()), (String)"application/json", (Route)route);
        }
        catch (Exception e) {
            this.log.error("service declaration error for " + this.serviceType, (Throwable)e);
        }
    }

    protected final void registerServiceRoute(Route route, String urlPrefix) {
        try {
            Spark.get((String)(urlPrefix + "/services/" + this.serviceType.getSimpleName()), (String)"application/json", (Route)route);
            Spark.post((String)(urlPrefix + "/services/" + this.serviceType.getSimpleName()), (String)"application/json", (Route)route);
        }
        catch (Exception e) {
            this.log.error("service declaration error for " + this.serviceType, (Throwable)e);
        }
    }

    protected final Object handleServiceRequest(Request request, Response response, String currentUsername) {
        try {
            T actualServiceInstance = this.isServiceProvider ? this.serviceProvider.getServiceInstance(request, response) : this.serviceInstance;
            response.type("application/json");
            response.header("Content-Encoding", "gzip");
            Type mapType = new TypeToken<TreeMap<String, String>>(){}.getType();
            Map params = null;
            if (request.queryParams("__functionName") == null || request.queryParams("__functionName").length() == 0) {
                try {
                    String body = request.body();
                    params = (Map)new Gson().fromJson(body, mapType);
                    this.log.info("dtos service params from user '" + currentUsername + "': " + params);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed parsing __functionName");
                }
            }
            this.log.debug("handling service request with params: " + request.queryParams());
            String functionName = params == null ? request.queryParams("__functionName") : (String)params.get("__functionName");
            Method method = null;
            for (Method m : this.serviceType.getDeclaredMethods()) {
                if (!m.getName().equals(functionName)) continue;
                method = m;
                break;
            }
            if (method != null) {
                this.log.debug("found service method: " + method);
                ArrayList<Object> args = new ArrayList<Object>();
                if (method.isAnnotationPresent(ContainsRequest.class)) {
                    args.add(request);
                    args.add(response);
                }
                for (Parameter param : method.getParameters()) {
                    this.log.debug("adding arg " + param.getName() + " : " + param.getType());
                    if ("arg0".equals(param.getName())) {
                        this.log.error("service class " + this.serviceType + " should be compiled with -parameters option");
                        throw new RuntimeException();
                    }
                    args.add(new Gson().fromJson(params == null ? request.queryParams(param.getName()) : (String)params.get(param.getName()), param.getParameterizedType()));
                }
                if (method.isAnnotationPresent(Authenticate.class)) {
                    long remoteTime;
                    String timeStr = params == null ? request.queryParams("__time") : (String)params.get("__time");
                    String sig = params == null ? request.queryParams("__sig") : (String)params.get("__sig");
                    long time = System.currentTimeMillis();
                    if (Math.abs(time - (remoteTime = Long.parseLong(timeStr))) > 3600000L) {
                        return "error: invalid timestamp. local: " + time + " remote: " + remoteTime;
                    }
                    boolean verified = this.authManager.verify("" + remoteTime, sig);
                    if (!verified) {
                        HashMap<String, Exception> out = new HashMap<String, Exception>();
                        Exception exception = new Exception("Could not verify signature");
                        out.put("__exception", exception);
                        String error = new Gson().toJson(out);
                        return error;
                    }
                }
                try {
                    Object result = method.invoke(actualServiceInstance, args.toArray());
                    return new Gson().toJson(result);
                }
                catch (InvocationTargetException e) {
                    HashMap<String, Throwable> out = new HashMap<String, Throwable>();
                    out.put("__exception", e.getCause());
                    e.printStackTrace();
                    SendEmailSmtp.get(this.config).logThrowable(e, request, currentUsername);
                    String error = new Gson().toJson(out);
                    return error;
                }
            }
            this.log.error("function " + functionName + " not found in " + this.serviceType + " (" + actualServiceInstance + ")");
            throw new RuntimeException();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

