/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.stub;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ktbyte.annotation.Authenticate;
import com.ktbyte.annotation.Retry;
import com.ktbyte.annotation.SwallowErrors;
import com.ktbyte.service.CrmMakeupsService;
import com.ktbyte.service.KtbyteCrmEmailService;
import com.ktbyte.service.KtbyteCrmService;
import com.ktbyte.service.KtbyteCrmTaskService;
import com.ktbyte.service.KtbyteEarthReplicationService;
import com.ktbyte.service.KtbyteEarthService;
import com.ktbyte.service.KtbyteEarthTaskService;
import com.ktbyte.service.MakeupsService;
import com.ktbyte.service.ProcessingCompilationService;
import com.ktbyte.service.VMMService;
import com.ktbyte.stub.SigningAuthenticationManager;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.request.HttpRequestWithBody;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaServiceHttpStubFactory {
    private static Logger logger = LoggerFactory.getLogger(JavaServiceHttpStubFactory.class);
    private URI baseURI;
    private SigningAuthenticationManager authenticationManager;

    public JavaServiceHttpStubFactory(URI baseURI, SigningAuthenticationManager authenticationManager) {
        this.baseURI = baseURI;
        this.authenticationManager = authenticationManager;
    }

    private <T> T createDynamicStub(Class<T> serviceType) {
        Object stub = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{serviceType}, (InvocationHandler)new GenericStub());
        return (T)stub;
    }

    public String getURIPath() {
        return this.baseURI.toString();
    }

    public ProcessingCompilationService createProcessingCompilationService() {
        return this.createDynamicStub(ProcessingCompilationService.class);
    }

    public KtbyteCrmService createKtbyteCrmService() {
        return this.createDynamicStub(KtbyteCrmService.class);
    }

    public KtbyteCrmTaskService createCrmTaskService() {
        return this.createDynamicStub(KtbyteCrmTaskService.class);
    }

    public KtbyteEarthTaskService createEarthTaskService() {
        return this.createDynamicStub(KtbyteEarthTaskService.class);
    }

    public CrmMakeupsService createCrmMakeupsService() {
        return this.createDynamicStub(CrmMakeupsService.class);
    }

    public MakeupsService createMakeupsService() {
        return this.createDynamicStub(MakeupsService.class);
    }

    public KtbyteCrmEmailService createCrmEmailService() {
        return this.createDynamicStub(KtbyteCrmEmailService.class);
    }

    public KtbyteEarthService createKtbyteEarthService() {
        return this.createDynamicStub(KtbyteEarthService.class);
    }

    public KtbyteEarthReplicationService createKtbyteEarthReplicationService() {
        return this.createDynamicStub(KtbyteEarthReplicationService.class);
    }

    public VMMService createVmmService() {
        return this.createDynamicStub(VMMService.class);
    }

    class GenericStub
    implements InvocationHandler {
        GenericStub() {
        }

        @Override
        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            try {
                return this.doInvoke(proxy, m, args);
            }
            catch (Throwable t) {
                if (m.isAnnotationPresent(Retry.class)) {
                    int retries = m.getAnnotation(Retry.class).value();
                    while (retries-- > 0) {
                        try {
                            Thread.sleep((int)(Math.random() * 1000.0 + 1.0));
                            return this.doInvoke(proxy, m, args);
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
                if (m.isAnnotationPresent(SwallowErrors.class)) {
                    return null;
                }
                throw new Exception(t.getMessage(), t);
            }
        }

        private Object doInvoke(Object proxy, Method m, Object[] args) throws Throwable {
            Exception exception = null;
            try {
                String uri = JavaServiceHttpStubFactory.this.baseURI.toString();
                logger.debug("Preparing remote call to " + uri);
                Gson gson = new Gson();
                JsonObject payload = new JsonObject();
                for (int i = 0; i < m.getParameters().length; ++i) {
                    String paramName = m.getParameters()[i].getName();
                    if ("arg0".equals(paramName)) {
                        logger.error("service class " + m.getDeclaringClass() + " should be compiled with -parameters option");
                    }
                    payload.addProperty(paramName, gson.toJson(args[i]));
                }
                payload.addProperty("__tid", UUID.randomUUID().toString());
                payload.addProperty("__functionName", m.getName());
                String timeStr = "" + System.currentTimeMillis();
                payload.addProperty("__time", timeStr);
                if (JavaServiceHttpStubFactory.this.authenticationManager != null && m.isAnnotationPresent(Authenticate.class)) {
                    payload.addProperty("__sig", JavaServiceHttpStubFactory.this.authenticationManager.sign(timeStr));
                }
                HttpRequestWithBody req = Unirest.post((String)uri);
                req.body(payload.toString());
                HttpResponse response = req.getHttpRequest().asString();
                int statusCode = response.getStatus();
                logger.trace("Status: " + statusCode);
                if (statusCode != 200) {
                    throw new RuntimeException(" error - status code: " + statusCode);
                }
                String json = (String)response.getBody();
                if ("null".equals(json)) {
                    return null;
                }
                try {
                    if (!json.startsWith("{\"__exception")) {
                        return new Gson().fromJson(json, m.getGenericReturnType());
                    }
                    Map out = (Map)new Gson().fromJson(json, new TypeToken<Map<String, Exception>>(){}.getType());
                    exception = (Exception)out.get("__exception");
                }
                catch (Exception t) {
                    logger.error("Failed parsing json: " + json);
                    throw new RuntimeException(t.getMessage(), t);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t.getMessage(), t);
            }
            if (exception != null) {
                throw exception;
            }
            throw new RuntimeException("Null Exception Unexpected");
        }
    }
}

