/*
 * Decompiled with CFR 0.152.
 */
package com.ktbyte.stub;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebFetcher {
    private static String USER_AGENT = "ktbyte:com.ktbyte.mimi:v0.0.2";
    private static final transient Logger log = LoggerFactory.getLogger(WebFetcher.class);

    public static String getHTML(URL url) {
        return WebFetcher.getHTML(url, 3);
    }

    public static String getHTML(URL url, int followRedircts) {
        if (followRedircts < 0) {
            return null;
        }
        log.info("Fetching: " + url);
        try {
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.addRequestProperty("User-Agent", USER_AGENT);
            urlConnection.setInstanceFollowRedirects(true);
            urlConnection.setConnectTimeout(5000);
            urlConnection.setReadTimeout(5000);
            HttpURLConnection.setFollowRedirects(true);
            boolean redirect = false;
            int status = urlConnection.getResponseCode();
            if (status != 200 && (status == 302 || status == 301 || status == 303)) {
                redirect = true;
            }
            if (redirect) {
                String newUrl = urlConnection.getHeaderField("Location");
                return WebFetcher.getHTML(new URL(newUrl), followRedircts - 1);
            }
            InputStream inputStream = urlConnection.getInputStream();
            String html = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            inputStream.close();
            return html;
        }
        catch (Exception e) {
            log.warn("Fail to fetch: " + url, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String fetchURL(String url) throws MalformedURLException, IOException {
        return WebFetcher.getHTML(new URL(url));
    }

    public static String fetchURL(String url, int wait, int tries) {
        for (int i = 0; i < tries; ++i) {
            try {
                Thread.sleep(wait);
                return WebFetcher.getHTML(new URL(url));
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public static String[] fetchJsonStringArray(String url) throws JsonSyntaxException, MalformedURLException, IOException {
        return (String[])new Gson().fromJson(WebFetcher.fetchURL(url), String[].class);
    }

    public static Map<Object, Object> fetchJsonMap(String url) throws JsonSyntaxException, MalformedURLException, IOException {
        return (Map)new Gson().fromJson(WebFetcher.fetchURL(url), Map.class);
    }

    public static String getContentType(String urlname) throws IOException {
        URL url = new URL(urlname);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.setRequestMethod("HEAD");
        connection.connect();
        return connection.getContentType();
    }

    public static String fetchSection(String content, String startKeyword, String endKeyword) {
        content = content.toLowerCase();
        int startIndex = content.indexOf(startKeyword.toLowerCase());
        int endIndex = content.lastIndexOf(endKeyword.toLowerCase());
        if (startIndex >= 0 && endIndex >= 0) {
            return content.substring(startIndex, endIndex);
        }
        return "";
    }

    public static List fetchJsonList(String url) throws JsonSyntaxException, MalformedURLException, IOException {
        return (List)new Gson().fromJson(WebFetcher.fetchURL(url), List.class);
    }

    public static String getURL(String url, List<NameValuePair> headers) throws IOException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet post = new HttpGet(url);
        post.setHeader("User-Agent", USER_AGENT);
        if (headers != null) {
            for (NameValuePair pair : headers) {
                post.setHeader(pair.getName(), pair.getValue());
            }
        }
        HttpResponse response = client.execute((HttpUriRequest)post);
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        StringBuffer result = new StringBuffer();
        String line = "";
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        return result.toString();
    }

    public static String postURL(String url, List<NameValuePair> headers, List<NameValuePair> urlParameters) throws IOException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost(url);
        post.setHeader("User-Agent", USER_AGENT);
        if (headers != null) {
            for (NameValuePair pair : headers) {
                post.setHeader(pair.getName(), pair.getValue());
            }
        }
        if (urlParameters != null) {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters));
        }
        HttpResponse response = client.execute((HttpUriRequest)post);
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        StringBuffer result = new StringBuffer();
        String line = "";
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        return result.toString();
    }

    public static HttpClient createHttpClient_AcceptsUntrustedCerts() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        HttpClientBuilder b = HttpClientBuilder.create();
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new MyTrustTrategy()).build();
        b.setSSLContext(sslContext);
        NoopHostnameVerifier hostnameVerifier = new NoopHostnameVerifier();
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        b.setConnectionManager((HttpClientConnectionManager)connMgr);
        CloseableHttpClient client = b.build();
        return client;
    }

    public static class MyTrustTrategy
    implements TrustStrategy {
        public boolean isTrusted(X509Certificate[] a, String b) throws CertificateException {
            return true;
        }
    }
}

