/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.ssh;

import com.jcabi.aspects.RetryOnFailure;
import com.jcabi.ssh.AbstractSSHShell;
import com.jcabi.ssh.JschLogger;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;

public final class SSHByPassword
extends AbstractSSHShell {
    private final transient String password;

    public SSHByPassword(String adr, int prt, String user, String passwd) throws UnknownHostException {
        super(adr, prt, user);
        this.password = passwd;
    }

    @Override
    @RetryOnFailure(attempts=7, delay=1L, unit=TimeUnit.MINUTES, verbose=false, randomize=true, types={IOException.class})
    protected Session session() throws IOException {
        try {
            JSch.setConfig((String)"StrictHostKeyChecking", (String)"no");
            JSch.setLogger((Logger)new JschLogger());
            JSch jsch = new JSch();
            com.jcabi.log.Logger.debug((Object)this, (String)"Opening SSH session to %s@%s:%s (auth with password)...", (Object[])new Object[]{this.getLogin(), this.getAddr(), this.getPort()});
            Session session = jsch.getSession(this.getLogin(), this.getAddr(), this.getPort());
            session.setPassword(this.password);
            session.setServerAliveInterval((int)TimeUnit.SECONDS.toMillis(10L));
            session.setServerAliveCountMax(1000000);
            session.connect();
            return session;
        }
        catch (JSchException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public String toString() {
        return "SSHByPassword(password=" + this.password + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SSHByPassword)) {
            return false;
        }
        SSHByPassword other = (SSHByPassword)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$password = this.password;
        String other$password = other.password;
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SSHByPassword;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $password = this.password;
        result = result * 59 + ($password == null ? 0 : $password.hashCode());
        return result;
    }
}

