/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.ssh;

import com.jcabi.ssh.Execution;
import com.jcabi.ssh.Shell;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.Validate;

abstract class AbstractSSHShell
implements Shell {
    private final transient String addr;
    private final transient int port;
    private final transient String login;

    AbstractSSHShell(String adr, int prt, String user) throws UnknownHostException {
        this.addr = InetAddress.getByName(adr).getHostAddress();
        this.port = prt;
        this.login = user;
        Validate.matchesPattern((CharSequence)this.addr, (String)"\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}", (String)"Invalid IP address of the server `%s`", (Object[])new Object[]{this.addr});
        Validate.notEmpty((CharSequence)user, (String)"user name can't be empty", (Object[])new Object[0]);
    }

    @Override
    public int exec(String command, InputStream stdin, OutputStream stdout, OutputStream stderr) throws IOException {
        return new Execution.Default(command, stdin, stdout, stderr, this.session()).exec();
    }

    protected abstract Session session() throws IOException;

    public String toString() {
        return "AbstractSSHShell(addr=" + this.getAddr() + ", port=" + this.getPort() + ", login=" + this.getLogin() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractSSHShell)) {
            return false;
        }
        AbstractSSHShell other = (AbstractSSHShell)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$addr = this.getAddr();
        String other$addr = other.getAddr();
        if (this$addr == null ? other$addr != null : !this$addr.equals(other$addr)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$login = this.getLogin();
        String other$login = other.getLogin();
        return !(this$login == null ? other$login != null : !this$login.equals(other$login));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractSSHShell;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $addr = this.getAddr();
        result = result * 59 + ($addr == null ? 0 : $addr.hashCode());
        result = result * 59 + this.getPort();
        String $login = this.getLogin();
        result = result * 59 + ($login == null ? 0 : $login.hashCode());
        return result;
    }

    public String getAddr() {
        return this.addr;
    }

    public int getPort() {
        return this.port;
    }

    public String getLogin() {
        return this.login;
    }
}

